/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import io.confluent.cruisecontrol.analyzer.goals.CellPartitionRelocator;
import io.confluent.cruisecontrol.analyzer.goals.TenantTopicDistributionStrategy;
import io.confluent.cruisecontrol.analyzer.goals.TopicRebalanceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kafka.common.TenantHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTopicPartitionDistributionBasedStrategy
implements TenantTopicDistributionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TenantTopicPartitionDistributionBasedStrategy.class);
    private Map<String, Double> averageTopicPartitionsPerCell;
    private List<String> eligibleTopicsForRebalance;
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores;

    public TenantTopicPartitionDistributionBasedStrategy() {
        this.averageTopicPartitionsPerCell = new HashMap<String, Double>();
        this.eligibleTopicsForRebalance = new ArrayList<String>();
        this.eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
    }

    TenantTopicPartitionDistributionBasedStrategy(Map<String, Double> averageTopicPartitionsPerCell, List<String> eligibleTopicsForRebalance, Map<String, Double> eligibleTopicsForRebalanceInitialScores) {
        this.averageTopicPartitionsPerCell = averageTopicPartitionsPerCell;
        this.eligibleTopicsForRebalance = eligibleTopicsForRebalance;
        this.eligibleTopicsForRebalanceInitialScores = eligibleTopicsForRebalanceInitialScores;
    }

    @Override
    public void init(List<String> topicsToRebalance, ClusterModel clusterModel) {
        this.eligibleTopicsForRebalance = topicsToRebalance;
        for (String topic : this.eligibleTopicsForRebalance) {
            this.eligibleTopicsForRebalanceInitialScores.put(topic, this.getTopicImbalanceScore(topic, clusterModel));
            int numPartitions = clusterModel.cells().stream().mapToInt(cell -> cell.numTopicLeaderReplicas(topic)).sum();
            Optional<Tenant> tenant = clusterModel.tenant(TenantHelpers.extractTenantPrefix((String)topic, (boolean)false));
            if (!tenant.isPresent()) continue;
            this.averageTopicPartitionsPerCell.put(topic, (double)numPartitions / (double)tenant.get().cellIds().size());
        }
        if (LOG.isDebugEnabled()) {
            this.logTopicPartitionDistribution(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "PRE-BALANCING");
        }
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.PARTITION_DISTRIBUTION_BASED);
    }

    @Override
    public void rebalancetopic(TopicRebalanceContext topicRebalanceContext) throws OptimizationFailureException {
        String topic = topicRebalanceContext.getTopic();
        ClusterModel clusterModel = topicRebalanceContext.getClusterModel();
        Optional<Tenant> tenant = clusterModel.tenant(TenantHelpers.extractTenantPrefix((String)topic, (boolean)false));
        if (!tenant.isPresent()) {
            return;
        }
        for (Cell cell : clusterModel.cells()) {
            int numOfPartitions = cell.numTopicLeaderReplicas(topic);
            boolean arePartitionsInWrongCell = !tenant.get().cellIds().contains(cell.id());
            int numOfPartitionsToMoveOut = arePartitionsInWrongCell ? numOfPartitions : numOfPartitions - this.partitionsPerCellForTopicUpperLimit(topic);
            int numOfPartitionsToMoveIn = arePartitionsInWrongCell ? 0 : this.partitionsPerCellForTopicLowerLimit(topic) - numOfPartitions;
            LOG.debug("For topic: {} partitions in cell: {} are: {}, partitions to move out: {}, partitions to move in: {}, are partitions in wrong cell {}", new Object[]{topic, cell.id(), numOfPartitions, Math.max(numOfPartitionsToMoveOut, 0), Math.max(numOfPartitionsToMoveIn, 0), arePartitionsInWrongCell});
            CellPartitionRelocator cellPartitionRelocator = new CellPartitionRelocator(cell, tenant.get(), topicRebalanceContext, numOfPartitionsToMoveOut, numOfPartitionsToMoveIn, this.partitionsPerCellForTopicUpperLimit(topic), this.partitionsPerCellForTopicLowerLimit(topic));
            if (numOfPartitionsToMoveOut > 0) {
                cellPartitionRelocator.movePartitionsOut(topicRebalanceContext.getOptimizationOptions());
                continue;
            }
            if (numOfPartitionsToMoveIn > 0) {
                cellPartitionRelocator.movePartitionsIn(topicRebalanceContext.getOptimizationOptions());
                continue;
            }
            LOG.debug("No partitions to move in or out of cell {} for topic {}", (Object)cell.id(), (Object)topic);
        }
    }

    @Override
    public void postRebalanceCheck(ClusterModel clusterModel) throws OptimizationFailureException {
        if (LOG.isDebugEnabled()) {
            this.logTopicPartitionDistribution(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "POST-BALANCING");
        }
        this.ensureTopicPartitionDistributionHaveImproved(clusterModel);
    }

    @Override
    public boolean isPartitionMovementAcceptable(PartitionBalancingAction action, ClusterModel clusterModel, Tenant tenant) {
        List<Integer> tenantCellIds = tenant.cellIds();
        String sourceTopic = action.topicPartition().topic();
        List<Cell> sourceCells = action.replicaMoves().keySet().stream().map(Replica::broker).map(Broker::cell).distinct().collect(Collectors.toList());
        List<Cell> destinationCells = action.replicaMoves().values().stream().map(Broker::cell).distinct().collect(Collectors.toList());
        boolean isMovingPartitionOutAllowed = this.isMovingPartitionOutAllowed(sourceTopic, sourceCells, tenantCellIds);
        boolean isMovingPartitionInAllowed = this.isMovingPartitionInAllowed(sourceTopic, destinationCells, tenantCellIds);
        LOG.debug("For Partition balancing action: {}  is moving partitions out allowed: {}, is moving partitions in allowed:  {}", new Object[]{action, isMovingPartitionOutAllowed, isMovingPartitionInAllowed});
        return isMovingPartitionOutAllowed && isMovingPartitionInAllowed;
    }

    private void logTopicPartitionDistribution(Consumer<String> logConsumer, ClusterModel clusterModel, String logPrefix) {
        this.eligibleTopicsForRebalance.forEach(topic -> {
            Optional<Tenant> tenant = clusterModel.tenant(TenantHelpers.extractTenantPrefix((String)topic, (boolean)false));
            if (tenant.isPresent()) {
                LinkedHashMap cellPartitionsCount = new LinkedHashMap();
                clusterModel.cells().forEach(cell -> {
                    int partitionsInCell = cell.numTopicLeaderReplicas((String)topic);
                    if (partitionsInCell != 0 || ((Tenant)tenant.get()).cellIds().contains(cell.id())) {
                        cellPartitionsCount.put(cell.id(), partitionsInCell);
                    }
                });
                int maxPartitionCount = cellPartitionsCount.values().stream().max(Integer::compareTo).orElse(0);
                Integer minPartitionCount = cellPartitionsCount.values().stream().min(Integer::compareTo).orElse(0);
                logConsumer.accept(String.format("%s> Distributions for topic '%s': \nPartition count difference: %d; \nCell-wise-distribution: \n(%s)", logPrefix, topic, maxPartitionCount - minPartitionCount, cellPartitionsCount.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n"))));
                if (minPartitionCount < this.partitionsPerCellForTopicLowerLimit((String)topic) || maxPartitionCount > this.partitionsPerCellForTopicUpperLimit((String)topic)) {
                    logConsumer.accept(String.format("Topic %s partition distribution  is imbalanced, it has partition count [%d, %d] for partition count bounds [%d, %d]", topic, minPartitionCount, maxPartitionCount, this.partitionsPerCellForTopicLowerLimit((String)topic), this.partitionsPerCellForTopicUpperLimit((String)topic)));
                }
            }
        });
    }

    private int partitionsPerCellForTopicUpperLimit(String topic) {
        return (int)Math.ceil(this.averageTopicPartitionsPerCell.getOrDefault(topic, (Double)Double.MAX_VALUE));
    }

    private int partitionsPerCellForTopicLowerLimit(String topic) {
        return (int)Math.floor(this.averageTopicPartitionsPerCell.getOrDefault(topic, 0.0));
    }

    void ensureTopicPartitionDistributionHaveImproved(ClusterModel clusterModel) throws OptimizationFailureException {
        for (String topic : this.eligibleTopicsForRebalance) {
            double postOptimizationScore = this.getTopicImbalanceScore(topic, clusterModel);
            if (!(postOptimizationScore > this.eligibleTopicsForRebalanceInitialScores.get(topic))) continue;
            throw new OptimizationFailureException(String.format("Degraded partition distribution for topic %s. Post-optimization score: %.3f, Pre-optimization score: %.3f", topic, postOptimizationScore, this.eligibleTopicsForRebalanceInitialScores.get(topic)));
        }
    }

    boolean isMovingPartitionOutAllowed(String sourceTopic, List<Cell> sourceCells, List<Integer> tenantCellIds) {
        for (Cell cell : sourceCells) {
            int partitionsInCell;
            int expectedPartitionsPerCell;
            if (!tenantCellIds.contains(cell.id()) || (expectedPartitionsPerCell = (partitionsInCell = cell.numTopicLeaderReplicas(sourceTopic)) - 1) >= this.partitionsPerCellForTopicLowerLimit(sourceTopic)) continue;
            return false;
        }
        return true;
    }

    boolean isMovingPartitionInAllowed(String sourceTopic, List<Cell> destinationCells, List<Integer> tenantCellIds) {
        if (destinationCells.size() != 1) {
            LOG.debug("For topic: {} partitions are getting moved to more than one destination cells: {}", (Object)sourceTopic, destinationCells);
            return false;
        }
        Cell destinationCell = destinationCells.get(0);
        if (!tenantCellIds.contains(destinationCell.id())) {
            LOG.debug("For topic: {} partitions are getting moved to non tenant cell: {}", (Object)sourceTopic, destinationCells);
            return false;
        }
        int partitionsInCell = destinationCell.numTopicLeaderReplicas(sourceTopic);
        int expectedPartitionsInCell = partitionsInCell + 1;
        return expectedPartitionsInCell <= this.partitionsPerCellForTopicUpperLimit(sourceTopic);
    }
}

