/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.EntityEventHistory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;

public abstract class AbstractEntityEventHistory<E>
implements EntityEventHistory<E> {
    private final Time time;
    final E entity;
    private final long deadlineMs;
    private final long epoch;

    AbstractEntityEventHistory(Time time, E entity, long expirationMs, long epoch) {
        this.time = time;
        this.entity = Objects.requireNonNull(entity, "Cannot create AbstractEventHistory with null Object");
        if (expirationMs <= 0L) {
            throw new IllegalArgumentException("Cannot create EventHistory with expirationMs <= 0");
        }
        this.deadlineMs = time.hiResClockMs() + expirationMs;
        this.epoch = epoch;
    }

    @Override
    public E entity() {
        return this.entity;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    public long deadlineMs() {
        return this.deadlineMs;
    }

    @Override
    public long untilDeadline(TimeUnit unit) {
        return unit.convert(this.deadlineMs - this.time.hiResClockMs(), TimeUnit.MILLISECONDS);
    }
}

