/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.AbstractEntityEventHistory;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class EventHistoryPool<H extends AbstractEntityEventHistory> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();
    @GuardedBy(value="lock")
    private final HashMap<Object, H> index = new HashMap();
    @GuardedBy(value="lock")
    private final TreeSet<H> pool = new TreeSet();
    @GuardedBy(value="lock")
    private long epoch = 0L;
    @GuardedBy(value="lock")
    private Thread active;

    public boolean add(H history) {
        this.lock.lock();
        try {
            if (((AbstractEntityEventHistory)history).epoch() < this.epoch) {
                boolean bl = false;
                return bl;
            }
            this.pool.add(history);
            if (this.pool.first() == history) {
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(H history) {
        this.lock.lock();
        try {
            if (((AbstractEntityEventHistory)history).epoch() < this.epoch) {
                boolean bl = false;
                return bl;
            }
            AbstractEntityEventHistory previous = (AbstractEntityEventHistory)this.index.get(((AbstractEntityEventHistory)history).entity());
            if (previous == null || previous.deadlineMs() < ((AbstractEntityEventHistory)history).deadlineMs()) {
                if (previous != null) {
                    this.pool.remove(previous);
                }
                this.pool.add(history);
                this.index.put(((AbstractEntityEventHistory)history).entity(), history);
                if (this.pool.first() == history) {
                    this.available.signal();
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public H takeExpired() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.active != null) {
                throw new IllegalStateException("There could be only one thread taking from EntityHistoryPool.");
            }
            this.active = Thread.currentThread();
            while (true) {
                if (this.pool.isEmpty()) {
                    this.available.await();
                    continue;
                }
                AbstractEntityEventHistory first = (AbstractEntityEventHistory)this.pool.first();
                long firstEpoch = first.epoch();
                long durationNanosLeft = first.untilDeadline(TimeUnit.NANOSECONDS);
                if (firstEpoch < this.epoch || durationNanosLeft <= 0L) {
                    this.index.remove(first.entity());
                    AbstractEntityEventHistory abstractEntityEventHistory = (AbstractEntityEventHistory)this.pool.pollFirst();
                    return (H)abstractEntityEventHistory;
                }
                this.available.awaitNanos(durationNanosLeft);
            }
        }
        finally {
            this.active = null;
            this.lock.unlock();
        }
    }

    public long epoch() {
        this.lock.lock();
        try {
            long l = this.epoch;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void newEpoch(long newEpoch) {
        this.lock.lock();
        try {
            if (this.epoch < newEpoch) {
                this.epoch = newEpoch;
                this.available.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.pool.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

