/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import io.confluent.cruisecontrol.analyzer.history.EntityEventHistoryUtils;
import io.confluent.cruisecontrol.analyzer.history.EntityMovement;
import javax.annotation.Nonnull;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;

public final class TopicPartitionMovement
extends EntityMovement<TopicPartition>
implements Comparable<TopicPartitionMovement> {
    private final int sourceBroker;
    private final int destinationBroker;
    private final long timestampMs;

    public TopicPartitionMovement(TopicPartition tp, int sourceBroker, int destinationBroker, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        this(Time.SYSTEM, tp, sourceBroker, destinationBroker, proposingGoal, movementReason, expirationMs, epoch);
    }

    TopicPartitionMovement(Time time, TopicPartition tp, int sourceBroker, int destinationBroker, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        super(time, tp, proposingGoal, movementReason, expirationMs, epoch);
        this.sourceBroker = sourceBroker;
        this.destinationBroker = destinationBroker;
        this.timestampMs = time.milliseconds();
    }

    public int sourceBroker() {
        return this.sourceBroker;
    }

    public int destinationBroker() {
        return this.destinationBroker;
    }

    public long timestampMs() {
        return this.timestampMs;
    }

    @Override
    public String toString() {
        return "TopicPartitionMovement{sourceBroker=" + this.sourceBroker + ", destinationBroker=" + this.destinationBroker + ", proposingGoal='" + this.proposingGoal().getSimpleName() + "', movementReason='" + this.movementReason() + "', timestampMs=" + this.timestampMs + ", tp=" + String.valueOf(this.entity()) + ", deadlineMs=" + this.deadlineMs() + ", epoch=" + this.epoch() + "}";
    }

    @Override
    public int compareTo(@Nonnull TopicPartitionMovement o) {
        return EntityEventHistoryUtils.compareTopicPartitionEventHistories(this, o, (TopicPartition)this.entity(), (TopicPartition)o.entity());
    }

    @Override
    public String entityId() {
        return ((TopicPartition)this.entity()).toString();
    }
}

