/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.cruisecontrol.metricsreporter.TelemetryConverter;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConverter
implements TelemetryConverter {
    static final String BROKER_KEY = "kafka.broker.id";
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryConverter.class);

    @Override
    public <T> void convert(byte[] bytes, TelemetryConverter.MetricConsumer<T> consumer) {
        MetricsData metricsData;
        try {
            metricsData = MetricsData.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Received exception when parsing metric data", (Throwable)e);
            return;
        }
        for (ResourceMetrics resourceMetrics : metricsData.getResourceMetricsList()) {
            Optional resource = consumer.brokerId(OpenTelemetryConverter.asLabelMap(resourceMetrics.getResource().getAttributesList()).getOrDefault(BROKER_KEY, ""));
            if (!resource.isPresent()) continue;
            resourceMetrics.getScopeMetricsList().stream().flatMap(scopeMetrics -> scopeMetrics.getMetricsList().stream()).forEach(metric -> {
                switch (metric.getDataCase()) {
                    case GAUGE: {
                        OpenTelemetryConverter.createPointMetrics(consumer, resource.get(), metric.getName(), metric.getGauge().getDataPointsList());
                        break;
                    }
                    case SUM: {
                        OpenTelemetryConverter.createPointMetrics(consumer, resource.get(), metric.getName(), metric.getSum().getDataPointsList());
                        break;
                    }
                    case SUMMARY: {
                        OpenTelemetryConverter.createSummaryMetrics(consumer, resource.get(), metric.getName(), metric.getSummary().getDataPointsList());
                        break;
                    }
                }
            });
        }
    }

    protected static <T> void createPointMetrics(TelemetryConverter.MetricConsumer<T> consumer, T resource, String metricName, Iterable<NumberDataPoint> points) {
        for (final NumberDataPoint point : points) {
            final Map<String, String> labels = OpenTelemetryConverter.asLabelMap(point.getAttributesList());
            final long timestamp = TimeUnit.NANOSECONDS.toMillis(point.getTimeUnixNano());
            TelemetryConverter.DataPoint dataPoint = new TelemetryConverter.DataPoint(){

                @Override
                public Map<String, String> labels() {
                    return labels;
                }

                @Override
                public long timestamp() {
                    return timestamp;
                }

                @Override
                public long asInt() {
                    return point.getAsInt();
                }

                @Override
                public double asDouble() {
                    return point.getAsDouble();
                }
            };
            consumer.consume(metricName, resource, dataPoint);
        }
    }

    private static <T> void createSummaryMetrics(TelemetryConverter.MetricConsumer<T> consumer, T resource, String metricName, Iterable<SummaryDataPoint> points) {
        for (final SummaryDataPoint point : points) {
            final Map<String, String> labels = OpenTelemetryConverter.asLabelMap(point.getAttributesList());
            final long timestamp = TimeUnit.NANOSECONDS.toMillis(point.getTimeUnixNano());
            TelemetryConverter.Summary summary = new TelemetryConverter.Summary(){

                @Override
                public Map<String, String> labels() {
                    return labels;
                }

                @Override
                public long timestamp() {
                    return timestamp;
                }

                @Override
                public Stream<TelemetryConverter.QuantileValue> quantiles() {
                    return point.getQuantileValuesList().stream().map(qv -> new TelemetryConverter.QuantileValue(){
                        final /* synthetic */ SummaryDataPoint.ValueAtQuantile val$qv;
                        final /* synthetic */ 2 this$0;
                        {
                            this.val$qv = valueAtQuantile;
                            this.this$0 = this$0;
                        }

                        @Override
                        public double quantile() {
                            return this.val$qv.getQuantile();
                        }

                        @Override
                        public double value() {
                            return this.val$qv.getValue();
                        }
                    });
                }

                @Override
                public double sum() {
                    return point.getSum();
                }

                @Override
                public long count() {
                    return point.getCount();
                }
            };
            consumer.consume(metricName, resource, summary);
        }
    }

    private static Map<String, String> asLabelMap(List<KeyValue> attributesList) {
        HashMap<String, String> labels = new HashMap<String, String>(attributesList.size());
        for (KeyValue keyValue : attributesList) {
            labels.put(keyValue.getKey(), keyValue.getValue().getStringValue());
        }
        return labels;
    }
}

