/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import io.confluent.databalancer.KafkaDataBalanceManager;
import io.confluent.databalancer.operation.BalancerStatusTracker;
import java.util.Objects;
import java.util.Optional;
import kafka.common.AliveBrokersMetadata;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Endpoint;

public class EngineInitializationContext {
    private final KafkaConfig kafkaConfig;
    private final Optional<Endpoint> bootstrapServerEndpointOpt;
    private final Optional<AliveBrokersMetadata> aliveBrokersMetadataOpt;
    private final EngineStartupType howStarted;
    private final KafkaDataBalanceManager.BrokerRemovalMetricRegistry brokerRemovalMetricRegistry;
    private final BalancerStatusTracker balancerStatusTracker;

    public EngineInitializationContext(KafkaConfig kafkaConfig, EngineStartupType howStarted, Optional<AliveBrokersMetadata> aliveBrokersMetadataOpt, KafkaDataBalanceManager.BrokerRemovalMetricRegistry brokerRemovalMetricRegistry, BalancerStatusTracker balancerStatusTracker) {
        this(kafkaConfig, Optional.empty(), howStarted, aliveBrokersMetadataOpt, brokerRemovalMetricRegistry, balancerStatusTracker);
    }

    public EngineInitializationContext(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpointOpt, EngineStartupType howStarted, Optional<AliveBrokersMetadata> aliveBrokersMetadataOpt, KafkaDataBalanceManager.BrokerRemovalMetricRegistry brokerRemovalMetricRegistry, BalancerStatusTracker balancerStatusTracker) {
        this.kafkaConfig = kafkaConfig;
        this.bootstrapServerEndpointOpt = Objects.requireNonNull(bootstrapServerEndpointOpt, "Bootstrap server endpoint optional cannot be null");
        this.aliveBrokersMetadataOpt = aliveBrokersMetadataOpt;
        this.howStarted = howStarted;
        this.brokerRemovalMetricRegistry = brokerRemovalMetricRegistry;
        this.balancerStatusTracker = balancerStatusTracker;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Optional<Endpoint> bootstrapServerEndpoint() {
        return this.bootstrapServerEndpointOpt;
    }

    public Optional<AliveBrokersMetadata> aliveBrokersMetadata() {
        return this.aliveBrokersMetadataOpt;
    }

    public EngineStartupType engineStartupType() {
        return this.howStarted;
    }

    public KafkaDataBalanceManager.BrokerRemovalMetricRegistry brokerRemovalMetricRegistry() {
        return this.brokerRemovalMetricRegistry;
    }

    public BalancerStatusTracker balancerStatusTracker() {
        return this.balancerStatusTracker;
    }

    public static enum EngineStartupType {
        ON_FAILOVER(KafkaCruiseControl.CcStartupMode.ON_FAILOVER),
        ON_ENABLE(KafkaCruiseControl.CcStartupMode.ON_ENABLE);

        private KafkaCruiseControl.CcStartupMode startupMode;

        private EngineStartupType(KafkaCruiseControl.CcStartupMode startupMode) {
            this.startupMode = startupMode;
        }

        public KafkaCruiseControl.CcStartupMode ccStartupMode() {
            return this.startupMode;
        }
    }
}

