/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcAbstractStartupEvent;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.resource.SbcResourceUtils;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.Optional;
import kafka.common.AliveBrokersMetadata;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;

public class SbcKraftStartupEvent
extends SbcAbstractStartupEvent {
    public SbcKraftStartupEvent(SbcContext context) {
        super(context);
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        Optional<ClusterImage> unfencedImage = SbcResourceUtils.unfencedClusterImage(this.eventContext.resourceManager());
        Optional<BrokerReplicaExclusionsImage> exclusionsImage = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.EXCLUSIONS_IMAGE);
        Optional<ConfigurationsImage> configsImage = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.CONFIGS_IMAGE);
        if (!unfencedImage.isPresent()) {
            LOG.info("Cluster metadata containing at least one unfenced broker not yet available, SBC startup delayed.");
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.CLUSTER_IMAGE);
        }
        if (!exclusionsImage.isPresent()) {
            LOG.info("Exclusions metadata not yet available, SBC startup delayed.");
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.EXCLUSIONS_IMAGE);
        }
        if (!configsImage.isPresent()) {
            LOG.info("Configs metadata not yet available, SBC startup delayed.");
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.CONFIGS_IMAGE);
        }
        AliveBrokersMetadata metadata = DatabalancerUtils.buildAliveBrokerMetadata(unfencedImage.get(), exclusionsImage.get());
        this.startSbc(metadata, configsImage);
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }
}

