/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.SbcInternalEvent;
import io.confluent.databalancer.event.SbcKraftStartupEvent;
import io.confluent.databalancer.event.SbcResignationEvent;
import java.util.OptionalInt;
import javax.annotation.Nonnull;

public class SbcLeaderUpdateEvent
extends SbcInternalEvent {
    private OptionalInt leaderId;

    public SbcLeaderUpdateEvent(SbcContext context, OptionalInt leaderId) {
        super(context);
        this.leaderId = leaderId;
    }

    @Override
    @Nonnull
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        int brokerId = DatabalancerUtils.getBrokerId(this.eventContext.kafkaConfig());
        if (!this.leaderId.isPresent() || this.leaderId.getAsInt() != brokerId) {
            LOG.info("This balancer node is no longer the metadata quorum leader");
            SbcResignationEvent resignationEvent = new SbcResignationEvent(this.eventContext);
            this.eventContext.eventQueue().enqueue(resignationEvent);
        } else if (this.leaderId.getAsInt() == brokerId) {
            LOG.info("This balancer node is now the metadata quorum leader. Activating kafkadatabalance manager without alive broker snapshot.");
            SbcKraftStartupEvent startupEvent = new SbcKraftStartupEvent(this.eventContext);
            this.eventContext.eventQueue().enqueue(startupEvent);
        }
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }
}

