/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.databalancer.metrics.DataBalancerMetricsUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CellOverloadMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(CellOverloadMetrics.class);
    private static final String CELL_ID_TAG = "cellId";
    private static final String TENANT_CELL_METRIC_SUFFIX = "-per-cell";
    private static final String TENANT_ID_TAG = "tenantId";
    private final MetricsRegistry metricsRegistry;
    @GuardedBy(value="this")
    private final Set<MetricName> clusterWideMetrics;
    @GuardedBy(value="this")
    private final Map<Integer, Set<MetricName>> cellIdToMetrics;
    @GuardedBy(value="this")
    private final Map<CellResource, Map<String, Set<MetricName>>> utilizationMetricsByResourceAndTenantId;
    private final Map<String, MetricName> stripeCountMetricByTenantId;

    public CellOverloadMetrics(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.clusterWideMetrics = new HashSet<MetricName>();
        this.cellIdToMetrics = new HashMap<Integer, Set<MetricName>>();
        this.utilizationMetricsByResourceAndTenantId = new HashMap<CellResource, Map<String, Set<MetricName>>>();
        this.stripeCountMetricByTenantId = new HashMap<String, MetricName>();
    }

    public synchronized <T> Optional<Gauge<T>> newGauge(String name, Supplier<T> valueSupplier) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(CellOverloadMetrics.class, name);
        if (this.clusterWideMetrics.contains(metricName)) {
            LOG.warn("Metric {} is already registered in CellOverloadMetrics", (Object)name);
            return Optional.empty();
        }
        this.clusterWideMetrics.add(metricName);
        return Optional.of(DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, valueSupplier));
    }

    public synchronized <T> Optional<Gauge<T>> newCellGauge(int cellId, String name, Supplier<T> valueSupplier) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(CELL_ID_TAG, String.valueOf(cellId));
        MetricName metricName = DataBalancerMetricsUtils.metricName(CellOverloadMetrics.class, name, tags);
        Set cellMetrics = this.cellIdToMetrics.computeIfAbsent(cellId, k -> new HashSet());
        if (cellMetrics.contains(metricName)) {
            LOG.warn("Metric {} is already registered for cell {} in CellOverloadMetrics", (Object)name, (Object)cellId);
            return Optional.empty();
        }
        cellMetrics.add(metricName);
        return Optional.of(DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, valueSupplier));
    }

    public synchronized <T> Optional<Gauge<T>> newTenantGauge(CellResource resource, String tenantId, String name, Supplier<T> valueSupplier) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TENANT_ID_TAG, tenantId);
        MetricName metricName = DataBalancerMetricsUtils.metricName(CellOverloadMetrics.class, name, tags);
        Map tenantIdToMetrics = this.utilizationMetricsByResourceAndTenantId.computeIfAbsent(resource, k -> new HashMap());
        Set tenantMetrics = tenantIdToMetrics.computeIfAbsent(tenantId, k -> new HashSet());
        if (tenantMetrics.contains(metricName)) {
            LOG.warn("Metric {} is already registered for tenant {} and resource {} in CellOverloadMetrics", new Object[]{name, tenantId, resource});
            return Optional.empty();
        }
        tenantMetrics.add(metricName);
        return Optional.of(DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, valueSupplier));
    }

    public synchronized <T> void registerStripeCountMetric(String tenantId, String name, Supplier<T> valueSupplier) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TENANT_ID_TAG, tenantId);
        MetricName metricName = DataBalancerMetricsUtils.metricName(CellOverloadMetrics.class, name, tags);
        if (!this.stripeCountMetricByTenantId.containsKey(tenantId)) {
            this.stripeCountMetricByTenantId.put(tenantId, metricName);
            DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, valueSupplier);
        }
    }

    public synchronized <T> Optional<Gauge<T>> newTenantPerCellGauge(CellResource resource, String tenantId, String name, Integer cellId, Supplier<T> perCellValueSupplier) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TENANT_ID_TAG, tenantId);
        tags.put(CELL_ID_TAG, cellId.toString());
        MetricName metricName = DataBalancerMetricsUtils.metricName(CellOverloadMetrics.class, name + TENANT_CELL_METRIC_SUFFIX, tags);
        Map tenantIdToMetrics = this.utilizationMetricsByResourceAndTenantId.computeIfAbsent(resource, k -> new HashMap());
        Set tenantMetrics = tenantIdToMetrics.computeIfAbsent(tenantId, k -> new HashSet());
        if (tenantMetrics.contains(metricName)) {
            LOG.warn("Metric {} is already registered for tenant {} for cell {} and resource {} in CellOverloadMetrics", new Object[]{name, tenantId, cellId, resource});
            return Optional.empty();
        }
        tenantMetrics.add(metricName);
        return Optional.of(DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, perCellValueSupplier));
    }

    public synchronized void removeMetrics(int cellId) {
        this.cellIdToMetrics.getOrDefault(cellId, Collections.emptySet()).forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
        this.cellIdToMetrics.remove(cellId);
    }

    public synchronized void removeMetrics(CellResource resource, String tenantId) {
        Map<String, Set<MetricName>> tenantIdToMetrics = this.utilizationMetricsByResourceAndTenantId.get((Object)resource);
        if (tenantIdToMetrics != null) {
            tenantIdToMetrics.getOrDefault(tenantId, Collections.emptySet()).forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
            tenantIdToMetrics.remove(tenantId);
        }
    }

    public synchronized void removeStripeCountMetrics(String tenantId) {
        if (this.stripeCountMetricByTenantId.containsKey(tenantId)) {
            this.metricsRegistry.removeMetric(this.stripeCountMetricByTenantId.get(tenantId));
            this.stripeCountMetricByTenantId.remove(tenantId);
        }
    }

    public synchronized void clearMetrics() {
        this.clusterWideMetrics.forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
        this.clusterWideMetrics.clear();
        this.cellIdToMetrics.forEach((cellId, metrics) -> {
            metrics.forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
            metrics.clear();
        });
        this.cellIdToMetrics.clear();
        for (Map<String, Set<MetricName>> tenantIdToMetrics : this.utilizationMetricsByResourceAndTenantId.values()) {
            tenantIdToMetrics.forEach((tenantId, metrics) -> {
                metrics.forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
                metrics.clear();
            });
            tenantIdToMetrics.clear();
        }
        this.stripeCountMetricByTenantId.forEach((tenantId, metricName) -> this.metricsRegistry.removeMetric(metricName));
        this.stripeCountMetricByTenantId.clear();
        this.utilizationMetricsByResourceAndTenantId.clear();
    }
}

