/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.databalancer.metrics.DataBalancerMetricsUtils;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public enum CommonMetrics implements Closeable
{
    INSTANCE;

    public static final String MODULE_TAG_KEY = "module";
    public static final String ERROR_TYPE_TAG_KEY = "error-type";
    public static final String FATAL_ERROR_COUNT_METRIC_NAME = "fatal-error-count";
    private static final String ERROR_TYPE_DEFAULT = "unknown";
    private final MetricsRegistry registry = KafkaYammerMetrics.defaultRegistry();
    private final Map<MetricName, Counter> fatalErrorCounters = new ConcurrentHashMap<MetricName, Counter>();

    private void doRecordFatalError(String moduleName, String errorType) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(CommonMetrics.class, FATAL_ERROR_COUNT_METRIC_NAME, Map.of(MODULE_TAG_KEY, moduleName, ERROR_TYPE_TAG_KEY, errorType));
        this.fatalErrorCounters.computeIfAbsent(metricName, arg_0 -> ((MetricsRegistry)this.registry).newCounter(arg_0)).inc();
    }

    @Override
    public void close() {
        this.fatalErrorCounters.keySet().forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        this.fatalErrorCounters.clear();
    }

    public static void recordFatalError(Class<?> clazz, String errorType) {
        INSTANCE.doRecordFatalError(clazz.getSimpleName(), errorType);
    }

    public static void recordFatalError(Class<?> clazz) {
        INSTANCE.doRecordFatalError(clazz.getSimpleName(), ERROR_TYPE_DEFAULT);
    }
}

