/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics.internals;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.internals.TenantResourceStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class TenantUtilizationMetricHandler {
    private static final String TENANT_UTILIZATION_METRIC_PREFIX = "tenant-utilization-";
    public static final String STRIPE_COUNT_METRICS_NAME = "stripe-count";
    private static final int NUM_TENANT_PER_RESOURCE = 10;
    private final long maxReplicasPerBroker;
    private final CellOverloadMetrics cellOverloadMetrics;
    private final Map<CellResource, Map<String, TenantResourceStats>> resourceStatsByResourceAndTenantId;
    private final Map<String, Integer> stripeCountMapByTenantId;

    public TenantUtilizationMetricHandler(KafkaCruiseControlConfig config, CellOverloadMetrics cellOverloadMetrics) {
        this.maxReplicasPerBroker = config.getLong("max.replicas");
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.resourceStatsByResourceAndTenantId = new ConcurrentHashMap<CellResource, Map<String, TenantResourceStats>>();
        this.stripeCountMapByTenantId = new HashMap<String, Integer>();
    }

    public void update(ClusterModel clusterModel) {
        CellResource.cachedValues().forEach(resource -> {
            Map<String, TenantResourceStats> resourceStatsOfTenantsWithMostUsedResource = this.resourceStatsOfTenantsWithMostUsedResource(clusterModel, (CellResource)((Object)resource));
            this.refreshResourceMetrics((CellResource)((Object)resource), resourceStatsOfTenantsWithMostUsedResource);
        });
    }

    public synchronized void refreshTenantStripeCountMetrics(ClusterModel clusterModel) {
        HashMap<String, Integer> tenantStripeCountMap = new HashMap<String, Integer>();
        for (Cell cell : clusterModel.cells()) {
            for (Tenant tenant : cell.tenants()) {
                tenantStripeCountMap.put(tenant.tenantId(), tenantStripeCountMap.getOrDefault(tenant.tenantId(), 0) + 1);
            }
        }
        for (Map.Entry entry : tenantStripeCountMap.entrySet()) {
            String tenantName = (String)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if (count > 1) {
                if (!this.stripeCountMapByTenantId.containsKey(tenantName)) {
                    this.cellOverloadMetrics.registerStripeCountMetric(tenantName, STRIPE_COUNT_METRICS_NAME, () -> this.stripeCountMapByTenantId.get(tenantName));
                }
                this.stripeCountMapByTenantId.put(tenantName, count);
                continue;
            }
            if (!this.stripeCountMapByTenantId.containsKey(tenantName)) continue;
            this.cellOverloadMetrics.removeStripeCountMetrics(tenantName);
            this.stripeCountMapByTenantId.remove(tenantName);
        }
        for (String string : this.stripeCountMapByTenantId.keySet()) {
            if (tenantStripeCountMap.containsKey(string)) continue;
            this.cellOverloadMetrics.removeStripeCountMetrics(string);
        }
    }

    private void refreshResourceMetrics(CellResource resource, Map<String, TenantResourceStats> newResourceStatsByTenantId) {
        String tenantId;
        Map resourceStatsByTenantId = this.resourceStatsByResourceAndTenantId.computeIfAbsent(resource, k -> new ConcurrentHashMap());
        ArrayList<String> tenantIdsToRemove = new ArrayList<String>();
        for (Map.Entry entry : resourceStatsByTenantId.entrySet()) {
            tenantId = (String)entry.getKey();
            if (newResourceStatsByTenantId.containsKey(tenantId)) continue;
            this.cellOverloadMetrics.removeMetrics(resource, tenantId);
            tenantIdsToRemove.add(tenantId);
        }
        for (String string : tenantIdsToRemove) {
            resourceStatsByTenantId.remove(string);
        }
        for (Map.Entry<Object, Object> entry : newResourceStatsByTenantId.entrySet()) {
            tenantId = (String)entry.getKey();
            TenantResourceStats newTenantResourceStats = (TenantResourceStats)entry.getValue();
            if (!resourceStatsByTenantId.containsKey(tenantId)) {
                this.cellOverloadMetrics.newTenantGauge(resource, tenantId, this.tenantUtilizationMetricName(resource), () -> this.resourceUtilizationValue(resource, tenantId));
                for (Integer cellId : newTenantResourceStats.cellIds()) {
                    this.cellOverloadMetrics.newTenantPerCellGauge(resource, tenantId, this.tenantUtilizationMetricName(resource), cellId, () -> this.resourceUtilizationValuePerCell(resource, tenantId, cellId));
                }
            }
            resourceStatsByTenantId.put(tenantId, newTenantResourceStats);
        }
    }

    private double resourceUtilizationValue(CellResource resource, String tenantId) {
        return Optional.ofNullable(this.resourceStatsByResourceAndTenantId.get((Object)resource)).map(resourceStatsByTenantId -> (TenantResourceStats)resourceStatsByTenantId.get(tenantId)).map(TenantResourceStats::utilizationValue).orElse(0.0);
    }

    private double resourceUtilizationValuePerCell(CellResource resource, String tenantId, Integer cellId) {
        return Optional.ofNullable(this.resourceStatsByResourceAndTenantId.get((Object)resource)).map(resourceStatsByTenantId -> (TenantResourceStats)resourceStatsByTenantId.get(tenantId)).map(TenantResourceStats::utilizationValuePerCell).map(utilizationMap -> utilizationMap.getOrDefault(cellId, 0.0)).orElse(0.0);
    }

    private Map<String, TenantResourceStats> resourceStatsOfTenantsWithMostUsedResource(ClusterModel clusterModel, CellResource resource) {
        List<Tenant> sortedTenants = clusterModel.tenantsSortedByCellResource(resource);
        return sortedTenants.stream().limit(10L).collect(Collectors.toMap(Tenant::tenantId, tenant -> this.resourceStatsAcrossCells(clusterModel, (Tenant)tenant, resource)));
    }

    private TenantResourceStats resourceStatsAcrossCells(ClusterModel clusterModel, Tenant tenant, CellResource resource) {
        double utilizationValue;
        double cellCapacityValue;
        List<Integer> cellIds = tenant.cellIds();
        return new TenantResourceStats(cellIds, tenant.tenantId(), resource, cellCapacityValue, utilizationValue, switch (resource) {
            case CellResource.REPLICA_COUNT -> {
                cellCapacityValue = cellIds.stream().map(clusterModel::cell).mapToDouble(cell -> this.maxReplicasPerBroker * (long)cell.brokers().size()).sum();
                utilizationValue = tenant.replicaCount();
                yield tenant.replicaCountPerCell().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Integer)entry.getValue()).doubleValue()));
            }
            default -> {
                cellCapacityValue = cellIds.stream().map(clusterModel::cell).mapToDouble(cell -> cell.eligibleDestinationCapacityValue(resource.resource())).sum();
                utilizationValue = tenant.eligibleSourceUtilizationValue(resource.resource());
                yield tenant.eligibleSourceUtilizationValuePerCell(resource.resource());
            }
        });
    }

    private String tenantUtilizationMetricName(CellResource resource) {
        return TENANT_UTILIZATION_METRIC_PREFIX + resource.name().toLowerCase(Locale.ROOT);
    }
}

