/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import io.confluent.databalancer.metrics.CommonMetrics;
import io.confluent.databalancer.operation.BrokerRemovalCancellationMode;
import io.confluent.databalancer.operation.BrokerRemovalCancellationProposal;
import io.confluent.databalancer.operation.BrokerRemovalExclusionCancellationData;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.operation.MultiBrokerBalancerOperationProgressListener;
import io.confluent.databalancer.operation.MultiBrokerBalancerOperationTerminationListener;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerRemovalStateTracker
implements BrokerRemovalCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerRemovalStateTracker.class);
    private final ImmutableSet<Integer> brokerIds;
    private Set<BrokerRemovalStateMachine.BrokerRemovalState> passedStates;
    private BrokerRemovalStateMachine stateMachine;
    private MultiBrokerBalancerOperationProgressListener<BrokerRemovalStateMachine.BrokerRemovalState> progressListener;
    private MultiBrokerBalancerOperationTerminationListener<BrokerRemovalStateMachine.BrokerRemovalState> terminationListener;
    private AtomicReference<String> stateReference;
    private volatile boolean cancelled = false;
    private volatile boolean initialized = false;

    public BrokerRemovalStateTracker(Set<Integer> brokerIds, MultiBrokerBalancerOperationProgressListener<BrokerRemovalStateMachine.BrokerRemovalState> progressListener, MultiBrokerBalancerOperationTerminationListener<BrokerRemovalStateMachine.BrokerRemovalState> terminationListener, AtomicReference<String> stateReference, Time time) {
        this(brokerIds, new BrokerRemovalStateMachine(brokerIds, BrokerRemovalStateMachine.START_STATE, time), progressListener, terminationListener, stateReference);
    }

    public BrokerRemovalStateTracker(Set<Integer> brokerIds, BrokerRemovalStateMachine.BrokerRemovalState initState, MultiBrokerBalancerOperationProgressListener<BrokerRemovalStateMachine.BrokerRemovalState> progressListener, MultiBrokerBalancerOperationTerminationListener<BrokerRemovalStateMachine.BrokerRemovalState> terminationListener, AtomicReference<String> stateReference, Time time) {
        this(brokerIds, new BrokerRemovalStateMachine(brokerIds, initState, time), progressListener, terminationListener, stateReference);
    }

    BrokerRemovalStateTracker(Set<Integer> brokerIds, BrokerRemovalStateMachine stateMachine, MultiBrokerBalancerOperationProgressListener<BrokerRemovalStateMachine.BrokerRemovalState> progressListener, MultiBrokerBalancerOperationTerminationListener<BrokerRemovalStateMachine.BrokerRemovalState> terminationListener, AtomicReference<String> stateReference) {
        this.brokerIds = new ImmutableSet<Integer>(brokerIds);
        this.stateMachine = stateMachine;
        this.progressListener = progressListener;
        this.terminationListener = terminationListener;
        this.stateReference = stateReference;
        this.passedStates = new HashSet<BrokerRemovalStateMachine.BrokerRemovalState>();
        this.passedStates.add((BrokerRemovalStateMachine.BrokerRemovalState)stateMachine.currentState());
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("The state tracker was already initialized");
        }
        this.stateReference.set(((BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.currentState()).name());
        if (this.stateMachine.currentState() == BrokerRemovalStateMachine.START_STATE) {
            this.tryNotifyProgressChanged((BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.currentState(), null);
        }
        this.initialized = true;
    }

    public ImmutableSet<Integer> brokerIds() {
        return this.brokerIds;
    }

    @Override
    public BrokerRemovalStateMachine.BrokerRemovalState currentState() {
        return (BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.currentState();
    }

    @Override
    public synchronized void registerEvent(BrokerRemovalStateMachine.BrokerRemovalEvent pe) {
        this.registerEvent(pe, (Exception)null);
    }

    @Override
    public synchronized void registerEvent(BrokerRemovalStateMachine.BrokerRemovalEvent pe, Exception eventException) {
        if (this.cancelled) {
            String errMsg = String.format("Will not register broker removal event %s (exception %s) for brokers %s because the removal operation was already canceled.", pe, eventException, this.brokerIds);
            LOG.warn(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.processEvent(pe, eventException);
    }

    public synchronized boolean maybeCancel(BrokerRemovalCancellationProposal brokerRemovalCancellationProposal) {
        if (!brokerRemovalCancellationProposal.cancellationEvent().canCancelRemoval()) {
            throw new IllegalArgumentException(String.format("Cannot cancel broker removal of brokers %s due to %s", this.brokerIds, brokerRemovalCancellationProposal.cancellationEvent()));
        }
        if (this.canBeCanceled(brokerRemovalCancellationProposal)) {
            LOG.info("Cancelling broker removal request for brokers {} due to event {} with mode {}", new Object[]{this.brokerIds, brokerRemovalCancellationProposal.cancellationEvent(), brokerRemovalCancellationProposal.cancellationMode()});
            if (brokerRemovalCancellationProposal.cancellationMode() == BrokerRemovalCancellationMode.PERSISTENT_CANCELLATION) {
                this.processEvent(brokerRemovalCancellationProposal.cancellationEvent(), brokerRemovalCancellationProposal.eventException());
            }
            this.cancelled = true;
        }
        return this.cancelled;
    }

    boolean canBeCanceled(BrokerRemovalCancellationProposal cancellationProposal) {
        switch (cancellationProposal.cancellationEvent()) {
            case EXCLUSION_ADDED: 
            case EXCLUSION_REMOVED: {
                return this.canExclusionProposalCancel(cancellationProposal);
            }
            case DEMOTED_ADDED: {
                return this.canDemotionProposalCancel(cancellationProposal);
            }
        }
        return !this.isDone();
    }

    private boolean canExclusionProposalCancel(BrokerRemovalCancellationProposal cancellationProposal) {
        if (!cancellationProposal.exclusionData().isPresent()) {
            LOG.warn("Not cancelling broker removal of brokers due to no exclusion data, current status is {}.", (Object)this.currentState().toString());
            return false;
        }
        BrokerRemovalExclusionCancellationData exclusionCancellationData = cancellationProposal.exclusionData().get();
        Set excludedBrokersNotBeingRemoved = exclusionCancellationData.modifiedExclusions.stream().filter(b -> !this.brokerIds.contains(b)).collect(Collectors.toSet());
        switch (cancellationProposal.cancellationEvent()) {
            case EXCLUSION_ADDED: {
                if (excludedBrokersNotBeingRemoved.isEmpty()) {
                    LOG.debug("Not cancelling removal request for {} due to event {} because all excluded brokers ({}) are being removed", new Object[]{this.brokerIds, cancellationProposal.cancellationEvent(), exclusionCancellationData.modifiedExclusions});
                    return false;
                }
                if (!this.isDone()) {
                    LOG.info("Cancelling removal for brokers {} because of new exclusions: {}", this.brokerIds, exclusionCancellationData.modifiedExclusions);
                    return true;
                }
                return false;
            }
            case EXCLUSION_REMOVED: {
                if (this.currentState() == BrokerRemovalStateMachine.BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED) {
                    LOG.debug("Not cancelling broker removal of brokers {} due to exclusion removal because of the EXCLUSION_REMOVAL state.", this.brokerIds);
                    return false;
                }
                if (this.isDone()) break;
                LOG.info("Cancelling removal for brokers {} because of exclusion removal: {}", this.brokerIds, exclusionCancellationData.modifiedExclusions);
                return true;
            }
        }
        return false;
    }

    private boolean canDemotionProposalCancel(BrokerRemovalCancellationProposal cancellationProposal) {
        if (!cancellationProposal.demotedBrokers().isPresent()) {
            LOG.warn("Not cancelling broker removal of brokers due to no demotion data, current status is {}.", (Object)this.currentState().toString());
            return false;
        }
        Set<Integer> demotionData = cancellationProposal.demotedBrokers().get();
        if (cancellationProposal.cancellationEvent() == BrokerRemovalStateMachine.BrokerRemovalEvent.DEMOTED_ADDED) {
            Set demotedBrokersNotBeingRemoved = demotionData.stream().filter(b -> !this.brokerIds.contains(b)).collect(Collectors.toSet());
            if (demotedBrokersNotBeingRemoved.isEmpty()) {
                LOG.debug("Not cancelling removal request for {} due to event {} because all demoted brokers ({}) are being removed", new Object[]{this.brokerIds, cancellationProposal.cancellationEvent(), demotionData});
                return false;
            }
            if (!this.stateMachine.transitioner().canTransition(this.currentState(), cancellationProposal.cancellationEvent())) {
                LOG.debug("Not cancelling broker removal of brokers {} due to demote broker because the current status is {}.", this.brokerIds, (Object)this.currentState().toString());
                return false;
            }
            if (!this.isDone()) {
                LOG.info("Cancelling removal for brokers {} because of new demotions: {}", this.brokerIds, demotionData);
                return true;
            }
        }
        return false;
    }

    boolean hasSeenState(BrokerRemovalStateMachine.BrokerRemovalState state) {
        return this.passedStates.contains(state);
    }

    private boolean isDone() {
        return this.stateMachine.isTerminalState((BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.currentState());
    }

    private void processEvent(BrokerRemovalStateMachine.BrokerRemovalEvent pe, Exception eventException) {
        BrokerRemovalStateMachine.BrokerRemovalState newState;
        if (!this.initialized) {
            throw new IllegalStateException("Cannot process a broker removal event because the state tracker is not initialized.");
        }
        try {
            newState = (BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.advanceState(pe);
        }
        catch (Exception exception) {
            if (eventException != null) {
                LOG.error("Unexpected exception while handling removal event {} (event exception: {})!", new Object[]{pe, eventException, exception});
            } else {
                LOG.error("Unexpected exception while handling removal event {}!", (Object)pe, (Object)exception);
            }
            throw exception;
        }
        this.passedStates.add((BrokerRemovalStateMachine.BrokerRemovalState)this.stateMachine.currentState());
        this.stateReference.set(newState.name());
        this.tryNotifyProgressChanged(newState, eventException);
    }

    private void tryNotifyProgressChanged(BrokerRemovalStateMachine.BrokerRemovalState state, Exception progressException) {
        try {
            this.progressListener.onProgressChanged(this.brokerIds, state, progressException);
            LOG.debug("Notified progress listener of broker removal state change to state {}.", (Object)state);
        }
        catch (Exception e) {
            LOG.error("Error while notifying that broker removal operation progress changed for brokers {} to state {}", this.brokerIds, (Object)state);
            CommonMetrics.recordFatalError(BrokerRemovalStateTracker.class);
        }
        if (this.stateMachine.isTerminalState(state)) {
            try {
                this.terminationListener.onTerminalState(this.brokerIds, state, progressException);
                LOG.debug("Notified progress listener of broker removal reaching terminal state {}.", (Object)state);
            }
            catch (Exception e) {
                LOG.error("Error while notifying that broker removal operation progress reached a terminal state {} for brokers {}", (Object)state, this.brokerIds);
                CommonMetrics.recordFatalError(BrokerRemovalStateTracker.class);
            }
        }
    }
}

