/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.metrics.CommonMetrics;
import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import io.confluent.databalancer.operation.EvenClusterLoadStateProgressListener;
import io.confluent.databalancer.operation.PersistEvenClusterLoadStateListener;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.EvenClusterLoadStateRecord;
import javax.annotation.concurrent.ThreadSafe;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EvenClusterLoadStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(EvenClusterLoadStateManager.class);
    private static final String PROCESS_EVENT_ERROR = "process-event-error";
    private static final String NOTIFY_PROGRESS_CHANGED_ERROR = "notify-progress-changed-error";
    @GuardedBy(value="this")
    private EvenClusterLoadStateMachine previousStateMachine;
    @GuardedBy(value="this")
    private EvenClusterLoadStateMachine currentStateMachine;
    private final int brokerId;
    private final Time time;
    private final ApiStatePersistenceStore persistenceStore;
    private EvenClusterLoadStateProgressListener<EvenClusterLoadStateMachine.EvenClusterLoadState> progressListener;

    public EvenClusterLoadStateManager(int brokerId, Time time, ApiStatePersistenceStore persistenceStore, boolean selfHealingEnabled) {
        this(brokerId, time, persistenceStore, new PersistEvenClusterLoadStateListener(persistenceStore), selfHealingEnabled);
    }

    EvenClusterLoadStateManager(int brokerId, Time time, ApiStatePersistenceStore persistenceStore, EvenClusterLoadStateProgressListener<EvenClusterLoadStateMachine.EvenClusterLoadState> progressListener, boolean selfHealingEnabled) {
        this.brokerId = brokerId;
        this.time = time;
        this.persistenceStore = persistenceStore;
        this.progressListener = progressListener;
        this.createStateMachines(selfHealingEnabled);
    }

    private synchronized void createStateMachines(boolean selfHealingEnabled) {
        EvenClusterLoadStateRecord stateRecord = this.persistenceStore.getEvenClusterLoadStateRecord();
        if (stateRecord == null) {
            if (selfHealingEnabled) {
                this.currentStateMachine = new EvenClusterLoadStateMachine(this.brokerId, EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCED, this.time);
            }
            this.tryNotifyProgressChanged(this.currentStateMachine, this.previousStateMachine);
        } else {
            this.currentStateMachine = new EvenClusterLoadStateMachine(this.brokerId, stateRecord.currentState(), stateRecord.currentStateCreatedAt(), stateRecord.currentStateLastUpdatedAt(), this.time, stateRecord.currentStateException());
            this.previousStateMachine = new EvenClusterLoadStateMachine(this.brokerId, stateRecord.previousState(), stateRecord.previousStateCreatedAt(), stateRecord.previousStateLastUpdatedAt(), this.time, stateRecord.previousStateException());
        }
    }

    public synchronized void startRebalancing() {
        this.previousStateMachine = this.currentStateMachine;
        this.currentStateMachine = new EvenClusterLoadStateMachine(this.brokerId, this.time);
        this.tryNotifyProgressChanged(this.currentStateMachine, this.previousStateMachine);
    }

    public synchronized void noGoalViolationsFound() {
        if (this.isCurrentStateNull() || this.currentState().isFailedOrAborted()) {
            this.previousStateMachine = this.currentStateMachine;
            this.currentStateMachine = new EvenClusterLoadStateMachine(this.brokerId, EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCED, this.time);
            this.tryNotifyProgressChanged(this.currentStateMachine, this.previousStateMachine);
        }
    }

    public synchronized void maybeUpdateStateOnSelfHealingEnabled() {
        if (this.isCurrentStateNull()) {
            this.currentStateMachine = new EvenClusterLoadStateMachine(this.brokerId, EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCED, this.time);
            this.tryNotifyProgressChanged(this.currentStateMachine, this.previousStateMachine);
        }
    }

    public synchronized void maybeRegisterEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent event, Exception e) {
        if (!this.isCurrentStateNull()) {
            this.registerEvent(event, e);
        } else {
            LOG.info("Current state is null, not registering event {} with exception {}.", (Object)event, (Object)e);
        }
    }

    public void registerEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent event) {
        this.registerEvent(event, null);
    }

    public void registerEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent event, Exception e) {
        if (e != null) {
            if (e instanceof BalancerOperationOverriddenException) {
                LOG.info("Registering EvenClusterLoadEvent {} to override the even cluster load task (exception {}).", new Object[]{event, e.getClass().getName(), e});
            } else {
                LOG.error("Registering EvenClusterLoadEvent {} with exception {}.", new Object[]{event, e.getClass().getName(), e});
            }
        }
        this.processEvent(event, e);
    }

    private synchronized void processEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent event, Exception eventException) {
        try {
            this.currentStateMachine.evenLoadBalancingError(eventException);
            this.currentStateMachine.advanceState(event);
            this.tryNotifyProgressChanged(this.currentStateMachine, this.previousStateMachine);
        }
        catch (Exception exception) {
            if (eventException != null) {
                LOG.error("Unexpected exception while handling even cluster load status event {}. Event exception: ", (Object)event, (Object)eventException);
                LOG.error("Exception: ", (Throwable)exception);
            } else {
                LOG.error("Unexpected exception while handling even cluster load status event {}.", (Object)event, (Object)exception);
            }
            CommonMetrics.recordFatalError(EvenClusterLoadStateManager.class, PROCESS_EVENT_ERROR);
        }
    }

    private void tryNotifyProgressChanged(EvenClusterLoadStateMachine currentStateMachine, EvenClusterLoadStateMachine previousStateMachine) {
        EvenClusterLoadStateMachine.EvenClusterLoadState currentState = null;
        long currentStateCreateTime = 0L;
        long currentStateLastUpdateTime = 0L;
        Exception currentStateException = null;
        if (currentStateMachine != null) {
            currentState = (EvenClusterLoadStateMachine.EvenClusterLoadState)currentStateMachine.currentState();
            currentStateCreateTime = currentStateMachine.createTime();
            currentStateLastUpdateTime = currentStateMachine.lastUpdateTime();
            currentStateException = currentStateMachine.evenLoadBalancingError();
        }
        EvenClusterLoadStateMachine.EvenClusterLoadState previousState = null;
        long previousStateCreateTime = 0L;
        long previousStateLastUpdateTime = 0L;
        Exception previousStateException = null;
        if (previousStateMachine != null) {
            previousState = (EvenClusterLoadStateMachine.EvenClusterLoadState)previousStateMachine.currentState();
            previousStateCreateTime = previousStateMachine.createTime();
            previousStateLastUpdateTime = previousStateMachine.lastUpdateTime();
            previousStateException = previousStateMachine.evenLoadBalancingError();
        }
        try {
            this.progressListener.onProgressChanged(currentState, currentStateCreateTime, currentStateLastUpdateTime, currentStateException, previousState, previousStateCreateTime, previousStateLastUpdateTime, previousStateException);
            LOG.debug("Notified progress listener of EvenClusterLoad states change to currentState: {}, previousState: {}.", (Object)currentState, (Object)previousState);
        }
        catch (Exception e) {
            LOG.error("Error while notifying that EvenClusterLoad operation progress change on broker {} to state {}, previous state {}", new Object[]{this.brokerId, currentState, previousState, e});
            CommonMetrics.recordFatalError(EvenClusterLoadStateManager.class, NOTIFY_PROGRESS_CHANGED_ERROR);
        }
    }

    public synchronized EvenClusterLoadStateMachine.EvenClusterLoadState currentState() {
        return this.currentStateMachine != null ? (EvenClusterLoadStateMachine.EvenClusterLoadState)this.currentStateMachine.currentState() : null;
    }

    public boolean isCurrentStateNull() {
        return this.currentState() == null;
    }

    public synchronized EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatusDescription(boolean anyUnevenLoadEnabled) {
        return this.persistenceStore.getEvenClusterLoadStateRecord().toEvenClusterLoadDescriptionInternal(anyUnevenLoadEnabled);
    }
}

