/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateMachineInitializer<S extends BalancerOperationState> {
    private final S defaultStartState;
    private final InitializationMode initializationMode;
    private Map<S, S> stateInitalizations;

    private StateMachineInitializer(List<InitializationRule<S>> initializationsList, S defaultStartState, InitializationMode initializationMode) {
        this.defaultStartState = defaultStartState;
        this.initializationMode = initializationMode;
        this.stateInitalizations = new HashMap<S, S>();
        for (InitializationRule<S> rule : initializationsList) {
            if (this.stateInitalizations.containsKey(rule.givenState)) {
                throw new IllegalArgumentException(String.format("Found duplicate state initialization rule for the state %s. Both %s->%s and %s->%s were registered.", rule.givenState, rule.givenState, this.stateInitalizations.get(rule.givenState), rule.givenState, rule.initializedState));
            }
            this.stateInitalizations.put(rule.givenState, rule.initializedState);
        }
    }

    public S defaultStartState() {
        return this.defaultStartState;
    }

    public S init(S givenState) {
        BalancerOperationState stateToInitialize = (BalancerOperationState)this.stateInitalizations.get(givenState);
        if (stateToInitialize == null) {
            if (this.initializationMode == InitializationMode.ALLOW_UNDEFINED_INITIALIZATIONS) {
                stateToInitialize = givenState;
            } else {
                throw new IllegalArgumentException(String.format("No initialization state has been registered for %s and the initializer is not set to allow undefined initializations.", givenState));
            }
        }
        return (S)stateToInitialize;
    }

    public static enum InitializationMode {
        ALLOW_UNDEFINED_INITIALIZATIONS,
        STRICT;

    }

    public static class InitializationRule<S extends BalancerOperationState> {
        private final S givenState;
        private final S initializedState;

        public InitializationRule(S givenState, S initializedState) {
            this.givenState = givenState;
            this.initializedState = initializedState;
        }
    }

    static class InitializationRuleBuilder<S extends BalancerOperationState> {
        private S givenState;

        InitializationRuleBuilder() {
        }

        public InitializationRuleBuilder<S> given(S givenState) {
            this.givenState = givenState;
            return this;
        }

        public InitializationRule<S> initializeTo(S initializedState) {
            if (this.givenState == null) {
                throw new IllegalStateException("Cannot build InitializationRule when the given state is not defined.");
            }
            if (initializedState == null) {
                throw new IllegalArgumentException("Cannot build InitializationRule when the initialization state is not defined.");
            }
            return new InitializationRule<S>(this.givenState, initializedState);
        }
    }

    public static class Builder<S extends BalancerOperationState> {
        List<InitializationRule<S>> initializationRules = new ArrayList<InitializationRule<S>>();
        S defaultStartState;

        public Builder<S> setDefaultStartState(S startState) {
            this.defaultStartState = startState;
            return this;
        }

        public Builder<S> with(InitializationRule<S> initializationRule) {
            this.initializationRules.add(initializationRule);
            return this;
        }

        public StateMachineInitializer<S> build(InitializationMode mode) {
            if (this.defaultStartState == null) {
                throw new IllegalArgumentException("startState must be set!");
            }
            return new StateMachineInitializer<S>(this.initializationRules, this.defaultStartState, mode);
        }
    }
}

