/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImmutableSet<T>
implements Set<T> {
    private final Set<T> underlyingSet;

    public ImmutableSet() {
        this.underlyingSet = Collections.emptySet();
    }

    public ImmutableSet(Collection<? extends T> c) {
        this.underlyingSet = Collections.unmodifiableSet(new HashSet<T>(c));
    }

    @Override
    public int size() {
        return this.underlyingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlyingSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.underlyingSet.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.underlyingSet.forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlyingSet.toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] t1s) {
        return this.underlyingSet.toArray(t1s);
    }

    @Override
    public boolean add(T t) {
        return this.underlyingSet.add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.underlyingSet.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.underlyingSet.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.underlyingSet.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.underlyingSet.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.underlyingSet.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.underlyingSet.retainAll(c);
    }

    @Override
    public void clear() {
        this.underlyingSet.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.underlyingSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.underlyingSet.hashCode();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.underlyingSet.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.underlyingSet.stream();
    }

    public String toString() {
        return this.underlyingSet.toString();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.underlyingSet.parallelStream();
    }
}

