/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.concurrent;

import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.concurrent.VoidCallable;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.MockTime;

public final class MockEventExecutor
implements EventExecutor {
    private final MockTime time;
    private final Queue<Runnable> fifo = new ArrayDeque<Runnable>();
    private final PriorityQueue<ScheduledRunnable> delayed = new PriorityQueue();
    private Optional<CompletableFuture<Void>> shutdownFuture = Optional.empty();

    public MockEventExecutor(MockTime time) {
        this.time = time;
    }

    public CompletableFuture<Void> submit(Runnable task) {
        return this.submit((Callable)new VoidCallable(task));
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        this.ensureAccepting();
        CompletableFuture future = new CompletableFuture();
        this.fifo.add(MockEventExecutor.completioner(future, task));
        return future;
    }

    public CompletableFuture<Void> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.schedule((Callable)new VoidCallable(task), delay, unit);
    }

    public <T> CompletableFuture<T> schedule(Callable<T> task, long delay, TimeUnit unit) {
        this.ensureAccepting();
        CompletableFuture future = new CompletableFuture();
        this.delayed.add(new ScheduledRunnable(future, MockEventExecutor.completioner(future, task), delay, unit));
        return future;
    }

    public CompletableFuture<Void> shutdown() {
        if (!this.shutdownFuture.isPresent()) {
            this.shutdownFuture = Optional.of(new CompletableFuture());
        }
        this.delayed.clear();
        if (this.fifo.isEmpty()) {
            this.shutdownFuture.get().complete(null);
        }
        return this.shutdownFuture.get();
    }

    public boolean poll() {
        while (!this.delayed.isEmpty() && this.delayed.peek().getDelay(TimeUnit.MILLISECONDS) <= 0L) {
            this.fifo.add(this.delayed.poll());
        }
        Runnable runnable = this.fifo.poll();
        boolean ranTask = false;
        if (runnable != null) {
            runnable.run();
            ranTask = true;
        }
        if (this.shutdownFuture.isPresent() && this.fifo.isEmpty()) {
            this.shutdownFuture.get().complete(null);
        }
        return ranTask;
    }

    private void ensureAccepting() {
        if (this.shutdownFuture.isPresent()) {
            throw new RejectedExecutionException("event executor shutting down");
        }
    }

    private static <T> Runnable completioner(CompletableFuture<T> future, Callable<T> task) {
        return () -> {
            try {
                if (!future.isDone()) {
                    future.complete(task.call());
                }
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        };
    }

    private final class ScheduledRunnable
    implements Runnable,
    Delayed {
        private final Runnable runnable;
        private final long expires;
        private final CompletableFuture<?> future;

        ScheduledRunnable(CompletableFuture<?> future, Runnable runnable, long delay, TimeUnit timeUnit) {
            this.runnable = runnable;
            this.expires = MockEventExecutor.this.time.milliseconds() + timeUnit.toMillis(delay);
            this.future = future;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expires - MockEventExecutor.this.time.milliseconds(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            ScheduledRunnable that = (ScheduledRunnable)other;
            return Long.compare(this.expires, that.expires);
        }

        public CompletableFuture<?> future() {
            return this.future;
        }
    }
}

