/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.TenantUtils;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TenantUtilsTest {
    private static final String TENANT_1 = "lkc-8vgl6g2";
    private static final String TENANT_1_TOPIC_1 = "lkc-8vgl6g2_console-consumer";

    TenantUtilsTest() {
    }

    @Test
    void testExtractTenantPrefix() {
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantUtils.extractTenantPrefix((String)TENANT_1_TOPIC_1, (boolean)true));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_bla", (boolean)true));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"lkc-8vg", (boolean)true));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"not_a_tenant", (boolean)true));
        Assertions.assertEquals((Object)TENANT_1, (Object)TenantUtils.extractTenantPrefix((String)TENANT_1_TOPIC_1, (boolean)false));
        Assertions.assertEquals((Object)TENANT_1, (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_bla", (boolean)false));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"lkc-8vg", (boolean)false));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"not_a_tenant", (boolean)false));
    }

    @Test
    void testExtractTenantId() {
        Assertions.assertEquals(Optional.of(TENANT_1), (Object)TenantUtils.extractTenantId(Set.of(TENANT_1_TOPIC_1)));
        Assertions.assertEquals(Optional.of(TENANT_1), (Object)TenantUtils.extractTenantId(Set.of("lkc-8vgl6g2_bla")));
        Assertions.assertEquals(Optional.empty(), (Object)TenantUtils.extractTenantId(Set.of("lkc-8vg")));
        Assertions.assertEquals(Optional.empty(), (Object)TenantUtils.extractTenantId(Set.of("not_a_tenant")));
    }

    @Test
    void testAddTenantPrefix() {
        Assertions.assertEquals((Object)"lkc-8vgl6g2_events", (Object)TenantUtils.addTenantPrefix((String)"lkc-8vgl6g2_", (String)"events"));
    }

    @Test
    void testRemoveTenantPrefix() {
        Assertions.assertEquals((Object)"topic-1", (Object)TenantUtils.removeTenantPrefix((String)"lkc-8vgl6g2_topic-1"));
        Assertions.assertEquals((Object)"__consumer_offsets", (Object)TenantUtils.removeTenantPrefix((String)"__consumer_offsets"));
        Assertions.assertNull((Object)TenantUtils.removeTenantPrefix((String)"lkc-8vg"));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_events", (Object)TenantUtils.removeTenantPrefix((String)"lkc-12345_", (String)"lkc-8vgl6g2_events"));
        Assertions.assertEquals((Object)"events", (Object)TenantUtils.removeTenantPrefix((String)"lkc-8vgl6g2_", (String)"lkc-8vgl6g2_events"));
    }

    @Test
    void testTenantPrefixer() {
        Assertions.assertEquals((Object)"events", TenantUtils.tenantPrefixer((String)"__consumer_offsets").apply("events"));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_events", TenantUtils.tenantPrefixer((String)"lkc-8vgl6g2_topic-1").apply("events"));
    }

    @Test
    void testTenantUnprefixer() {
        Assertions.assertEquals((Object)"lkc-8vgl6g2_events", TenantUtils.tenantUnprefixer((String)"__consumer_offsets").apply("lkc-8vgl6g2_events"));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_events", TenantUtils.tenantUnprefixer((String)"lkc-12345_topic-1").apply("lkc-8vgl6g2_events"));
        Assertions.assertEquals((Object)"events", TenantUtils.tenantUnprefixer((String)"lkc-8vgl6g2_topic-1").apply("lkc-8vgl6g2_events"));
    }
}

