/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Optional;
import org.apache.kafka.metadata.TopicType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicTypeTest {
    @Test
    public void testTopicType() {
        TopicTypeTest.testTopicTypeForCorrectIdAndLogConfigValue(TopicType.STANDARD, (byte)0, "standard");
        TopicTypeTest.testTopicTypeForCorrectIdAndLogConfigValue(TopicType.FREIGHT, (byte)1, "freight");
        TopicTypeTest.testTopicTypeForCorrectIdAndLogConfigValue(TopicType.VIRTUAL, (byte)2, "virtual");
    }

    @Test
    public void testUnknownTopicType() {
        byte unknownId = -1;
        String unknownLogConfigValue = "unknownLogConfigValue";
        Assertions.assertEquals((Object)TopicType.UNKNOWN, (Object)TopicType.forId((byte)unknownId));
        Assertions.assertThrows(IllegalStateException.class, () -> TopicType.forIdOrThrow((byte)unknownId));
        Assertions.assertEquals(Optional.of(TopicType.UNKNOWN), (Object)TopicType.forLogConfigValue((String)unknownLogConfigValue));
        Assertions.assertThrows(IllegalStateException.class, () -> TopicType.forLogConfigValueOrThrow((String)unknownLogConfigValue));
    }

    @Test
    public void testEmptyTopicType() {
        String emptyLogConfigValue = "";
        Assertions.assertEquals(Optional.empty(), (Object)TopicType.forLogConfigValue((String)emptyLogConfigValue));
        Assertions.assertThrows(IllegalStateException.class, () -> TopicType.forLogConfigValueOrThrow((String)emptyLogConfigValue));
    }

    private static void testTopicTypeForCorrectIdAndLogConfigValue(TopicType topicType, byte expectedByte, String expectedLogConfigValue) {
        Assertions.assertEquals((byte)expectedByte, (byte)topicType.id());
        Assertions.assertEquals((Object)expectedLogConfigValue, (Object)topicType.logConfigValue());
        Assertions.assertEquals((Object)topicType, (Object)TopicType.forId((byte)expectedByte));
        Assertions.assertEquals((Object)topicType, (Object)TopicType.forIdOrThrow((byte)expectedByte));
        Assertions.assertEquals(Optional.of(topicType), (Object)TopicType.forLogConfigValue((String)expectedLogConfigValue));
        Assertions.assertEquals((Object)topicType, (Object)TopicType.forLogConfigValueOrThrow((String)expectedLogConfigValue));
    }
}

