/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.HashSet;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class MetadataVersionTest {
    MetadataVersionTest() {
    }

    @Test
    public void testFeatureLevels() {
        short lastApacheFeatureLevelSeen = -1;
        for (int i = MetadataVersion.MINIMUM_VERSION.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            short thisApacheFeatureLevel;
            short minApacheFeatureLevel = lastApacheFeatureLevelSeen;
            if (minApacheFeatureLevel < 0) {
                minApacheFeatureLevel = MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel();
            }
            Assertions.assertTrue(((thisApacheFeatureLevel = MetadataVersion.VERSIONS[i].apacheFeatureLevel()) == minApacheFeatureLevel || thisApacheFeatureLevel == minApacheFeatureLevel + 1 ? 1 : 0) != 0);
            lastApacheFeatureLevelSeen = thisApacheFeatureLevel;
            int expectedConfluentLevel = i + MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel();
            Assertions.assertEquals((int)expectedConfluentLevel, (int)MetadataVersion.VERSIONS[i].confluentFeatureLevel());
        }
    }

    @Test
    public void testFromVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"3.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"3.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"3.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"3.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV0, (Object)MetadataVersion.fromVersionString((String)"3.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV1, (Object)MetadataVersion.fromVersionString((String)"3.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV2, (Object)MetadataVersion.fromVersionString((String)"3.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV3, (Object)MetadataVersion.fromVersionString((String)"3.7-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7-IV4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0A, (Object)MetadataVersion.fromVersionString((String)"3.8-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.8-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.9"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.9-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0A, (Object)MetadataVersion.fromVersionString((String)"3.9-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0B, (Object)MetadataVersion.fromVersionString((String)"3.9-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3B, (Object)MetadataVersion.fromVersionString((String)"4.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV0A, (Object)MetadataVersion.fromVersionString((String)"4.0-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1A, (Object)MetadataVersion.fromVersionString((String)"4.0-IV1A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV2A, (Object)MetadataVersion.fromVersionString((String)"4.0-IV2A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3A, (Object)MetadataVersion.fromVersionString((String)"4.0-IV3A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3B, (Object)MetadataVersion.fromVersionString((String)"4.0-IV3B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1A, (Object)MetadataVersion.fromVersionString((String)"4.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV0A, (Object)MetadataVersion.fromVersionString((String)"4.1-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV0B, (Object)MetadataVersion.fromVersionString((String)"4.1-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1A, (Object)MetadataVersion.fromVersionString((String)"4.1-IV1A"));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.shortVersion()));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.version()));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.versionWithSuffix()));
    }

    @Test
    public void testFromConfluentVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"CP-7.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"CP-7.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV3, (Object)MetadataVersion.fromVersionString((String)"CP-7.7-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"CP-7.7-IV4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"CP-7.7"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0A, (Object)MetadataVersion.fromVersionString((String)"CP-7.8-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-7.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-7.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-7.8-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-7.9"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0A, (Object)MetadataVersion.fromVersionString((String)"CP-7.9-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-7.9-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3B, (Object)MetadataVersion.fromVersionString((String)"CP-8.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV0A, (Object)MetadataVersion.fromVersionString((String)"CP-8.0-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1A, (Object)MetadataVersion.fromVersionString((String)"CP-8.0-IV1A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV2A, (Object)MetadataVersion.fromVersionString((String)"CP-8.0-IV2A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3A, (Object)MetadataVersion.fromVersionString((String)"CP-8.0-IV3A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV3B, (Object)MetadataVersion.fromVersionString((String)"CP-8.0-IV3B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1A, (Object)MetadataVersion.fromVersionString((String)"CP-8.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV0A, (Object)MetadataVersion.fromVersionString((String)"CP-8.1-IV0A"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV0B, (Object)MetadataVersion.fromVersionString((String)"CP-8.1-IV0B"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_1_IV1A, (Object)MetadataVersion.fromVersionString((String)"CP-8.1-IV1A"));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.shortConfluentRelease()));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.confluentReleaseWithOutSuffix()));
        Assertions.assertEquals((Object)MetadataVersion.LATEST_PRODUCTION, (Object)MetadataVersion.fromVersionString((String)MetadataVersion.LATEST_PRODUCTION.confluentRelease()));
    }

    @Test
    public void testFromConfluentFeatureLevel() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromConfluentFeatureLevel((short)7));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)109));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)108));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromConfluentFeatureLevel((short)107));
        for (int i = 8; i <= 100; ++i) {
            short confluentFeatureLevelThatShouldNotWork = (short)i;
            Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromConfluentFeatureLevel((short)confluentFeatureLevelThatShouldNotWork));
        }
    }

    @Test
    public void testShortVersion() {
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.4", (Object)MetadataVersion.IBP_3_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV4.shortVersion());
        Assertions.assertEquals((Object)"3.8", (Object)MetadataVersion.IBP_3_8_IV0A.shortVersion());
        Assertions.assertEquals((Object)"3.8", (Object)MetadataVersion.IBP_3_8_IV0B.shortVersion());
        Assertions.assertEquals((Object)"3.9", (Object)MetadataVersion.IBP_3_9_IV0A.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV0A.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV1A.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV2A.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV3A.shortVersion());
        Assertions.assertEquals((Object)"4.1", (Object)MetadataVersion.IBP_4_1_IV0A.shortVersion());
        Assertions.assertEquals((Object)"4.1", (Object)MetadataVersion.IBP_4_1_IV0B.shortVersion());
        Assertions.assertEquals((Object)"4.1", (Object)MetadataVersion.IBP_4_1_IV1A.shortVersion());
    }

    @Test
    public void testVersion() {
        Assertions.assertEquals((Object)"3.3-IV3", (Object)MetadataVersion.IBP_3_3_IV3.version());
        Assertions.assertEquals((Object)"3.4-IV0", (Object)MetadataVersion.IBP_3_4_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV0", (Object)MetadataVersion.IBP_3_5_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV1", (Object)MetadataVersion.IBP_3_5_IV1.version());
        Assertions.assertEquals((Object)"3.5-IV2", (Object)MetadataVersion.IBP_3_5_IV2.version());
        Assertions.assertEquals((Object)"3.6-IV0", (Object)MetadataVersion.IBP_3_6_IV0.version());
        Assertions.assertEquals((Object)"3.6-IV1", (Object)MetadataVersion.IBP_3_6_IV1.version());
        Assertions.assertEquals((Object)"3.6-IV2", (Object)MetadataVersion.IBP_3_6_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV0", (Object)MetadataVersion.IBP_3_7_IV0.version());
        Assertions.assertEquals((Object)"3.7-IV1", (Object)MetadataVersion.IBP_3_7_IV1.version());
        Assertions.assertEquals((Object)"3.7-IV2", (Object)MetadataVersion.IBP_3_7_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV3", (Object)MetadataVersion.IBP_3_7_IV3.version());
        Assertions.assertEquals((Object)"3.7-IV4", (Object)MetadataVersion.IBP_3_7_IV4.version());
        Assertions.assertEquals((Object)"3.8-IV0", (Object)MetadataVersion.IBP_3_8_IV0A.version());
        Assertions.assertEquals((Object)"3.8-IV0", (Object)MetadataVersion.IBP_3_8_IV0B.version());
        Assertions.assertEquals((Object)"3.9-IV0", (Object)MetadataVersion.IBP_3_9_IV0A.version());
        Assertions.assertEquals((Object)"4.0-IV0", (Object)MetadataVersion.IBP_4_0_IV0A.version());
        Assertions.assertEquals((Object)"4.0-IV1", (Object)MetadataVersion.IBP_4_0_IV1A.version());
        Assertions.assertEquals((Object)"4.0-IV2", (Object)MetadataVersion.IBP_4_0_IV2A.version());
        Assertions.assertEquals((Object)"4.0-IV3", (Object)MetadataVersion.IBP_4_0_IV3A.version());
        Assertions.assertEquals((Object)"4.1-IV0", (Object)MetadataVersion.IBP_4_1_IV0A.version());
        Assertions.assertEquals((Object)"4.1-IV0", (Object)MetadataVersion.IBP_4_1_IV0B.version());
    }

    @Test
    public void testPrevious() {
        for (int i = 1; i < MetadataVersion.VERSIONS.length - 2; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            Assertions.assertTrue((boolean)version.previous().isPresent(), (String)version.toString());
            Assertions.assertEquals((Object)MetadataVersion.VERSIONS[i - 1], version.previous().get());
        }
    }

    @Test
    public void testMetadataChanged() {
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV1, (MetadataVersion)MetadataVersion.IBP_3_4_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV2, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_6_IV0, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_6_IV2, (MetadataVersion)MetadataVersion.IBP_3_6_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_7_IV0, (MetadataVersion)MetadataVersion.IBP_3_6_IV2));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_7_IV1, (MetadataVersion)MetadataVersion.IBP_3_7_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_7_IV2, (MetadataVersion)MetadataVersion.IBP_3_7_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_7_IV3, (MetadataVersion)MetadataVersion.IBP_3_7_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_7_IV4, (MetadataVersion)MetadataVersion.IBP_3_7_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_8_IV0A, (MetadataVersion)MetadataVersion.IBP_3_7_IV4));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_8_IV0B, (MetadataVersion)MetadataVersion.IBP_3_8_IV0A));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_8_IV0A, (MetadataVersion)MetadataVersion.IBP_3_9_IV0A));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_9_IV0A, (MetadataVersion)MetadataVersion.IBP_3_9_IV0B));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_9_IV0B, (MetadataVersion)MetadataVersion.IBP_4_0_IV0A));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_4_0_IV0A, (MetadataVersion)MetadataVersion.IBP_4_0_IV1A));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_4_0_IV1A, (MetadataVersion)MetadataVersion.IBP_4_0_IV2A));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_4_0_IV2A, (MetadataVersion)MetadataVersion.IBP_4_0_IV3A));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_4_0_IV3A, (MetadataVersion)MetadataVersion.IBP_4_0_IV3B));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV3, (MetadataVersion)MetadataVersion.IBP_3_4_IV0));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV0, (MetadataVersion)MetadataVersion.IBP_3_5_IV1));
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV2, (MetadataVersion)MetadataVersion.IBP_3_6_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV1, (MetadataVersion)MetadataVersion.IBP_3_6_IV0));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testTopicPlacementVersion(MetadataVersion metadataVersion) {
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_5_IV0)) {
            Assertions.assertFalse((boolean)metadataVersion.isTopicPlacementSupported());
        } else {
            Assertions.assertTrue((boolean)metadataVersion.isTopicPlacementSupported());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsDelegationTokenSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_6_IV2), (Object)metadataVersion.isDelegationTokenSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsClusterLinkingFailbackSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV1), (Object)metadataVersion.isClusterLinkingFailbackSupported());
        if (!metadataVersion.isClusterLinkingFailbackSupported()) {
            Assertions.assertEquals((int)0, (int)metadataVersion.mirrorRecordVersion());
            Assertions.assertEquals((int)0, (int)metadataVersion.mirrorChangeRecordVersion());
        } else if (!metadataVersion.isLeaderEpochBumpedOnMirrorTransition()) {
            Assertions.assertEquals((int)1, (int)metadataVersion.mirrorRecordVersion());
            Assertions.assertEquals((int)1, (int)metadataVersion.mirrorChangeRecordVersion());
        } else {
            Assertions.assertEquals((int)1, (int)metadataVersion.mirrorRecordVersion());
            Assertions.assertEquals((int)2, (int)metadataVersion.mirrorChangeRecordVersion());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsSwitchoverControlPlaneTimestampSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV3B), (Object)metadataVersion.isSwitchoverControlPlaneTimestampSupported());
        if (!metadataVersion.isSwitchoverControlPlaneTimestampSupported()) {
            Assertions.assertEquals((int)0, (int)metadataVersion.clusterLinkChangeRecordVersion());
        } else {
            Assertions.assertEquals((int)1, (int)metadataVersion.clusterLinkChangeRecordVersion());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testDirectoryAssignmentSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2), (Object)metadataVersion.isDirectoryAssignmentSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsElrSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV1A), (Object)metadataVersion.isElrSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsTopicTypeSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV1), (Object)metadataVersion.isTopicTypeSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionChangeRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionChangeRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testTenantRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTenantStripingSupported() ? (short)1 : 0;
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.tenantRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3) ? (short)1 : 0));
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.registerBrokerRecordVersion());
    }

    @Test
    public void testConfluentMetadataVersion() {
        HashSet<Short> confluentFeatureLevels = new HashSet<Short>();
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            Assertions.assertTrue((metadataVersion.confluentFeatureLevel() >= metadataVersion.apacheFeatureLevel() ? 1 : 0) != 0, (String)"Each Confluent metadata version should be at least as high as the equivalent Apache feature level");
            Assertions.assertFalse((boolean)confluentFeatureLevels.contains(metadataVersion.confluentFeatureLevel()), (String)"Confluent feature levels versions must be unique");
            confluentFeatureLevels.add(metadataVersion.confluentFeatureLevel());
            short apacheLevel = metadataVersion.apacheFeatureLevel();
            Assertions.assertTrue((boolean)metadataVersion.isAtLeast(MetadataVersion.fromApacheFeatureLevel((short)apacheLevel)), (String)"Each apache version should correspond to an internal version that at least as high as it");
            Assertions.assertEquals((short)apacheLevel, (short)MetadataVersion.fromApacheFeatureLevel((short)apacheLevel).apacheFeatureLevel());
        }
    }

    @Test
    public void testMonotonicVersions() {
        short lastConfluentLevel = (short)(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel() - 1);
        short lastApacheLevel = (short)(MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel() - 1);
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            Assertions.assertEquals((int)(lastConfluentLevel + 1), (int)metadataVersion.confluentFeatureLevel());
            Assertions.assertTrue((metadataVersion.apacheFeatureLevel() >= lastApacheLevel ? 1 : 0) != 0);
            lastConfluentLevel = metadataVersion.confluentFeatureLevel();
            lastApacheLevel = metadataVersion.apacheFeatureLevel();
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsSettingBrokerMetadataEncryptorsSupported(MetadataVersion metadataVersion) {
        boolean expected = metadataVersion.isAtLeast(MetadataVersion.IBP_3_5_IV0);
        Assertions.assertEquals((Object)expected, (Object)metadataVersion.isSettingBrokerMetadataEncryptorsSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsTenantStripingSupported(MetadataVersion metadataVersion) {
        boolean expected = metadataVersion.isAtLeast(MetadataVersion.IBP_3_8_IV0B);
        Assertions.assertEquals((Object)expected, (Object)metadataVersion.isTenantStripingSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsSettingControllerMetadataEncryptorsSupported(MetadataVersion metadataVersion) {
        boolean expected = metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV0);
        Assertions.assertEquals((Object)expected, (Object)metadataVersion.isSettingControllerMetadataEncryptorsSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsExternalConnectivitySupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2), (Object)metadataVersion.isExternalConnectivitySupported());
    }

    @Test
    public void assertLatestProductionIsLessThanLatest() {
        Assertions.assertTrue((MetadataVersion.LATEST_PRODUCTION.ordinal() < MetadataVersion.latestTesting().ordinal() ? 1 : 0) != 0, (String)("Expected LATEST_PRODUCTION " + String.valueOf(MetadataVersion.LATEST_PRODUCTION) + " to be less than the latest of " + String.valueOf(MetadataVersion.latestTesting())));
    }

    @Test
    public void testProductionMetadataDontUseUnstableApiVersion() {
        MetadataVersion mv = MetadataVersion.latestProduction();
        Assertions.assertTrue((mv.listOffsetRequestVersion() <= ApiKeys.LIST_OFFSETS.latestVersion(false) ? 1 : 0) != 0);
        Assertions.assertTrue((mv.fetchRequestVersion() <= ApiKeys.FETCH.latestVersion(false) ? 1 : 0) != 0);
    }

    @Test
    public void assertLatestProductionIsProduction() {
        Assertions.assertTrue((boolean)MetadataVersion.LATEST_PRODUCTION.isProduction());
    }

    @Test
    public void assertLatestIsNotProduction() {
        Assertions.assertFalse((boolean)MetadataVersion.latestTesting().isProduction());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testListOffsetsValueVersion(MetadataVersion metadataVersion) {
        int expectedVersion = 10;
        if (metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV3A)) {
            Assertions.assertEquals((short)10, (short)metadataVersion.listOffsetRequestVersion());
        } else {
            Assertions.assertTrue((metadataVersion.listOffsetRequestVersion() < 10 ? 1 : 0) != 0);
        }
    }
}

