/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.server.immutable.DelegationChecker;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.apache.kafka.server.immutable.pcollections.PCollectionsImmutableNavigableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.pcollections.AbstractUnmodifiableMap;
import org.pcollections.PSortedMap;
import org.pcollections.PSortedSet;
import org.pcollections.TreePMap;
import org.pcollections.TreePSet;

public class PCollectionsImmutableNavigableMapTest {
    private static final TreePMap<Integer, Integer> SINGLETON_MAP = TreePMap.singleton((Comparable)Integer.valueOf(10), (Object)20);

    @Test
    public void testEmptyMap() {
        Assertions.assertEquals((Object)TreePMap.empty(), (Object)((PCollectionsImmutableNavigableMap)ImmutableNavigableMap.empty()).underlying());
    }

    @Test
    public void testSingletonMap() {
        Assertions.assertEquals((Object)TreePMap.singleton((Comparable)Integer.valueOf(1), (Object)2), (Object)((PCollectionsImmutableNavigableMap)ImmutableNavigableMap.singleton((Comparable)Integer.valueOf(1), (Object)2)).underlying());
    }

    @Test
    public void testUnderlying() {
        Assertions.assertSame(SINGLETON_MAP, (Object)new PCollectionsImmutableNavigableMap(SINGLETON_MAP).underlying());
    }

    @Test
    public void testDelegationOfUpdated() {
        Map.Entry entry = SINGLETON_MAP.firstEntry();
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.plus(ArgumentMatchers.eq((Object)((Integer)entry.getKey())), ArgumentMatchers.eq((Object)((Integer)entry.getValue()))), SINGLETON_MAP).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.updated(entry.getKey(), entry.getValue()), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfRemoved() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.minus((Object)ArgumentMatchers.eq((int)10)), SINGLETON_MAP).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.removed((Object)10), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfLowerEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(9, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.lowerEntry((Object)ArgumentMatchers.eq((int)10)), entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.lowerEntry((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={9, 8})
    public void testDelegationOfLowerKey(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.lowerKey((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.lowerKey((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfFloorEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(9, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.floorEntry((Object)ArgumentMatchers.eq((int)10)), entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.floorEntry((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={9, 10})
    public void testDelegationOfFloorKey(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.floorKey((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.floorKey((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfCeilingEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(10, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.ceilingEntry((Object)ArgumentMatchers.eq((int)10)), entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.ceilingEntry((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={11, 10})
    public void testDelegationOfCeilingKey(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.ceilingKey((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.ceilingKey((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfHigherEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(11, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.higherEntry((Object)ArgumentMatchers.eq((int)10)), entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.higherEntry((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={12, 13})
    public void testDelegationOfHigherKey(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.higherKey((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.higherKey((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionFirstEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(9, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::firstEntry, entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::firstEntry, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionLastEntry() {
        AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(9, 20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::lastEntry, entry).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::lastEntry, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPollFirstEntry() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(PSortedMap::pollFirstEntry).defineWrapperUnsupportedFunctionInvocation(PCollectionsImmutableNavigableMap::pollFirstEntry).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPollLastEntry() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(PSortedMap::pollLastEntry).defineWrapperUnsupportedFunctionInvocation(PCollectionsImmutableNavigableMap::pollLastEntry).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfDescendingMap() {
        TreePMap testSet = TreePMap.singleton((Comparable)Integer.valueOf(2), (Object)10).plus((Object)3, (Object)20).descendingMap();
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::descendingMap, testSet).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::descendingMap, Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfNavigableKeySet() {
        TreePSet testSet = TreePMap.singleton((Comparable)Integer.valueOf(2), (Object)10).plus((Object)3, (Object)20).navigableKeySet();
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::navigableKeySet, testSet).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::navigableKeySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfDescendingKeySet() {
        PSortedSet testSet = TreePMap.singleton((Comparable)Integer.valueOf(2), (Object)10).plus((Object)3, (Object)20).descendingKeySet();
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::descendingKeySet, testSet).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::descendingKeySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSubMapWithFromAndToElements() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.subMap((Object)ArgumentMatchers.eq((int)10), ArgumentMatchers.eq((boolean)true), (Object)ArgumentMatchers.eq((int)30), ArgumentMatchers.eq((boolean)false)), TreePMap.singleton((Comparable)Integer.valueOf(15), (Object)15)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.subMap((Object)10, true, (Object)30, false), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfHeadMapInclusive() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.headMap((Object)ArgumentMatchers.eq((int)15), ArgumentMatchers.eq((boolean)true)), TreePMap.singleton((Comparable)Integer.valueOf(13), (Object)13)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.headMap((Object)15, true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfTailMapInclusive() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.tailMap((Object)ArgumentMatchers.eq((int)15), ArgumentMatchers.eq((boolean)true)), TreePMap.singleton((Comparable)Integer.valueOf(15), (Object)15)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.tailMap((Object)15, true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfComparator() {
        TreePMap testMap = TreePMap.singleton((Comparable)Integer.valueOf(2), (Object)10).plus((Object)3, (Object)20);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::comparator, testMap.comparator()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::comparator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSubMapWithFromElement() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.subMap((Object)ArgumentMatchers.eq((int)15), (Object)ArgumentMatchers.eq((boolean)true)), TreePMap.singleton((Comparable)Integer.valueOf(13), (Object)13)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.subMap((Object)15, (Object)true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfHeadMap() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.headMap((Object)ArgumentMatchers.eq((int)15)), TreePMap.singleton((Comparable)Integer.valueOf(13), (Object)13)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.headMap((Object)15), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfTailMap() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.tailMap((Object)ArgumentMatchers.eq((int)15)), TreePMap.singleton((Comparable)Integer.valueOf(18), (Object)18)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.tailMap((Object)15), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfFirstKey(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::firstKey, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::firstKey, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfLast(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::lastKey, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::lastKey, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfSize(int mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::size, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::size, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfIsEmpty(boolean mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::isEmpty, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::isEmpty, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsKey(boolean mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsKey(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsKey((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsValue(boolean mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsValue(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsValue((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testEquals() {
        TreePMap mock = (TreePMap)Mockito.mock(TreePMap.class);
        Assertions.assertEquals((Object)new PCollectionsImmutableNavigableMap(mock), (Object)new PCollectionsImmutableNavigableMap(mock));
        TreePMap someOtherMock = (TreePMap)Mockito.mock(TreePMap.class);
        Assertions.assertNotEquals((Object)new PCollectionsImmutableNavigableMap(mock), (Object)new PCollectionsImmutableNavigableMap(someOtherMock));
    }

    @Test
    public void testHashCode() {
        TreePMap mock = (TreePMap)Mockito.mock(TreePMap.class);
        Assertions.assertEquals((int)mock.hashCode(), (int)new PCollectionsImmutableNavigableMap(mock).hashCode());
        TreePMap someOtherMock = (TreePMap)Mockito.mock(TreePMap.class);
        Assertions.assertNotEquals((int)mock.hashCode(), (int)new PCollectionsImmutableNavigableMap(someOtherMock).hashCode());
    }

    @Test
    public void testDelegationOfGetOrDefault() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.getOrDefault(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), this).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.getOrDefault((Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfForEach() {
        BiConsumer mockBiConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.forEach((BiConsumer)ArgumentMatchers.eq((Object)mockBiConsumer))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.forEach(mockBiConsumer)).doVoidMethodDelegationCheck();
    }

    @Test
    public void testDelegationOfGet() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.get(ArgumentMatchers.eq((Object)this)), new Object()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.get((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPut() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.put(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.put((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveByKey() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.remove(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.remove((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPutAll() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.putAll((Map)ArgumentMatchers.eq(Map.of()))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.putAll(Map.of())).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionClear() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(AbstractUnmodifiableMap::clear).defineWrapperVoidMethodInvocation(PCollectionsImmutableNavigableMap::clear).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfKeySet() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::keySet, TreePSet.singleton((Comparable)Integer.valueOf(10))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::keySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfValues() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::values, Set.of()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::values, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfEntrySet() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePMap::entrySet, Set.of()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::entrySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionReplaceAll() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.replaceAll((BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.replaceAll(mockBiFunction)).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPutIfAbsent() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.putIfAbsent(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.putIfAbsent((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfUnsupportedFunctionRemoveByKeyAndValue(boolean mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.remove(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.remove((Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfUnsupportedFunctionReplaceWhenMappedToSpecificValue(boolean mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.replace(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.replace((Object)this, (Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionReplaceWhenMappedToAnyValue() {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.replace(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.replace((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionComputeIfAbsent() {
        Function mockFunction = (Function)Mockito.mock(Function.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.computeIfAbsent(ArgumentMatchers.eq((Object)this), (Function)ArgumentMatchers.eq((Object)mockFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.computeIfAbsent((Object)this, mockFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionComputeIfPresent() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.computeIfPresent(ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.computeIfPresent((Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionCompute() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.compute(ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.compute((Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionMerge() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.merge(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.merge((Object)this, (Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "b"})
    public void testDelegationOfToString(String mockFunctionReturnValue) {
        new PCollectionsTreeMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::toString, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableMap::toString, text -> "PCollectionsImmutableNavigableMap{underlying=" + String.valueOf(text) + "}").doFunctionDelegationCheck();
    }

    private static final class PCollectionsTreeMapWrapperDelegationChecker<R>
    extends DelegationChecker<TreePMap<Object, Object>, PCollectionsImmutableNavigableMap<Object, Object>, R> {
        public PCollectionsTreeMapWrapperDelegationChecker() {
            super((TreePMap)Mockito.mock(TreePMap.class), PCollectionsImmutableNavigableMap::new);
        }

        @Override
        public TreePMap<Object, Object> unwrap(PCollectionsImmutableNavigableMap<Object, Object> wrapper) {
            return wrapper.underlying();
        }
    }
}

