/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.kafka.server.immutable.DelegationChecker;
import org.apache.kafka.server.immutable.ImmutableNavigableSet;
import org.apache.kafka.server.immutable.pcollections.PCollectionsImmutableNavigableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.pcollections.AbstractUnmodifiableSet;
import org.pcollections.HashTreePSet;
import org.pcollections.PSortedSet;
import org.pcollections.TreePSet;

public class PCollectionsImmutableNavigableSetTest {
    private static final TreePSet<Integer> SINGLETON_SET = TreePSet.singleton((Comparable)Integer.valueOf(new Random().nextInt()));

    @Test
    public void testEmptySet() {
        Assertions.assertEquals((Object)HashTreePSet.empty(), (Object)((PCollectionsImmutableNavigableSet)ImmutableNavigableSet.empty()).underlying());
    }

    @Test
    public void testSingletonSet() {
        Assertions.assertEquals((Object)HashTreePSet.singleton((Object)1), (Object)((PCollectionsImmutableNavigableSet)ImmutableNavigableSet.singleton((Comparable)Integer.valueOf(1))).underlying());
    }

    @Test
    public void testUnderlying() {
        Assertions.assertSame(SINGLETON_SET, (Object)new PCollectionsImmutableNavigableSet(SINGLETON_SET).underlying());
    }

    @Test
    public void testDelegationOfAdded() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.plus(ArgumentMatchers.eq((Object)((Integer)SINGLETON_SET.first()))), SINGLETON_SET).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.added(SINGLETON_SET.first()), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfRemoved() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.minus((Object)ArgumentMatchers.eq((int)10)), SINGLETON_SET).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.removed((Object)10), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={9, 4})
    public void testDelegationOfLower(int mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.lower((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.lower((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={9, 10})
    public void testDelegationOfFloor(int mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.floor((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.floor((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={11, 10})
    public void testDelegationOfCeiling(int mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.ceiling((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.ceiling((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={12, 13})
    public void testDelegationOfHigher(int mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.higher((Object)ArgumentMatchers.eq((int)10)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.higher((Object)10), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPollFirst() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(PSortedSet::pollFirst).defineWrapperUnsupportedFunctionInvocation(PCollectionsImmutableNavigableSet::pollFirst).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPollLast() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(PSortedSet::pollLast).defineWrapperUnsupportedFunctionInvocation(PCollectionsImmutableNavigableSet::pollLast).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfDescendingSet() {
        TreePSet testSet = TreePSet.from(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::descendingSet, testSet.descendingSet()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::descendingSet, Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfDescendingIterator() {
        TreePSet testSet = TreePSet.from(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::descendingIterator, testSet.descendingIterator()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::descendingIterator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSubSetWithFromAndToElements() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.subSet((Object)ArgumentMatchers.eq((int)10), ArgumentMatchers.eq((boolean)true), (Object)ArgumentMatchers.eq((int)30), ArgumentMatchers.eq((boolean)false)), TreePSet.singleton((Comparable)Integer.valueOf(15))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.subSet((Object)10, true, (Object)30, false), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfHeadSetInclusive() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.headSet((Object)ArgumentMatchers.eq((int)15), ArgumentMatchers.eq((boolean)true)), TreePSet.singleton((Comparable)Integer.valueOf(13))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.headSet((Object)15, true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfTailSetInclusive() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.tailSet((Object)ArgumentMatchers.eq((int)15), ArgumentMatchers.eq((boolean)true)), TreePSet.singleton((Comparable)Integer.valueOf(15))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.tailSet((Object)15, true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfComparator() {
        TreePSet testSet = TreePSet.from(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::comparator, testSet.comparator()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::comparator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSubSetWithFromElement() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.subSet((Object)ArgumentMatchers.eq((int)15), (Object)ArgumentMatchers.eq((boolean)true)), TreePSet.singleton((Comparable)Integer.valueOf(13))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.subSet((Object)15, (Object)true), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfHeadSet() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.headSet((Object)ArgumentMatchers.eq((int)15)), TreePSet.singleton((Comparable)Integer.valueOf(13))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.headSet((Object)15), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfTailSet() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.tailSet((Object)ArgumentMatchers.eq((int)15)), TreePSet.singleton((Comparable)Integer.valueOf(13))).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.tailSet((Object)15), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfFirst() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::first, 13).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::first, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfLast() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::last, 13).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::last, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfSize(int mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::size, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::size, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfIsEmpty(boolean mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::isEmpty, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::isEmpty, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContains(boolean mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.contains(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.contains((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfIterator() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(TreePSet::iterator, Mockito.mock(Iterator.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::iterator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfForEach() {
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.forEach((Consumer)ArgumentMatchers.eq((Object)mockConsumer))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.forEach(mockConsumer)).doVoidMethodDelegationCheck();
    }

    @Test
    public void testDelegationOfToArray() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::toArray, new Object[0]).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::toArray, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfToArrayIntoGivenDestination() {
        Object[] destinationArray = new Object[]{};
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.toArray((Object[])ArgumentMatchers.eq((Object)destinationArray)), new Object[0]).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.toArray(destinationArray), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionAdd() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.add(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.add((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemove() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.remove(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.remove((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsAll(boolean mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsAll((Collection)ArgumentMatchers.eq(List.of())), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsAll(List.of()), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionAddAll() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.addAll((Collection)ArgumentMatchers.eq(List.of()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.addAll(List.of())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRetainAll() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.retainAll((Collection)ArgumentMatchers.eq(List.of()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.retainAll(List.of())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveAll() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.removeAll((Collection)ArgumentMatchers.eq(List.of()))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.removeAll(List.of())).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveIf() {
        Predicate mockPredicate = (Predicate)Mockito.mock(Predicate.class);
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.removeIf((Predicate)ArgumentMatchers.eq((Object)mockPredicate))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.removeIf(mockPredicate)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionClear() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(AbstractUnmodifiableSet::clear).defineWrapperVoidMethodInvocation(PCollectionsImmutableNavigableSet::clear).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfSpliterator() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(SortedSet::spliterator, Mockito.mock(Spliterator.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::spliterator, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfStream() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(Collection::stream, Mockito.mock(Stream.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::stream, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfParallelStream() {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(Collection::parallelStream, Mockito.mock(Stream.class)).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::parallelStream, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testEquals() {
        TreePSet mock = (TreePSet)Mockito.mock(TreePSet.class);
        Assertions.assertEquals((Object)new PCollectionsImmutableNavigableSet(mock), (Object)new PCollectionsImmutableNavigableSet(mock));
        TreePSet someOtherMock = (TreePSet)Mockito.mock(TreePSet.class);
        Assertions.assertNotEquals((Object)new PCollectionsImmutableNavigableSet(mock), (Object)new PCollectionsImmutableNavigableSet(someOtherMock));
    }

    @Test
    public void testHashCode() {
        TreePSet mock = (TreePSet)Mockito.mock(TreePSet.class);
        Assertions.assertEquals((int)mock.hashCode(), (int)new PCollectionsImmutableNavigableSet(mock).hashCode());
        TreePSet someOtherMock = (TreePSet)Mockito.mock(TreePSet.class);
        Assertions.assertNotEquals((int)mock.hashCode(), (int)new PCollectionsImmutableNavigableSet(someOtherMock).hashCode());
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "b"})
    public void testDelegationOfToString(String mockFunctionReturnValue) {
        new PCollectionsTreeSetWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractCollection::toString, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableNavigableSet::toString, text -> "PCollectionsImmutableNavigableSet{underlying=" + String.valueOf(text) + "}").doFunctionDelegationCheck();
    }

    private static final class PCollectionsTreeSetWrapperDelegationChecker<R>
    extends DelegationChecker<TreePSet<Object>, PCollectionsImmutableNavigableSet<Object>, R> {
        public PCollectionsTreeSetWrapperDelegationChecker() {
            super((TreePSet)Mockito.mock(TreePSet.class), PCollectionsImmutableNavigableSet::new);
        }

        @Override
        public TreePSet<Object> unwrap(PCollectionsImmutableNavigableSet<Object> wrapper) {
            return wrapper.underlying();
        }
    }
}

