/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.purgatory.DelayedOperationKey;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DelayedOperationTest {
    private final MockKey test1 = new MockKey("test1");
    private final MockKey test2 = new MockKey("test2");
    private final MockKey test3 = new MockKey("test3");
    private final Random random = new Random();
    private DelayedOperationPurgatory<DelayedOperation> purgatory;
    private ScheduledExecutorService executorService;

    @BeforeEach
    public void setUp() {
        this.purgatory = new DelayedOperationPurgatory("mock", 0);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.purgatory.shutdown();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Test
    public void testLockInTryCompleteElseWatch() {
        DelayedOperation op = new DelayedOperation(100000L){

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock).isHeldByCurrentThread());
                return false;
            }

            public boolean safeTryComplete() {
                Assertions.fail((String)"tryCompleteElseWatch should not use safeTryComplete");
                return super.safeTryComplete();
            }
        };
        this.purgatory.tryCompleteElseWatch(op, List.of(new MockKey("key")));
    }

    private DelayedOperation op(final boolean shouldComplete) {
        return new DelayedOperation(this, 100000L){
            final /* synthetic */ DelayedOperationTest this$0;
            {
                this.this$0 = this$0;
                super(delayMs);
            }

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock).isHeldByCurrentThread());
                return shouldComplete;
            }
        };
    }

    @Test
    public void testSafeTryCompleteOrElse() {
        AtomicBoolean pass = new AtomicBoolean();
        Assertions.assertFalse((boolean)this.op(false).safeTryCompleteOrElse(() -> pass.set(true)));
        Assertions.assertTrue((boolean)pass.get());
        Assertions.assertTrue((boolean)this.op(true).safeTryCompleteOrElse(() -> Assertions.fail((String)"this method should NOT be executed")));
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        Assertions.assertEquals((int)0, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test1), (String)"With no waiting requests, nothing should be satisfied");
        Assertions.assertFalse((boolean)this.purgatory.tryCompleteElseWatch((DelayedOperation)r1, List.of(new MockKey("test1"))), (String)"r1 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test1), (String)"Still nothing satisfied");
        Assertions.assertFalse((boolean)this.purgatory.tryCompleteElseWatch((DelayedOperation)r2, List.of(new MockKey("test2"))), (String)"r2 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test2), (String)"Still nothing satisfied");
        r1.completable = true;
        Assertions.assertEquals((int)1, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test1), (String)"r1 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test1), (String)"Nothing satisfied");
        r2.completable = true;
        Assertions.assertEquals((int)1, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test2), (String)"r2 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory.checkAndComplete((DelayedOperationKey)this.test2), (String)"Nothing satisfied");
    }

    @Test
    public void testRequestExpiry() throws Exception {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(expiration);
        MockDelayedOperation r2 = new MockDelayedOperation(200000L);
        Assertions.assertFalse((boolean)this.purgatory.tryCompleteElseWatch((DelayedOperation)r1, List.of(this.test1)), (String)"r1 not satisfied and hence watched");
        Assertions.assertFalse((boolean)this.purgatory.tryCompleteElseWatch((DelayedOperation)r2, List.of(this.test2)), (String)"r2 not satisfied and hence watched");
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assertions.assertTrue((boolean)r1.isCompleted(), (String)"r1 completed due to expiration");
        Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 hasn't completed");
        Assertions.assertTrue((elapsed >= expiration ? 1 : 0) != 0, (String)("Time for expiration " + elapsed + " should at least " + expiration));
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        MockDelayedOperation r3 = new MockDelayedOperation(100000L);
        this.purgatory.tryCompleteElseWatch((DelayedOperation)r1, List.of(this.test1));
        this.purgatory.tryCompleteElseWatch((DelayedOperation)r2, List.of(this.test1, this.test2));
        this.purgatory.tryCompleteElseWatch((DelayedOperation)r3, List.of(this.test1, this.test2, this.test3));
        Assertions.assertEquals((int)3, (int)this.purgatory.numDelayed(), (String)"Purgatory should have 3 total delayed operations");
        Assertions.assertEquals((int)6, (int)this.purgatory.watched(), (String)"Purgatory should have 6 watched elements");
        r2.completable = true;
        r2.tryComplete();
        Assertions.assertEquals((int)2, (int)this.purgatory.numDelayed(), (String)("Purgatory should have 2 total delayed operations instead of " + this.purgatory.numDelayed()));
        r3.completable = true;
        r3.tryComplete();
        Assertions.assertEquals((int)1, (int)this.purgatory.numDelayed(), (String)("Purgatory should have 1 total delayed operations instead of " + this.purgatory.numDelayed()));
        this.purgatory.checkAndComplete((DelayedOperationKey)this.test1);
        Assertions.assertEquals((int)4, (int)this.purgatory.watched(), (String)("Purgatory should have 4 watched elements instead of " + this.purgatory.watched()));
        this.purgatory.checkAndComplete((DelayedOperationKey)this.test2);
        Assertions.assertEquals((int)2, (int)this.purgatory.watched(), (String)("Purgatory should have 2 watched elements instead of " + this.purgatory.watched()));
        this.purgatory.checkAndComplete((DelayedOperationKey)this.test3);
        Assertions.assertEquals((int)1, (int)this.purgatory.watched(), (String)("Purgatory should have 1 watched elements instead of " + this.purgatory.watched()));
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory.tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(10000L), List.of(this.test1));
        this.purgatory.tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(10000L), List.of(this.test1));
        this.purgatory.tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(10000L), List.of(this.test2));
        List cancelledOperations = this.purgatory.cancelForKey((DelayedOperationKey)this.test1);
        Assertions.assertEquals((int)2, (int)cancelledOperations.size());
        Assertions.assertEquals((int)1, (int)this.purgatory.numDelayed());
        Assertions.assertEquals((int)1, (int)this.purgatory.watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory.cancelForKey((DelayedOperationKey)this.test1);
        Assertions.assertTrue((boolean)cancelledOperations.isEmpty());
    }

    @Test
    public void testTryCompleteWithMultipleThreads() throws ExecutionException, InterruptedException {
        this.executorService = Executors.newScheduledThreadPool(20);
        int maxDelayMs = 10;
        int completionAttempts = 20;
        ArrayList<TestDelayOperation> ops = new ArrayList<TestDelayOperation>();
        for (int i = 0; i < 100; ++i) {
            TestDelayOperation op2 = new TestDelayOperation(i, completionAttempts, maxDelayMs);
            this.purgatory.tryCompleteElseWatch((DelayedOperation)op2, List.of(op2.key));
            ops.add(op2);
        }
        ArrayList futures = new ArrayList();
        for (int i = 1; i <= completionAttempts; ++i) {
            for (TestDelayOperation op3 : ops) {
                futures.add(this.scheduleTryComplete(this.executorService, op3, this.random.nextInt(maxDelayMs)));
            }
        }
        for (Future future : futures) {
            future.get();
        }
        ops.forEach(op -> Assertions.assertTrue((boolean)op.isCompleted(), (String)("Operation " + op.key.keyLabel() + " should have completed")));
    }

    private Future<?> scheduleTryComplete(ScheduledExecutorService executorService, TestDelayOperation op, long delayMs) {
        return executorService.schedule(() -> {
            if (op.completionAttemptsRemaining.decrementAndGet() == 0) {
                op.completable = true;
            }
            this.purgatory.checkAndComplete((DelayedOperationKey)op.key);
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    private static class MockKey
    implements DelayedOperationKey {
        final String key;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockKey mockKey = (MockKey)o;
            return Objects.equals(this.key, mockKey.key);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        MockKey(String key) {
            this.key = key;
        }

        public String keyLabel() {
            return this.key;
        }
    }

    private static class MockDelayedOperation
    extends DelayedOperation {
        private final Optional<Lock> responseLockOpt;
        boolean completable = false;

        MockDelayedOperation(long delayMs) {
            this(delayMs, Optional.empty());
        }

        MockDelayedOperation(long delayMs, Optional<Lock> responseLockOpt) {
            super(delayMs);
            this.responseLockOpt = responseLockOpt;
        }

        public boolean tryComplete() {
            if (this.completable) {
                return this.forceComplete();
            }
            return false;
        }

        public void onExpiration() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            this.responseLockOpt.ifPresent(lock -> {
                if (!lock.tryLock()) {
                    throw new IllegalStateException("Response callback lock could not be acquired in callback");
                }
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitExpiration() throws InterruptedException {
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                ((Object)((Object)this)).wait();
            }
        }
    }

    private class TestDelayOperation
    extends MockDelayedOperation {
        private final MockKey key;
        private final AtomicInteger completionAttemptsRemaining;
        private final int maxDelayMs;

        TestDelayOperation(int index, int completionAttempts, int maxDelayMs) {
            super(10000L, Optional.empty());
            this.key = new MockKey("key" + index);
            this.completionAttemptsRemaining = new AtomicInteger(completionAttempts);
            this.maxDelayMs = maxDelayMs;
        }

        @Override
        public boolean tryComplete() {
            boolean shouldComplete = this.completable;
            try {
                Thread.sleep(DelayedOperationTest.this.random.nextInt(this.maxDelayMs));
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            if (shouldComplete) {
                return this.forceComplete();
            }
            return false;
        }
    }
}

