/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.QuotaUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuotaUtilsTest {
    private final Time time = new MockTime();
    private final int numSamples = 10;
    private final int maxThrottleTimeMs = 500;
    private final MetricName metricName = new MetricName("test-metric", "groupA", "testA", Map.of());

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assertions.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assertions.assertTrue((this.throttleTime(observedValue, quota, 10) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.throttleTime(observedValue, quota, 11) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, 10, 500L));
        Assertions.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, 11, 500L));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, 10, 500L) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.boundedThrottleTime(observedValue, quota, 11, 500L) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assertions.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, 500L));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assertions.assertEquals((long)500L, (long)this.boundedThrottleTime(observedValue, quota, 10, 500L));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Value(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.throttleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.time.milliseconds()));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Value(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.boundedThrottleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0), (long)500L, (long)this.time.milliseconds()));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateEqualZero() {
        double refillRate = 5.0;
        double observedValue = 0.0;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime(observedValue, refillRate, 10));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketThrottleTime(observedValue, refillRate, 11));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateAboveZero() {
        double observedValue = 3.0;
        double refillRate = 5.0;
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, 10) < 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.tokenBucketThrottleTime(observedValue, refillRate, 11) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateEqualZero() {
        double refillRate = 5.0;
        double observedValue = 0.0;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 10, 500L));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 11, 500L));
    }

    @Test
    public void testTokenBucketThrottleTimeObservedRateBelowZero() {
        double refillRate = 5.0;
        double observedValue = -10.0;
        Assertions.assertEquals((long)2000L, (long)this.tokenBucketThrottleTime(observedValue, refillRate, 10));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateAboveZero() {
        double refillRate = 5.0;
        double observedValue = 3.0;
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 10, 500L));
        Assertions.assertEquals((long)0L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 11, 500L));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroBelowLimit() {
        double refillRate = 5.0;
        double observedValue = -1.0;
        Assertions.assertEquals((long)200L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 2, 500L));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeObservedRateBelowZeroAboveLimit() {
        double refillRate = 5.0;
        double observedValue = -10.0;
        Assertions.assertEquals((long)500L, (long)this.tokenBucketBoundedThrottleTime(observedValue, refillRate, 10, 500L));
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Value(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.tokenBucketThrottleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Value(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.boundedTokenBucketThrottleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0), (long)500L));
    }

    @Test
    public void testTokenBucketThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Rate(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.tokenBucketThrottleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0)));
    }

    @Test
    public void testTokenBucketBoundedThrottleTimeThrowsExceptionIfProvidedNonTokenBucketMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Rate(), new MetricConfig(), this.time);
        Assertions.assertThrows(IllegalArgumentException.class, () -> QuotaUtils.boundedTokenBucketThrottleTime((QuotaViolationException)new QuotaViolationException(testMetric, 10.0, 20.0), (long)500L));
    }

    @Test
    public void testBoundedTokenBucketThrottleTimeAboveMinThrottleTimeMs() {
        double refillRate = 5.0;
        double observedValue = -1.0;
        QuotaViolationException e = this.tokenBucketQuotaViolationException(observedValue, refillRate, 10);
        long minThrottleTimeMs = 300L;
        Assertions.assertEquals((long)minThrottleTimeMs, (long)QuotaUtils.boundedTokenBucketThrottleTime((QuotaViolationException)e, (long)minThrottleTimeMs, (long)500L));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        int sampleWindowSec = 1;
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)sampleWindowSec, TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new Rate(), metricConfig, this.time);
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils.throttleTime((QuotaViolationException)e, (long)this.time.milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils.boundedThrottleTime((QuotaViolationException)e, (long)maxThrottleTime, (long)this.time.milliseconds());
    }

    private QuotaViolationException tokenBucketQuotaViolationException(double observedValue, double quota, int numSamples) {
        int sampleWindowSec = 1;
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)sampleWindowSec, TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName, (MetricValueProvider)new TokenBucket(), metricConfig, this.time);
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long tokenBucketThrottleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException quotaViolationException = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils.tokenBucketThrottleTime((QuotaViolationException)quotaViolationException);
    }

    private long tokenBucketBoundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException quotaViolationException = this.tokenBucketQuotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils.boundedTokenBucketThrottleTime((QuotaViolationException)quotaViolationException, (long)maxThrottleTime);
    }
}

