/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.RateLimiter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RateLimiterTest {
    RateLimiter newRateLimiter() {
        MockTime time = new MockTime(100L, 200L);
        RateLimiter limiter = new RateLimiter.Builder().setMaxActionsPerWindow(3).setWindowLength(100).setTime((Time)time).build();
        return limiter;
    }

    @Test
    public void testLimitRuns() {
        RateLimiter limiter = this.newRateLimiter();
        ArrayList results = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            limiter.maybeRun(denied -> results.add(denied));
        }
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)), results);
    }

    @Test
    public void testMaybeRunInNextWindow() {
        RateLimiter limiter = this.newRateLimiter();
        for (int i = 0; i < 20; ++i) {
            limiter.maybeRun(newDenied -> Assertions.assertEquals((int)0, (Integer)newDenied));
        }
        limiter.time().sleep(200L);
        AtomicInteger denied = new AtomicInteger(0);
        limiter.maybeRun(newDenied -> denied.set((int)newDenied));
        Assertions.assertEquals((int)17, (int)denied.get());
        limiter.maybeRun(newDenied -> Assertions.assertEquals((int)0, (Integer)newDenied));
    }

    @Test
    public void testMaybeLogInNextWindow() {
        RateLimiter limiter = this.newRateLimiter();
        for (int i = 0; i < 20; ++i) {
            limiter.maybeLog(newMessage -> Assertions.assertEquals((Object)"", (Object)newMessage));
        }
        limiter.time().sleep(200L);
        AtomicReference<String> message = new AtomicReference<String>("");
        limiter.maybeLog(newMessage -> message.set((String)newMessage));
        Assertions.assertEquals((Object)" (Suppressed 17 similar log messages in the last 100 milliseconds.)", (Object)message.get());
        limiter.maybeLog(newMessage -> Assertions.assertEquals((Object)"", (Object)newMessage));
    }
}

