/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.List;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMapTest;
import org.apache.kafka.timeline.TimelineHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TimelineHashSetTest {
    @Test
    public void testEmptySet() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 1);
        Assertions.assertTrue((boolean)set.isEmpty());
        Assertions.assertEquals((int)0, (int)set.size());
        set.clear();
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testNullsForbidden() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 1);
        Assertions.assertThrows(NullPointerException.class, () -> set.add(null));
    }

    @Test
    public void testIteration() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 1);
        set.add((Object)"a");
        set.add((Object)"b");
        set.add((Object)"c");
        set.add((Object)"d");
        Assertions.assertTrue((boolean)set.retainAll(List.of("a", "b", "c")));
        Assertions.assertFalse((boolean)set.retainAll(List.of("a", "b", "c")));
        Assertions.assertFalse((boolean)set.removeAll(List.of("d")));
        registry.idempotentCreateSnapshot(2L);
        Assertions.assertTrue((boolean)set.removeAll(List.of("c")));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator(2L)).containsAll(List.of("a", "b", "c")));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator()).containsAll(List.of("a", "b")));
        Assertions.assertEquals((int)2, (int)set.size());
        Assertions.assertEquals((int)3, (int)set.size(2L));
        set.clear();
        Assertions.assertTrue((boolean)set.isEmpty());
        Assertions.assertFalse((boolean)set.isEmpty(2L));
    }

    @Test
    public void testToArray() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 1);
        set.add((Object)"z");
        Assertions.assertArrayEquals((Object[])new String[]{"z"}, (Object[])set.toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"z", null}, (Object[])set.toArray((Object[])new String[2]));
        Assertions.assertArrayEquals((Object[])new String[]{"z"}, (Object[])set.toArray((Object[])new String[0]));
    }

    @Test
    public void testSetMethods() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 1);
        Assertions.assertTrue((boolean)set.add((Object)"xyz"));
        Assertions.assertFalse((boolean)set.add((Object)"xyz"));
        Assertions.assertTrue((boolean)set.remove((Object)"xyz"));
        Assertions.assertFalse((boolean)set.remove((Object)"xyz"));
        Assertions.assertTrue((boolean)set.addAll(List.of("abc", "def", "ghi")));
        Assertions.assertFalse((boolean)set.addAll(List.of("abc", "def", "ghi")));
        Assertions.assertTrue((boolean)set.addAll(List.of("abc", "def", "ghi", "jkl")));
        Assertions.assertTrue((boolean)set.containsAll(List.of("def", "jkl")));
        Assertions.assertFalse((boolean)set.containsAll(List.of("abc", "def", "xyz")));
        Assertions.assertTrue((boolean)set.removeAll(List.of("def", "ghi", "xyz")));
        registry.idempotentCreateSnapshot(5L);
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator(5L)).containsAll(List.of("abc", "jkl")));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator()).containsAll(List.of("abc", "jkl")));
        set.removeIf(e -> e.startsWith("a"));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator()).contains("jkl"));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(set.iterator(5L)).containsAll(List.of("abc", "jkl")));
    }
}

