/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.List;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TimelineIntegerTest {
    @Test
    public void testModifyValue() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineInteger integer = new TimelineInteger(registry);
        Assertions.assertEquals((int)0, (int)integer.get());
        Assertions.assertEquals((int)0, (int)integer.get(Long.MAX_VALUE));
        integer.set(1);
        integer.set(2);
        Assertions.assertEquals((int)2, (int)integer.get());
        Assertions.assertEquals((int)2, (int)integer.get(Long.MAX_VALUE));
    }

    @Test
    public void testToStringAndEquals() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineInteger integer = new TimelineInteger(registry);
        Assertions.assertEquals((Object)"0", (Object)integer.toString());
        integer.set(1);
        TimelineInteger integer2 = new TimelineInteger(registry);
        integer2.set(1);
        Assertions.assertEquals((Object)"1", (Object)integer2.toString());
        Assertions.assertEquals((Object)integer, (Object)integer2);
    }

    @Test
    public void testSnapshot() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineInteger integer = new TimelineInteger(registry);
        registry.idempotentCreateSnapshot(2L);
        integer.set(1);
        registry.idempotentCreateSnapshot(3L);
        integer.set(2);
        integer.increment();
        integer.increment();
        integer.decrement();
        registry.idempotentCreateSnapshot(4L);
        Assertions.assertEquals((int)0, (int)integer.get(2L));
        Assertions.assertEquals((int)1, (int)integer.get(3L));
        Assertions.assertEquals((int)3, (int)integer.get(4L));
        registry.revertToSnapshot(3L);
        Assertions.assertEquals((int)1, (int)integer.get());
        registry.revertToSnapshot(2L);
        Assertions.assertEquals((int)0, (int)integer.get());
    }

    @Test
    public void testReset() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineInteger value = new TimelineInteger(registry);
        registry.idempotentCreateSnapshot(2L);
        value.set(1);
        registry.idempotentCreateSnapshot(3L);
        value.set(2);
        registry.reset();
        Assertions.assertEquals(List.of(), (Object)registry.epochsList());
        Assertions.assertEquals((int)0, (int)value.get());
    }
}

