/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.catalog.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import io.confluent.protobuf.events.catalog.v1.ConnectorSpecOrBuilder;
import io.confluent.protobuf.events.catalog.v1.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ConnectorSpec
extends GeneratedMessageV3
implements ConnectorSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CONNECTOR_NAME_FIELD_NUMBER = 1;
    private volatile Object connectorName_ = "";
    public static final int CLUSTER_GROUP_ID_FIELD_NUMBER = 2;
    private volatile Object clusterGroupId_ = "";
    public static final int METADATA_KAFKA_CLUSTER_ID_FIELD_NUMBER = 3;
    private volatile Object metadataKafkaClusterId_ = "";
    public static final int CLASS_FIELD_NUMBER = 4;
    private volatile Object class__ = "";
    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_ = 0;
    public static final int TOPICS_FIELD_NUMBER = 6;
    private LazyStringArrayList topics_ = LazyStringArrayList.emptyList();
    public static final int CONFIGS_FIELD_NUMBER = 7;
    private MapField<String, String> configs_;
    public static final int DERIVED_CONFIGS_FIELD_NUMBER = 8;
    private DerivedConfigs derivedConfigs_;
    public static final int DATA_KAFKA_CLUSTER_ID_FIELD_NUMBER = 9;
    private volatile Object dataKafkaClusterId_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final ConnectorSpec DEFAULT_INSTANCE = new ConnectorSpec();
    private static final Parser<ConnectorSpec> PARSER = new AbstractParser<ConnectorSpec>(){

        public ConnectorSpec parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ConnectorSpec.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ConnectorSpec(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ConnectorSpec() {
        this.connectorName_ = "";
        this.clusterGroupId_ = "";
        this.metadataKafkaClusterId_ = "";
        this.class__ = "";
        this.type_ = 0;
        this.topics_ = LazyStringArrayList.emptyList();
        this.dataKafkaClusterId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ConnectorSpec();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Metadata.internal_static_catalog_v1_ConnectorSpec_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 7: {
                return this.internalGetConfigs();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Metadata.internal_static_catalog_v1_ConnectorSpec_fieldAccessorTable.ensureFieldAccessorsInitialized(ConnectorSpec.class, Builder.class);
    }

    @Override
    public String getConnectorName() {
        Object ref = this.connectorName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.connectorName_ = s;
        return s;
    }

    @Override
    public ByteString getConnectorNameBytes() {
        Object ref = this.connectorName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.connectorName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClusterGroupId() {
        Object ref = this.clusterGroupId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterGroupId_ = s;
        return s;
    }

    @Override
    public ByteString getClusterGroupIdBytes() {
        Object ref = this.clusterGroupId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterGroupId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMetadataKafkaClusterId() {
        Object ref = this.metadataKafkaClusterId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.metadataKafkaClusterId_ = s;
        return s;
    }

    @Override
    public ByteString getMetadataKafkaClusterIdBytes() {
        Object ref = this.metadataKafkaClusterId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.metadataKafkaClusterId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClass_() {
        Object ref = this.class__;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.class__ = s;
        return s;
    }

    @Override
    public ByteString getClass_Bytes() {
        Object ref = this.class__;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.class__ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public ConnectorType getType() {
        ConnectorType result = ConnectorType.forNumber(this.type_);
        return result == null ? ConnectorType.UNRECOGNIZED : result;
    }

    public ProtocolStringList getTopicsList() {
        return this.topics_;
    }

    @Override
    public int getTopicsCount() {
        return this.topics_.size();
    }

    @Override
    public String getTopics(int index) {
        return this.topics_.get(index);
    }

    @Override
    public ByteString getTopicsBytes(int index) {
        return this.topics_.getByteString(index);
    }

    private MapField<String, String> internalGetConfigs() {
        if (this.configs_ == null) {
            return MapField.emptyMapField(ConfigsDefaultEntryHolder.defaultEntry);
        }
        return this.configs_;
    }

    @Override
    public int getConfigsCount() {
        return this.internalGetConfigs().getMap().size();
    }

    @Override
    public boolean containsConfigs(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetConfigs().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getConfigs() {
        return this.getConfigsMap();
    }

    @Override
    public Map<String, String> getConfigsMap() {
        return this.internalGetConfigs().getMap();
    }

    @Override
    public String getConfigsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetConfigs().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getConfigsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetConfigs().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasDerivedConfigs() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DerivedConfigs getDerivedConfigs() {
        return this.derivedConfigs_ == null ? DerivedConfigs.getDefaultInstance() : this.derivedConfigs_;
    }

    @Override
    public DerivedConfigsOrBuilder getDerivedConfigsOrBuilder() {
        return this.derivedConfigs_ == null ? DerivedConfigs.getDefaultInstance() : this.derivedConfigs_;
    }

    @Override
    public String getDataKafkaClusterId() {
        Object ref = this.dataKafkaClusterId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dataKafkaClusterId_ = s;
        return s;
    }

    @Override
    public ByteString getDataKafkaClusterIdBytes() {
        Object ref = this.dataKafkaClusterId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dataKafkaClusterId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.connectorName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.connectorName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterGroupId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.clusterGroupId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.metadataKafkaClusterId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.metadataKafkaClusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.class__)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.class__);
        }
        if (this.type_ != ConnectorType.SOURCE.getNumber()) {
            output.writeEnum(5, this.type_);
        }
        for (int i = 0; i < this.topics_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.topics_.getRaw(i));
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetConfigs(), ConfigsDefaultEntryHolder.defaultEntry, (int)7);
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(8, (MessageLite)this.getDerivedConfigs());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dataKafkaClusterId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.dataKafkaClusterId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.connectorName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.connectorName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterGroupId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.clusterGroupId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.metadataKafkaClusterId_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.metadataKafkaClusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.class__)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.class__);
        }
        if (this.type_ != ConnectorType.SOURCE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.type_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.topics_.size(); ++i) {
            dataSize += ConnectorSpec.computeStringSizeNoTag((Object)this.topics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getTopicsList().size();
        for (Map.Entry entry : this.internalGetConfigs().getMap().entrySet()) {
            MapEntry configs__ = ConfigsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)configs__);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getDerivedConfigs());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dataKafkaClusterId_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.dataKafkaClusterId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectorSpec)) {
            return super.equals(obj);
        }
        ConnectorSpec other = (ConnectorSpec)obj;
        if (!this.getConnectorName().equals(other.getConnectorName())) {
            return false;
        }
        if (!this.getClusterGroupId().equals(other.getClusterGroupId())) {
            return false;
        }
        if (!this.getMetadataKafkaClusterId().equals(other.getMetadataKafkaClusterId())) {
            return false;
        }
        if (!this.getClass_().equals(other.getClass_())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (!this.getTopicsList().equals(other.getTopicsList())) {
            return false;
        }
        if (!this.internalGetConfigs().equals(other.internalGetConfigs())) {
            return false;
        }
        if (this.hasDerivedConfigs() != other.hasDerivedConfigs()) {
            return false;
        }
        if (this.hasDerivedConfigs() && !this.getDerivedConfigs().equals(other.getDerivedConfigs())) {
            return false;
        }
        if (!this.getDataKafkaClusterId().equals(other.getDataKafkaClusterId())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ConnectorSpec.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getConnectorName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getClusterGroupId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getMetadataKafkaClusterId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getClass_().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.type_;
        if (this.getTopicsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getTopicsList().hashCode();
        }
        if (!this.internalGetConfigs().getMap().isEmpty()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.internalGetConfigs().hashCode();
        }
        if (this.hasDerivedConfigs()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getDerivedConfigs().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getDataKafkaClusterId().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ConnectorSpec parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data);
    }

    public static ConnectorSpec parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectorSpec parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data);
    }

    public static ConnectorSpec parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectorSpec parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data);
    }

    public static ConnectorSpec parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectorSpec)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectorSpec parseFrom(InputStream input) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ConnectorSpec parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConnectorSpec parseDelimitedFrom(InputStream input) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ConnectorSpec parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConnectorSpec parseFrom(CodedInputStream input) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ConnectorSpec parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectorSpec)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ConnectorSpec.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ConnectorSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ConnectorSpec getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ConnectorSpec> parser() {
        return PARSER;
    }

    public Parser<ConnectorSpec> getParserForType() {
        return PARSER;
    }

    public ConnectorSpec getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ConnectorSpecOrBuilder {
        private int bitField0_;
        private Object connectorName_ = "";
        private Object clusterGroupId_ = "";
        private Object metadataKafkaClusterId_ = "";
        private Object class__ = "";
        private int type_ = 0;
        private LazyStringArrayList topics_ = LazyStringArrayList.emptyList();
        private MapField<String, String> configs_;
        private DerivedConfigs derivedConfigs_;
        private SingleFieldBuilderV3<DerivedConfigs, DerivedConfigs.Builder, DerivedConfigsOrBuilder> derivedConfigsBuilder_;
        private Object dataKafkaClusterId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return Metadata.internal_static_catalog_v1_ConnectorSpec_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetConfigs();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMutableConfigs();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Metadata.internal_static_catalog_v1_ConnectorSpec_fieldAccessorTable.ensureFieldAccessorsInitialized(ConnectorSpec.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getDerivedConfigsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.connectorName_ = "";
            this.clusterGroupId_ = "";
            this.metadataKafkaClusterId_ = "";
            this.class__ = "";
            this.type_ = 0;
            this.topics_ = LazyStringArrayList.emptyList();
            this.internalGetMutableConfigs().clear();
            this.derivedConfigs_ = null;
            if (this.derivedConfigsBuilder_ != null) {
                this.derivedConfigsBuilder_.dispose();
                this.derivedConfigsBuilder_ = null;
            }
            this.dataKafkaClusterId_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Metadata.internal_static_catalog_v1_ConnectorSpec_descriptor;
        }

        public ConnectorSpec getDefaultInstanceForType() {
            return ConnectorSpec.getDefaultInstance();
        }

        public ConnectorSpec build() {
            ConnectorSpec result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ConnectorSpec buildPartial() {
            ConnectorSpec result = new ConnectorSpec(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(ConnectorSpec result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.connectorName_ = this.connectorName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.clusterGroupId_ = this.clusterGroupId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.metadataKafkaClusterId_ = this.metadataKafkaClusterId_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.class__ = this.class__;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                this.topics_.makeImmutable();
                result.topics_ = this.topics_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.configs_ = this.internalGetConfigs();
                result.configs_.makeImmutable();
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x80) != 0) {
                result.derivedConfigs_ = this.derivedConfigsBuilder_ == null ? this.derivedConfigs_ : (DerivedConfigs)this.derivedConfigsBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.dataKafkaClusterId_ = this.dataKafkaClusterId_;
            }
            ConnectorSpec connectorSpec = result;
            connectorSpec.bitField0_ = connectorSpec.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ConnectorSpec) {
                return this.mergeFrom((ConnectorSpec)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ConnectorSpec other) {
            if (other == ConnectorSpec.getDefaultInstance()) {
                return this;
            }
            if (!other.getConnectorName().isEmpty()) {
                this.connectorName_ = other.connectorName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getClusterGroupId().isEmpty()) {
                this.clusterGroupId_ = other.clusterGroupId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getMetadataKafkaClusterId().isEmpty()) {
                this.metadataKafkaClusterId_ = other.metadataKafkaClusterId_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getClass_().isEmpty()) {
                this.class__ = other.class__;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (!other.topics_.isEmpty()) {
                if (this.topics_.isEmpty()) {
                    this.topics_ = other.topics_;
                    this.bitField0_ |= 0x20;
                } else {
                    this.ensureTopicsIsMutable();
                    this.topics_.addAll((Collection)other.topics_);
                }
                this.onChanged();
            }
            this.internalGetMutableConfigs().mergeFrom(other.internalGetConfigs());
            this.bitField0_ |= 0x40;
            if (other.hasDerivedConfigs()) {
                this.mergeDerivedConfigs(other.getDerivedConfigs());
            }
            if (!other.getDataKafkaClusterId().isEmpty()) {
                this.dataKafkaClusterId_ = other.dataKafkaClusterId_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.connectorName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 18: {
                            this.clusterGroupId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 26: {
                            this.metadataKafkaClusterId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 34: {
                            this.class__ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            String s = input.readStringRequireUtf8();
                            this.ensureTopicsIsMutable();
                            this.topics_.add((Object)s);
                            continue block17;
                        }
                        case 58: {
                            MapEntry configs__ = (MapEntry)input.readMessage(ConfigsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableConfigs().getMutableMap().put(configs__.getKey(), configs__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getDerivedConfigsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 74: {
                            this.dataKafkaClusterId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getConnectorName() {
            Object ref = this.connectorName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.connectorName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getConnectorNameBytes() {
            Object ref = this.connectorName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.connectorName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setConnectorName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.connectorName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearConnectorName() {
            this.connectorName_ = ConnectorSpec.getDefaultInstance().getConnectorName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setConnectorNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.connectorName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getClusterGroupId() {
            Object ref = this.clusterGroupId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterGroupId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterGroupIdBytes() {
            Object ref = this.clusterGroupId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterGroupId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterGroupId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterGroupId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearClusterGroupId() {
            this.clusterGroupId_ = ConnectorSpec.getDefaultInstance().getClusterGroupId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setClusterGroupIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.clusterGroupId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getMetadataKafkaClusterId() {
            Object ref = this.metadataKafkaClusterId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.metadataKafkaClusterId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMetadataKafkaClusterIdBytes() {
            Object ref = this.metadataKafkaClusterId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.metadataKafkaClusterId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMetadataKafkaClusterId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.metadataKafkaClusterId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearMetadataKafkaClusterId() {
            this.metadataKafkaClusterId_ = ConnectorSpec.getDefaultInstance().getMetadataKafkaClusterId();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setMetadataKafkaClusterIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.metadataKafkaClusterId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getClass_() {
            Object ref = this.class__;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.class__ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClass_Bytes() {
            Object ref = this.class__;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.class__ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClass_(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.class__ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearClass_() {
            this.class__ = ConnectorSpec.getDefaultInstance().getClass_();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setClass_Bytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.class__ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ConnectorType getType() {
            ConnectorType result = ConnectorType.forNumber(this.type_);
            return result == null ? ConnectorType.UNRECOGNIZED : result;
        }

        public Builder setType(ConnectorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTopicsIsMutable() {
            if (!this.topics_.isModifiable()) {
                this.topics_ = new LazyStringArrayList((LazyStringList)this.topics_);
            }
            this.bitField0_ |= 0x20;
        }

        public ProtocolStringList getTopicsList() {
            this.topics_.makeImmutable();
            return this.topics_;
        }

        @Override
        public int getTopicsCount() {
            return this.topics_.size();
        }

        @Override
        public String getTopics(int index) {
            return this.topics_.get(index);
        }

        @Override
        public ByteString getTopicsBytes(int index) {
            return this.topics_.getByteString(index);
        }

        public Builder setTopics(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTopicsIsMutable();
            this.topics_.set(index, value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addTopics(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTopicsIsMutable();
            this.topics_.add((Object)value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addAllTopics(Iterable<String> values) {
            this.ensureTopicsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.topics_);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearTopics() {
            this.topics_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder addTopicsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.ensureTopicsIsMutable();
            this.topics_.add(value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetConfigs() {
            if (this.configs_ == null) {
                return MapField.emptyMapField(ConfigsDefaultEntryHolder.defaultEntry);
            }
            return this.configs_;
        }

        private MapField<String, String> internalGetMutableConfigs() {
            if (this.configs_ == null) {
                this.configs_ = MapField.newMapField(ConfigsDefaultEntryHolder.defaultEntry);
            }
            if (!this.configs_.isMutable()) {
                this.configs_ = this.configs_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.configs_;
        }

        @Override
        public int getConfigsCount() {
            return this.internalGetConfigs().getMap().size();
        }

        @Override
        public boolean containsConfigs(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetConfigs().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getConfigs() {
            return this.getConfigsMap();
        }

        @Override
        public Map<String, String> getConfigsMap() {
            return this.internalGetConfigs().getMap();
        }

        @Override
        public String getConfigsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetConfigs().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getConfigsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetConfigs().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearConfigs() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableConfigs().getMutableMap().clear();
            return this;
        }

        public Builder removeConfigs(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableConfigs().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableConfigs() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableConfigs().getMutableMap();
        }

        public Builder putConfigs(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableConfigs().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllConfigs(Map<String, String> values) {
            this.internalGetMutableConfigs().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        @Override
        public boolean hasDerivedConfigs() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public DerivedConfigs getDerivedConfigs() {
            if (this.derivedConfigsBuilder_ == null) {
                return this.derivedConfigs_ == null ? DerivedConfigs.getDefaultInstance() : this.derivedConfigs_;
            }
            return (DerivedConfigs)this.derivedConfigsBuilder_.getMessage();
        }

        public Builder setDerivedConfigs(DerivedConfigs value) {
            if (this.derivedConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.derivedConfigs_ = value;
            } else {
                this.derivedConfigsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setDerivedConfigs(DerivedConfigs.Builder builderForValue) {
            if (this.derivedConfigsBuilder_ == null) {
                this.derivedConfigs_ = builderForValue.build();
            } else {
                this.derivedConfigsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeDerivedConfigs(DerivedConfigs value) {
            if (this.derivedConfigsBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.derivedConfigs_ != null && this.derivedConfigs_ != DerivedConfigs.getDefaultInstance()) {
                    this.getDerivedConfigsBuilder().mergeFrom(value);
                } else {
                    this.derivedConfigs_ = value;
                }
            } else {
                this.derivedConfigsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.derivedConfigs_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDerivedConfigs() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.derivedConfigs_ = null;
            if (this.derivedConfigsBuilder_ != null) {
                this.derivedConfigsBuilder_.dispose();
                this.derivedConfigsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DerivedConfigs.Builder getDerivedConfigsBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (DerivedConfigs.Builder)this.getDerivedConfigsFieldBuilder().getBuilder();
        }

        @Override
        public DerivedConfigsOrBuilder getDerivedConfigsOrBuilder() {
            if (this.derivedConfigsBuilder_ != null) {
                return (DerivedConfigsOrBuilder)this.derivedConfigsBuilder_.getMessageOrBuilder();
            }
            return this.derivedConfigs_ == null ? DerivedConfigs.getDefaultInstance() : this.derivedConfigs_;
        }

        private SingleFieldBuilderV3<DerivedConfigs, DerivedConfigs.Builder, DerivedConfigsOrBuilder> getDerivedConfigsFieldBuilder() {
            if (this.derivedConfigsBuilder_ == null) {
                this.derivedConfigsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDerivedConfigs(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.derivedConfigs_ = null;
            }
            return this.derivedConfigsBuilder_;
        }

        @Override
        public String getDataKafkaClusterId() {
            Object ref = this.dataKafkaClusterId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dataKafkaClusterId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDataKafkaClusterIdBytes() {
            Object ref = this.dataKafkaClusterId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dataKafkaClusterId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDataKafkaClusterId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dataKafkaClusterId_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearDataKafkaClusterId() {
            this.dataKafkaClusterId_ = ConnectorSpec.getDefaultInstance().getDataKafkaClusterId();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setDataKafkaClusterIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectorSpec.checkByteStringIsUtf8((ByteString)value);
            this.dataKafkaClusterId_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class ConfigsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)Metadata.internal_static_catalog_v1_ConnectorSpec_ConfigsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private ConfigsDefaultEntryHolder() {
        }
    }

    public static final class DerivedConfigs
    extends GeneratedMessageV3
    implements DerivedConfigsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TASKS_MAX_FIELD_NUMBER = 1;
        private int tasksMax_ = 0;
        public static final int VALUE_CONVERTER_FIELD_NUMBER = 2;
        private volatile Object valueConverter_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final DerivedConfigs DEFAULT_INSTANCE = new DerivedConfigs();
        private static final Parser<DerivedConfigs> PARSER = new AbstractParser<DerivedConfigs>(){

            public DerivedConfigs parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = DerivedConfigs.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private DerivedConfigs(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private DerivedConfigs() {
            this.valueConverter_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new DerivedConfigs();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return Metadata.internal_static_catalog_v1_ConnectorSpec_DerivedConfigs_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Metadata.internal_static_catalog_v1_ConnectorSpec_DerivedConfigs_fieldAccessorTable.ensureFieldAccessorsInitialized(DerivedConfigs.class, Builder.class);
        }

        @Override
        public int getTasksMax() {
            return this.tasksMax_;
        }

        @Override
        public String getValueConverter() {
            Object ref = this.valueConverter_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.valueConverter_ = s;
            return s;
        }

        @Override
        public ByteString getValueConverterBytes() {
            Object ref = this.valueConverter_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.valueConverter_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.tasksMax_ != 0) {
                output.writeInt32(1, this.tasksMax_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.valueConverter_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.valueConverter_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.tasksMax_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)1, (int)this.tasksMax_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.valueConverter_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.valueConverter_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DerivedConfigs)) {
                return super.equals(obj);
            }
            DerivedConfigs other = (DerivedConfigs)obj;
            if (this.getTasksMax() != other.getTasksMax()) {
                return false;
            }
            if (!this.getValueConverter().equals(other.getValueConverter())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + DerivedConfigs.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTasksMax();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getValueConverter().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static DerivedConfigs parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data);
        }

        public static DerivedConfigs parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DerivedConfigs parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data);
        }

        public static DerivedConfigs parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DerivedConfigs parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data);
        }

        public static DerivedConfigs parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DerivedConfigs)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DerivedConfigs parseFrom(InputStream input) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static DerivedConfigs parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DerivedConfigs parseDelimitedFrom(InputStream input) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static DerivedConfigs parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DerivedConfigs parseFrom(CodedInputStream input) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static DerivedConfigs parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DerivedConfigs)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return DerivedConfigs.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(DerivedConfigs prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static DerivedConfigs getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<DerivedConfigs> parser() {
            return PARSER;
        }

        public Parser<DerivedConfigs> getParserForType() {
            return PARSER;
        }

        public DerivedConfigs getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements DerivedConfigsOrBuilder {
            private int bitField0_;
            private int tasksMax_;
            private Object valueConverter_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return Metadata.internal_static_catalog_v1_ConnectorSpec_DerivedConfigs_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return Metadata.internal_static_catalog_v1_ConnectorSpec_DerivedConfigs_fieldAccessorTable.ensureFieldAccessorsInitialized(DerivedConfigs.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.tasksMax_ = 0;
                this.valueConverter_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return Metadata.internal_static_catalog_v1_ConnectorSpec_DerivedConfigs_descriptor;
            }

            public DerivedConfigs getDefaultInstanceForType() {
                return DerivedConfigs.getDefaultInstance();
            }

            public DerivedConfigs build() {
                DerivedConfigs result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public DerivedConfigs buildPartial() {
                DerivedConfigs result = new DerivedConfigs(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(DerivedConfigs result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.tasksMax_ = this.tasksMax_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.valueConverter_ = this.valueConverter_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof DerivedConfigs) {
                    return this.mergeFrom((DerivedConfigs)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(DerivedConfigs other) {
                if (other == DerivedConfigs.getDefaultInstance()) {
                    return this;
                }
                if (other.getTasksMax() != 0) {
                    this.setTasksMax(other.getTasksMax());
                }
                if (!other.getValueConverter().isEmpty()) {
                    this.valueConverter_ = other.valueConverter_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.tasksMax_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                this.valueConverter_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getTasksMax() {
                return this.tasksMax_;
            }

            public Builder setTasksMax(int value) {
                this.tasksMax_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearTasksMax() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.tasksMax_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public String getValueConverter() {
                Object ref = this.valueConverter_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.valueConverter_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getValueConverterBytes() {
                Object ref = this.valueConverter_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.valueConverter_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setValueConverter(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.valueConverter_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearValueConverter() {
                this.valueConverter_ = DerivedConfigs.getDefaultInstance().getValueConverter();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setValueConverterBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                DerivedConfigs.checkByteStringIsUtf8((ByteString)value);
                this.valueConverter_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface DerivedConfigsOrBuilder
    extends MessageOrBuilder {
        public int getTasksMax();

        public String getValueConverter();

        public ByteString getValueConverterBytes();
    }

    public static enum ConnectorType implements ProtocolMessageEnum
    {
        SOURCE(0),
        SINK(1),
        UNRECOGNIZED(-1);

        public static final int SOURCE_VALUE = 0;
        public static final int SINK_VALUE = 1;
        private static final Internal.EnumLiteMap<ConnectorType> internalValueMap;
        private static final ConnectorType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ConnectorType valueOf(int value) {
            return ConnectorType.forNumber(value);
        }

        public static ConnectorType forNumber(int value) {
            switch (value) {
                case 0: {
                    return SOURCE;
                }
                case 1: {
                    return SINK;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ConnectorType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ConnectorType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ConnectorType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ConnectorSpec.getDescriptor().getEnumTypes().get(0);
        }

        public static ConnectorType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ConnectorType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ConnectorType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ConnectorType>(){

                public ConnectorType findValueByNumber(int number) {
                    return ConnectorType.forNumber(number);
                }
            };
            VALUES = ConnectorType.values();
        }
    }
}

