/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.catalog.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.confluent.protobuf.events.catalog.v1.Metadata;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadataOrBuilder;
import io.confluent.protobuf.events.catalog.v1.TopicMetadataOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public final class TopicMetadata
extends GeneratedMessageV3
implements TopicMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int TOPIC_ID_FIELD_NUMBER = 1;
    private volatile Object topicId_ = "";
    public static final int TOPIC_NAME_FIELD_NUMBER = 2;
    private volatile Object topicName_ = "";
    public static final int CREATE_TIME_FIELD_NUMBER = 3;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 4;
    private Timestamp updateTime_;
    public static final int RETENTION_MS_FIELD_NUMBER = 5;
    private long retentionMs_ = 0L;
    public static final int RETENTION_BYTES_FIELD_NUMBER = 6;
    private long retentionBytes_ = 0L;
    public static final int REPLICATION_FACTOR_FIELD_NUMBER = 7;
    private int replicationFactor_ = 0;
    public static final int PARTITIONS_COUNT_FIELD_NUMBER = 8;
    private int partitionsCount_ = 0;
    public static final int CLEANUP_POLICY_FIELD_NUMBER = 9;
    private int cleanupPolicy_ = 0;
    public static final int KEY_SCHEMA_VALIDATION_FIELD_NUMBER = 10;
    private boolean keySchemaValidation_ = false;
    public static final int VALUE_SCHEMA_VALIDATION_FIELD_NUMBER = 11;
    private boolean valueSchemaValidation_ = false;
    public static final int OWNER_FIELD_NUMBER = 12;
    private volatile Object owner_ = "";
    public static final int MIRROR_TOPIC_METADATA_FIELD_NUMBER = 13;
    private MirrorTopicMetadata mirrorTopicMetadata_;
    public static final int COMPRESSION_TYPE_FIELD_NUMBER = 14;
    private int compressionType_ = 0;
    public static final int FILE_DELETE_DELAY_MS_FIELD_NUMBER = 15;
    private long fileDeleteDelayMs_ = 0L;
    public static final int FLUSH_MESSAGES_FIELD_NUMBER = 16;
    private long flushMessages_ = 0L;
    public static final int FLUSH_MS_FIELD_NUMBER = 17;
    private long flushMs_ = 0L;
    public static final int FOLLOWER_REPLICATION_THROTTLED_REPLICAS_FIELD_NUMBER = 18;
    private LazyStringArrayList followerReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
    public static final int LEADER_REPLICATION_THROTTLED_REPLICAS_FIELD_NUMBER = 19;
    private LazyStringArrayList leaderReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
    public static final int INDEX_INTERVAL_BYTES_FIELD_NUMBER = 20;
    private int indexIntervalBytes_ = 0;
    public static final int MAX_COMPACTION_LAG_MS_FIELD_NUMBER = 21;
    private long maxCompactionLagMs_ = 0L;
    public static final int MAX_MESSAGE_BYTES_FIELD_NUMBER = 22;
    private int maxMessageBytes_ = 0;
    public static final int MESSAGE_DOWNCONVERSION_ENABLE_FIELD_NUMBER = 23;
    private boolean messageDownconversionEnable_ = false;
    public static final int MESSAGE_FORMAT_VERSION_FIELD_NUMBER = 24;
    private volatile Object messageFormatVersion_ = "";
    public static final int MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_FIELD_NUMBER = 25;
    private long messageTimestampDifferenceMaxMs_ = 0L;
    public static final int MESSAGE_TIMESTAMP_TYPE_FIELD_NUMBER = 26;
    private volatile Object messageTimestampType_ = "";
    public static final int MIN_CLEANABLE_DIRTY_RATIO_FIELD_NUMBER = 27;
    private double minCleanableDirtyRatio_ = 0.0;
    public static final int MIN_COMPACTION_LAG_MS_FIELD_NUMBER = 28;
    private long minCompactionLagMs_ = 0L;
    public static final int MIN_INSYNC_REPLICAS_FIELD_NUMBER = 29;
    private int minInsyncReplicas_ = 0;
    public static final int PREALLOCATE_FIELD_NUMBER = 30;
    private boolean preallocate_ = false;
    public static final int SEGMENT_BYTES_FIELD_NUMBER = 31;
    private int segmentBytes_ = 0;
    public static final int SEGMENT_INDEX_BYTES_FIELD_NUMBER = 32;
    private int segmentIndexBytes_ = 0;
    public static final int SEGMENT_JITTER_MS_FIELD_NUMBER = 33;
    private long segmentJitterMs_ = 0L;
    public static final int SEGMENT_MS_FIELD_NUMBER = 34;
    private long segmentMs_ = 0L;
    public static final int UNCLEAN_LEADER_ELECTION_ENABLE_FIELD_NUMBER = 35;
    private boolean uncleanLeaderElectionEnable_ = false;
    public static final int DELETE_RETENTION_MS_FIELD_NUMBER = 36;
    private long deleteRetentionMs_ = 0L;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TopicMetadata DEFAULT_INSTANCE = new TopicMetadata();
    private static final Parser<TopicMetadata> PARSER = new AbstractParser<TopicMetadata>(){

        public TopicMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TopicMetadata.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TopicMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TopicMetadata() {
        this.topicId_ = "";
        this.topicName_ = "";
        this.cleanupPolicy_ = 0;
        this.owner_ = "";
        this.compressionType_ = 0;
        this.followerReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
        this.leaderReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
        this.messageFormatVersion_ = "";
        this.messageTimestampType_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TopicMetadata();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Metadata.internal_static_catalog_v1_TopicMetadata_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Metadata.internal_static_catalog_v1_TopicMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(TopicMetadata.class, Builder.class);
    }

    @Override
    public String getTopicId() {
        Object ref = this.topicId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.topicId_ = s;
        return s;
    }

    @Override
    public ByteString getTopicIdBytes() {
        Object ref = this.topicId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.topicId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getTopicName() {
        Object ref = this.topicName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.topicName_ = s;
        return s;
    }

    @Override
    public ByteString getTopicNameBytes() {
        Object ref = this.topicName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.topicName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public long getRetentionMs() {
        return this.retentionMs_;
    }

    @Override
    public long getRetentionBytes() {
        return this.retentionBytes_;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor_;
    }

    @Override
    public int getPartitionsCount() {
        return this.partitionsCount_;
    }

    @Override
    public int getCleanupPolicyValue() {
        return this.cleanupPolicy_;
    }

    @Override
    public CleanupPolicy getCleanupPolicy() {
        CleanupPolicy result = CleanupPolicy.forNumber(this.cleanupPolicy_);
        return result == null ? CleanupPolicy.UNRECOGNIZED : result;
    }

    @Override
    public boolean getKeySchemaValidation() {
        return this.keySchemaValidation_;
    }

    @Override
    public boolean getValueSchemaValidation() {
        return this.valueSchemaValidation_;
    }

    @Override
    public String getOwner() {
        Object ref = this.owner_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.owner_ = s;
        return s;
    }

    @Override
    public ByteString getOwnerBytes() {
        Object ref = this.owner_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.owner_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMirrorTopicMetadata() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public MirrorTopicMetadata getMirrorTopicMetadata() {
        return this.mirrorTopicMetadata_ == null ? MirrorTopicMetadata.getDefaultInstance() : this.mirrorTopicMetadata_;
    }

    @Override
    public MirrorTopicMetadataOrBuilder getMirrorTopicMetadataOrBuilder() {
        return this.mirrorTopicMetadata_ == null ? MirrorTopicMetadata.getDefaultInstance() : this.mirrorTopicMetadata_;
    }

    @Override
    public int getCompressionTypeValue() {
        return this.compressionType_;
    }

    @Override
    public CompressionType getCompressionType() {
        CompressionType result = CompressionType.forNumber(this.compressionType_);
        return result == null ? CompressionType.UNRECOGNIZED : result;
    }

    @Override
    public long getFileDeleteDelayMs() {
        return this.fileDeleteDelayMs_;
    }

    @Override
    public long getFlushMessages() {
        return this.flushMessages_;
    }

    @Override
    public long getFlushMs() {
        return this.flushMs_;
    }

    public ProtocolStringList getFollowerReplicationThrottledReplicasList() {
        return this.followerReplicationThrottledReplicas_;
    }

    @Override
    public int getFollowerReplicationThrottledReplicasCount() {
        return this.followerReplicationThrottledReplicas_.size();
    }

    @Override
    public String getFollowerReplicationThrottledReplicas(int index) {
        return this.followerReplicationThrottledReplicas_.get(index);
    }

    @Override
    public ByteString getFollowerReplicationThrottledReplicasBytes(int index) {
        return this.followerReplicationThrottledReplicas_.getByteString(index);
    }

    public ProtocolStringList getLeaderReplicationThrottledReplicasList() {
        return this.leaderReplicationThrottledReplicas_;
    }

    @Override
    public int getLeaderReplicationThrottledReplicasCount() {
        return this.leaderReplicationThrottledReplicas_.size();
    }

    @Override
    public String getLeaderReplicationThrottledReplicas(int index) {
        return this.leaderReplicationThrottledReplicas_.get(index);
    }

    @Override
    public ByteString getLeaderReplicationThrottledReplicasBytes(int index) {
        return this.leaderReplicationThrottledReplicas_.getByteString(index);
    }

    @Override
    public int getIndexIntervalBytes() {
        return this.indexIntervalBytes_;
    }

    @Override
    public long getMaxCompactionLagMs() {
        return this.maxCompactionLagMs_;
    }

    @Override
    public int getMaxMessageBytes() {
        return this.maxMessageBytes_;
    }

    @Override
    public boolean getMessageDownconversionEnable() {
        return this.messageDownconversionEnable_;
    }

    @Override
    public String getMessageFormatVersion() {
        Object ref = this.messageFormatVersion_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.messageFormatVersion_ = s;
        return s;
    }

    @Override
    public ByteString getMessageFormatVersionBytes() {
        Object ref = this.messageFormatVersion_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.messageFormatVersion_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getMessageTimestampDifferenceMaxMs() {
        return this.messageTimestampDifferenceMaxMs_;
    }

    @Override
    public String getMessageTimestampType() {
        Object ref = this.messageTimestampType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.messageTimestampType_ = s;
        return s;
    }

    @Override
    public ByteString getMessageTimestampTypeBytes() {
        Object ref = this.messageTimestampType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.messageTimestampType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public double getMinCleanableDirtyRatio() {
        return this.minCleanableDirtyRatio_;
    }

    @Override
    public long getMinCompactionLagMs() {
        return this.minCompactionLagMs_;
    }

    @Override
    public int getMinInsyncReplicas() {
        return this.minInsyncReplicas_;
    }

    @Override
    public boolean getPreallocate() {
        return this.preallocate_;
    }

    @Override
    public int getSegmentBytes() {
        return this.segmentBytes_;
    }

    @Override
    public int getSegmentIndexBytes() {
        return this.segmentIndexBytes_;
    }

    @Override
    public long getSegmentJitterMs() {
        return this.segmentJitterMs_;
    }

    @Override
    public long getSegmentMs() {
        return this.segmentMs_;
    }

    @Override
    public boolean getUncleanLeaderElectionEnable() {
        return this.uncleanLeaderElectionEnable_;
    }

    @Override
    public long getDeleteRetentionMs() {
        return this.deleteRetentionMs_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.topicId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.topicId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.topicName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.topicName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(4, (MessageLite)this.getUpdateTime());
        }
        if (this.retentionMs_ != 0L) {
            output.writeInt64(5, this.retentionMs_);
        }
        if (this.retentionBytes_ != 0L) {
            output.writeSInt64(6, this.retentionBytes_);
        }
        if (this.replicationFactor_ != 0) {
            output.writeInt32(7, this.replicationFactor_);
        }
        if (this.partitionsCount_ != 0) {
            output.writeInt32(8, this.partitionsCount_);
        }
        if (this.cleanupPolicy_ != CleanupPolicy.UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.cleanupPolicy_);
        }
        if (this.keySchemaValidation_) {
            output.writeBool(10, this.keySchemaValidation_);
        }
        if (this.valueSchemaValidation_) {
            output.writeBool(11, this.valueSchemaValidation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.owner_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.owner_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(13, (MessageLite)this.getMirrorTopicMetadata());
        }
        if (this.compressionType_ != CompressionType.COMPRESSION_UNSPECIFIED.getNumber()) {
            output.writeEnum(14, this.compressionType_);
        }
        if (this.fileDeleteDelayMs_ != 0L) {
            output.writeInt64(15, this.fileDeleteDelayMs_);
        }
        if (this.flushMessages_ != 0L) {
            output.writeInt64(16, this.flushMessages_);
        }
        if (this.flushMs_ != 0L) {
            output.writeInt64(17, this.flushMs_);
        }
        for (i = 0; i < this.followerReplicationThrottledReplicas_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.followerReplicationThrottledReplicas_.getRaw(i));
        }
        for (i = 0; i < this.leaderReplicationThrottledReplicas_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.leaderReplicationThrottledReplicas_.getRaw(i));
        }
        if (this.indexIntervalBytes_ != 0) {
            output.writeInt32(20, this.indexIntervalBytes_);
        }
        if (this.maxCompactionLagMs_ != 0L) {
            output.writeInt64(21, this.maxCompactionLagMs_);
        }
        if (this.maxMessageBytes_ != 0) {
            output.writeInt32(22, this.maxMessageBytes_);
        }
        if (this.messageDownconversionEnable_) {
            output.writeBool(23, this.messageDownconversionEnable_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.messageFormatVersion_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)24, (Object)this.messageFormatVersion_);
        }
        if (this.messageTimestampDifferenceMaxMs_ != 0L) {
            output.writeInt64(25, this.messageTimestampDifferenceMaxMs_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.messageTimestampType_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)26, (Object)this.messageTimestampType_);
        }
        if (Double.doubleToRawLongBits(this.minCleanableDirtyRatio_) != 0L) {
            output.writeDouble(27, this.minCleanableDirtyRatio_);
        }
        if (this.minCompactionLagMs_ != 0L) {
            output.writeInt64(28, this.minCompactionLagMs_);
        }
        if (this.minInsyncReplicas_ != 0) {
            output.writeInt32(29, this.minInsyncReplicas_);
        }
        if (this.preallocate_) {
            output.writeBool(30, this.preallocate_);
        }
        if (this.segmentBytes_ != 0) {
            output.writeInt32(31, this.segmentBytes_);
        }
        if (this.segmentIndexBytes_ != 0) {
            output.writeInt32(32, this.segmentIndexBytes_);
        }
        if (this.segmentJitterMs_ != 0L) {
            output.writeInt64(33, this.segmentJitterMs_);
        }
        if (this.segmentMs_ != 0L) {
            output.writeInt64(34, this.segmentMs_);
        }
        if (this.uncleanLeaderElectionEnable_) {
            output.writeBool(35, this.uncleanLeaderElectionEnable_);
        }
        if (this.deleteRetentionMs_ != 0L) {
            output.writeInt64(36, this.deleteRetentionMs_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.topicId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.topicId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.topicName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.topicName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getUpdateTime());
        }
        if (this.retentionMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)5, (long)this.retentionMs_);
        }
        if (this.retentionBytes_ != 0L) {
            size += CodedOutputStream.computeSInt64Size((int)6, (long)this.retentionBytes_);
        }
        if (this.replicationFactor_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.replicationFactor_);
        }
        if (this.partitionsCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.partitionsCount_);
        }
        if (this.cleanupPolicy_ != CleanupPolicy.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.cleanupPolicy_);
        }
        if (this.keySchemaValidation_) {
            size += CodedOutputStream.computeBoolSize((int)10, (boolean)this.keySchemaValidation_);
        }
        if (this.valueSchemaValidation_) {
            size += CodedOutputStream.computeBoolSize((int)11, (boolean)this.valueSchemaValidation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.owner_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.owner_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getMirrorTopicMetadata());
        }
        if (this.compressionType_ != CompressionType.COMPRESSION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)14, (int)this.compressionType_);
        }
        if (this.fileDeleteDelayMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)15, (long)this.fileDeleteDelayMs_);
        }
        if (this.flushMessages_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)16, (long)this.flushMessages_);
        }
        if (this.flushMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)17, (long)this.flushMs_);
        }
        int dataSize = 0;
        for (i = 0; i < this.followerReplicationThrottledReplicas_.size(); ++i) {
            dataSize += TopicMetadata.computeStringSizeNoTag((Object)this.followerReplicationThrottledReplicas_.getRaw(i));
        }
        size += dataSize;
        size += 2 * this.getFollowerReplicationThrottledReplicasList().size();
        dataSize = 0;
        for (i = 0; i < this.leaderReplicationThrottledReplicas_.size(); ++i) {
            dataSize += TopicMetadata.computeStringSizeNoTag((Object)this.leaderReplicationThrottledReplicas_.getRaw(i));
        }
        size += dataSize;
        size += 2 * this.getLeaderReplicationThrottledReplicasList().size();
        if (this.indexIntervalBytes_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)20, (int)this.indexIntervalBytes_);
        }
        if (this.maxCompactionLagMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)21, (long)this.maxCompactionLagMs_);
        }
        if (this.maxMessageBytes_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)22, (int)this.maxMessageBytes_);
        }
        if (this.messageDownconversionEnable_) {
            size += CodedOutputStream.computeBoolSize((int)23, (boolean)this.messageDownconversionEnable_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.messageFormatVersion_)) {
            size += GeneratedMessageV3.computeStringSize((int)24, (Object)this.messageFormatVersion_);
        }
        if (this.messageTimestampDifferenceMaxMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)25, (long)this.messageTimestampDifferenceMaxMs_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.messageTimestampType_)) {
            size += GeneratedMessageV3.computeStringSize((int)26, (Object)this.messageTimestampType_);
        }
        if (Double.doubleToRawLongBits(this.minCleanableDirtyRatio_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)27, (double)this.minCleanableDirtyRatio_);
        }
        if (this.minCompactionLagMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)28, (long)this.minCompactionLagMs_);
        }
        if (this.minInsyncReplicas_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)29, (int)this.minInsyncReplicas_);
        }
        if (this.preallocate_) {
            size += CodedOutputStream.computeBoolSize((int)30, (boolean)this.preallocate_);
        }
        if (this.segmentBytes_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)31, (int)this.segmentBytes_);
        }
        if (this.segmentIndexBytes_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)32, (int)this.segmentIndexBytes_);
        }
        if (this.segmentJitterMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)33, (long)this.segmentJitterMs_);
        }
        if (this.segmentMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)34, (long)this.segmentMs_);
        }
        if (this.uncleanLeaderElectionEnable_) {
            size += CodedOutputStream.computeBoolSize((int)35, (boolean)this.uncleanLeaderElectionEnable_);
        }
        if (this.deleteRetentionMs_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)36, (long)this.deleteRetentionMs_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TopicMetadata)) {
            return super.equals(obj);
        }
        TopicMetadata other = (TopicMetadata)obj;
        if (!this.getTopicId().equals(other.getTopicId())) {
            return false;
        }
        if (!this.getTopicName().equals(other.getTopicName())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.getRetentionMs() != other.getRetentionMs()) {
            return false;
        }
        if (this.getRetentionBytes() != other.getRetentionBytes()) {
            return false;
        }
        if (this.getReplicationFactor() != other.getReplicationFactor()) {
            return false;
        }
        if (this.getPartitionsCount() != other.getPartitionsCount()) {
            return false;
        }
        if (this.cleanupPolicy_ != other.cleanupPolicy_) {
            return false;
        }
        if (this.getKeySchemaValidation() != other.getKeySchemaValidation()) {
            return false;
        }
        if (this.getValueSchemaValidation() != other.getValueSchemaValidation()) {
            return false;
        }
        if (!this.getOwner().equals(other.getOwner())) {
            return false;
        }
        if (this.hasMirrorTopicMetadata() != other.hasMirrorTopicMetadata()) {
            return false;
        }
        if (this.hasMirrorTopicMetadata() && !this.getMirrorTopicMetadata().equals(other.getMirrorTopicMetadata())) {
            return false;
        }
        if (this.compressionType_ != other.compressionType_) {
            return false;
        }
        if (this.getFileDeleteDelayMs() != other.getFileDeleteDelayMs()) {
            return false;
        }
        if (this.getFlushMessages() != other.getFlushMessages()) {
            return false;
        }
        if (this.getFlushMs() != other.getFlushMs()) {
            return false;
        }
        if (!this.getFollowerReplicationThrottledReplicasList().equals(other.getFollowerReplicationThrottledReplicasList())) {
            return false;
        }
        if (!this.getLeaderReplicationThrottledReplicasList().equals(other.getLeaderReplicationThrottledReplicasList())) {
            return false;
        }
        if (this.getIndexIntervalBytes() != other.getIndexIntervalBytes()) {
            return false;
        }
        if (this.getMaxCompactionLagMs() != other.getMaxCompactionLagMs()) {
            return false;
        }
        if (this.getMaxMessageBytes() != other.getMaxMessageBytes()) {
            return false;
        }
        if (this.getMessageDownconversionEnable() != other.getMessageDownconversionEnable()) {
            return false;
        }
        if (!this.getMessageFormatVersion().equals(other.getMessageFormatVersion())) {
            return false;
        }
        if (this.getMessageTimestampDifferenceMaxMs() != other.getMessageTimestampDifferenceMaxMs()) {
            return false;
        }
        if (!this.getMessageTimestampType().equals(other.getMessageTimestampType())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getMinCleanableDirtyRatio()) != Double.doubleToLongBits(other.getMinCleanableDirtyRatio())) {
            return false;
        }
        if (this.getMinCompactionLagMs() != other.getMinCompactionLagMs()) {
            return false;
        }
        if (this.getMinInsyncReplicas() != other.getMinInsyncReplicas()) {
            return false;
        }
        if (this.getPreallocate() != other.getPreallocate()) {
            return false;
        }
        if (this.getSegmentBytes() != other.getSegmentBytes()) {
            return false;
        }
        if (this.getSegmentIndexBytes() != other.getSegmentIndexBytes()) {
            return false;
        }
        if (this.getSegmentJitterMs() != other.getSegmentJitterMs()) {
            return false;
        }
        if (this.getSegmentMs() != other.getSegmentMs()) {
            return false;
        }
        if (this.getUncleanLeaderElectionEnable() != other.getUncleanLeaderElectionEnable()) {
            return false;
        }
        if (this.getDeleteRetentionMs() != other.getDeleteRetentionMs()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TopicMetadata.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTopicId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTopicName().hashCode();
        if (this.hasCreateTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashLong((long)this.getRetentionMs());
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashLong((long)this.getRetentionBytes());
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getReplicationFactor();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getPartitionsCount();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.cleanupPolicy_;
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getKeySchemaValidation());
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getValueSchemaValidation());
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getOwner().hashCode();
        if (this.hasMirrorTopicMetadata()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getMirrorTopicMetadata().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + this.compressionType_;
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashLong((long)this.getFileDeleteDelayMs());
        hash = 37 * hash + 16;
        hash = 53 * hash + Internal.hashLong((long)this.getFlushMessages());
        hash = 37 * hash + 17;
        hash = 53 * hash + Internal.hashLong((long)this.getFlushMs());
        if (this.getFollowerReplicationThrottledReplicasCount() > 0) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getFollowerReplicationThrottledReplicasList().hashCode();
        }
        if (this.getLeaderReplicationThrottledReplicasCount() > 0) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getLeaderReplicationThrottledReplicasList().hashCode();
        }
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getIndexIntervalBytes();
        hash = 37 * hash + 21;
        hash = 53 * hash + Internal.hashLong((long)this.getMaxCompactionLagMs());
        hash = 37 * hash + 22;
        hash = 53 * hash + this.getMaxMessageBytes();
        hash = 37 * hash + 23;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getMessageDownconversionEnable());
        hash = 37 * hash + 24;
        hash = 53 * hash + this.getMessageFormatVersion().hashCode();
        hash = 37 * hash + 25;
        hash = 53 * hash + Internal.hashLong((long)this.getMessageTimestampDifferenceMaxMs());
        hash = 37 * hash + 26;
        hash = 53 * hash + this.getMessageTimestampType().hashCode();
        hash = 37 * hash + 27;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getMinCleanableDirtyRatio()));
        hash = 37 * hash + 28;
        hash = 53 * hash + Internal.hashLong((long)this.getMinCompactionLagMs());
        hash = 37 * hash + 29;
        hash = 53 * hash + this.getMinInsyncReplicas();
        hash = 37 * hash + 30;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPreallocate());
        hash = 37 * hash + 31;
        hash = 53 * hash + this.getSegmentBytes();
        hash = 37 * hash + 32;
        hash = 53 * hash + this.getSegmentIndexBytes();
        hash = 37 * hash + 33;
        hash = 53 * hash + Internal.hashLong((long)this.getSegmentJitterMs());
        hash = 37 * hash + 34;
        hash = 53 * hash + Internal.hashLong((long)this.getSegmentMs());
        hash = 37 * hash + 35;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUncleanLeaderElectionEnable());
        hash = 37 * hash + 36;
        hash = 53 * hash + Internal.hashLong((long)this.getDeleteRetentionMs());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TopicMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data);
    }

    public static TopicMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TopicMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data);
    }

    public static TopicMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TopicMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data);
    }

    public static TopicMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TopicMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TopicMetadata parseFrom(InputStream input) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TopicMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TopicMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TopicMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TopicMetadata parseFrom(CodedInputStream input) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TopicMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TopicMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TopicMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TopicMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TopicMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TopicMetadata> parser() {
        return PARSER;
    }

    public Parser<TopicMetadata> getParserForType() {
        return PARSER;
    }

    public TopicMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TopicMetadataOrBuilder {
        private int bitField0_;
        private int bitField1_;
        private Object topicId_ = "";
        private Object topicName_ = "";
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private long retentionMs_;
        private long retentionBytes_;
        private int replicationFactor_;
        private int partitionsCount_;
        private int cleanupPolicy_ = 0;
        private boolean keySchemaValidation_;
        private boolean valueSchemaValidation_;
        private Object owner_ = "";
        private MirrorTopicMetadata mirrorTopicMetadata_;
        private SingleFieldBuilderV3<MirrorTopicMetadata, MirrorTopicMetadata.Builder, MirrorTopicMetadataOrBuilder> mirrorTopicMetadataBuilder_;
        private int compressionType_ = 0;
        private long fileDeleteDelayMs_;
        private long flushMessages_;
        private long flushMs_;
        private LazyStringArrayList followerReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList leaderReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
        private int indexIntervalBytes_;
        private long maxCompactionLagMs_;
        private int maxMessageBytes_;
        private boolean messageDownconversionEnable_;
        private Object messageFormatVersion_ = "";
        private long messageTimestampDifferenceMaxMs_;
        private Object messageTimestampType_ = "";
        private double minCleanableDirtyRatio_;
        private long minCompactionLagMs_;
        private int minInsyncReplicas_;
        private boolean preallocate_;
        private int segmentBytes_;
        private int segmentIndexBytes_;
        private long segmentJitterMs_;
        private long segmentMs_;
        private boolean uncleanLeaderElectionEnable_;
        private long deleteRetentionMs_;

        public static final Descriptors.Descriptor getDescriptor() {
            return Metadata.internal_static_catalog_v1_TopicMetadata_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Metadata.internal_static_catalog_v1_TopicMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(TopicMetadata.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
                this.getMirrorTopicMetadataFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.bitField1_ = 0;
            this.topicId_ = "";
            this.topicName_ = "";
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.retentionMs_ = 0L;
            this.retentionBytes_ = 0L;
            this.replicationFactor_ = 0;
            this.partitionsCount_ = 0;
            this.cleanupPolicy_ = 0;
            this.keySchemaValidation_ = false;
            this.valueSchemaValidation_ = false;
            this.owner_ = "";
            this.mirrorTopicMetadata_ = null;
            if (this.mirrorTopicMetadataBuilder_ != null) {
                this.mirrorTopicMetadataBuilder_.dispose();
                this.mirrorTopicMetadataBuilder_ = null;
            }
            this.compressionType_ = 0;
            this.fileDeleteDelayMs_ = 0L;
            this.flushMessages_ = 0L;
            this.flushMs_ = 0L;
            this.followerReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
            this.leaderReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
            this.indexIntervalBytes_ = 0;
            this.maxCompactionLagMs_ = 0L;
            this.maxMessageBytes_ = 0;
            this.messageDownconversionEnable_ = false;
            this.messageFormatVersion_ = "";
            this.messageTimestampDifferenceMaxMs_ = 0L;
            this.messageTimestampType_ = "";
            this.minCleanableDirtyRatio_ = 0.0;
            this.minCompactionLagMs_ = 0L;
            this.minInsyncReplicas_ = 0;
            this.preallocate_ = false;
            this.segmentBytes_ = 0;
            this.segmentIndexBytes_ = 0;
            this.segmentJitterMs_ = 0L;
            this.segmentMs_ = 0L;
            this.uncleanLeaderElectionEnable_ = false;
            this.deleteRetentionMs_ = 0L;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Metadata.internal_static_catalog_v1_TopicMetadata_descriptor;
        }

        public TopicMetadata getDefaultInstanceForType() {
            return TopicMetadata.getDefaultInstance();
        }

        public TopicMetadata build() {
            TopicMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TopicMetadata buildPartial() {
            TopicMetadata result = new TopicMetadata(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            if (this.bitField1_ != 0) {
                this.buildPartial1(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(TopicMetadata result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.topicId_ = this.topicId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.topicName_ = this.topicName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.retentionMs_ = this.retentionMs_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.retentionBytes_ = this.retentionBytes_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.replicationFactor_ = this.replicationFactor_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.partitionsCount_ = this.partitionsCount_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.cleanupPolicy_ = this.cleanupPolicy_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.keySchemaValidation_ = this.keySchemaValidation_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.valueSchemaValidation_ = this.valueSchemaValidation_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.owner_ = this.owner_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.mirrorTopicMetadata_ = this.mirrorTopicMetadataBuilder_ == null ? this.mirrorTopicMetadata_ : (MirrorTopicMetadata)this.mirrorTopicMetadataBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.compressionType_ = this.compressionType_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.fileDeleteDelayMs_ = this.fileDeleteDelayMs_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.flushMessages_ = this.flushMessages_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.flushMs_ = this.flushMs_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                this.followerReplicationThrottledReplicas_.makeImmutable();
                result.followerReplicationThrottledReplicas_ = this.followerReplicationThrottledReplicas_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                this.leaderReplicationThrottledReplicas_.makeImmutable();
                result.leaderReplicationThrottledReplicas_ = this.leaderReplicationThrottledReplicas_;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.indexIntervalBytes_ = this.indexIntervalBytes_;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.maxCompactionLagMs_ = this.maxCompactionLagMs_;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.maxMessageBytes_ = this.maxMessageBytes_;
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.messageDownconversionEnable_ = this.messageDownconversionEnable_;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                result.messageFormatVersion_ = this.messageFormatVersion_;
            }
            if ((from_bitField0_ & 0x1000000) != 0) {
                result.messageTimestampDifferenceMaxMs_ = this.messageTimestampDifferenceMaxMs_;
            }
            if ((from_bitField0_ & 0x2000000) != 0) {
                result.messageTimestampType_ = this.messageTimestampType_;
            }
            if ((from_bitField0_ & 0x4000000) != 0) {
                result.minCleanableDirtyRatio_ = this.minCleanableDirtyRatio_;
            }
            if ((from_bitField0_ & 0x8000000) != 0) {
                result.minCompactionLagMs_ = this.minCompactionLagMs_;
            }
            if ((from_bitField0_ & 0x10000000) != 0) {
                result.minInsyncReplicas_ = this.minInsyncReplicas_;
            }
            if ((from_bitField0_ & 0x20000000) != 0) {
                result.preallocate_ = this.preallocate_;
            }
            if ((from_bitField0_ & 0x40000000) != 0) {
                result.segmentBytes_ = this.segmentBytes_;
            }
            if ((from_bitField0_ & Integer.MIN_VALUE) != 0) {
                result.segmentIndexBytes_ = this.segmentIndexBytes_;
            }
            TopicMetadata topicMetadata = result;
            topicMetadata.bitField0_ = topicMetadata.bitField0_ | to_bitField0_;
        }

        private void buildPartial1(TopicMetadata result) {
            int from_bitField1_ = this.bitField1_;
            if ((from_bitField1_ & 1) != 0) {
                result.segmentJitterMs_ = this.segmentJitterMs_;
            }
            if ((from_bitField1_ & 2) != 0) {
                result.segmentMs_ = this.segmentMs_;
            }
            if ((from_bitField1_ & 4) != 0) {
                result.uncleanLeaderElectionEnable_ = this.uncleanLeaderElectionEnable_;
            }
            if ((from_bitField1_ & 8) != 0) {
                result.deleteRetentionMs_ = this.deleteRetentionMs_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TopicMetadata) {
                return this.mergeFrom((TopicMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TopicMetadata other) {
            if (other == TopicMetadata.getDefaultInstance()) {
                return this;
            }
            if (!other.getTopicId().isEmpty()) {
                this.topicId_ = other.topicId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getTopicName().isEmpty()) {
                this.topicName_ = other.topicName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.getRetentionMs() != 0L) {
                this.setRetentionMs(other.getRetentionMs());
            }
            if (other.getRetentionBytes() != 0L) {
                this.setRetentionBytes(other.getRetentionBytes());
            }
            if (other.getReplicationFactor() != 0) {
                this.setReplicationFactor(other.getReplicationFactor());
            }
            if (other.getPartitionsCount() != 0) {
                this.setPartitionsCount(other.getPartitionsCount());
            }
            if (other.cleanupPolicy_ != 0) {
                this.setCleanupPolicyValue(other.getCleanupPolicyValue());
            }
            if (other.getKeySchemaValidation()) {
                this.setKeySchemaValidation(other.getKeySchemaValidation());
            }
            if (other.getValueSchemaValidation()) {
                this.setValueSchemaValidation(other.getValueSchemaValidation());
            }
            if (!other.getOwner().isEmpty()) {
                this.owner_ = other.owner_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.hasMirrorTopicMetadata()) {
                this.mergeMirrorTopicMetadata(other.getMirrorTopicMetadata());
            }
            if (other.compressionType_ != 0) {
                this.setCompressionTypeValue(other.getCompressionTypeValue());
            }
            if (other.getFileDeleteDelayMs() != 0L) {
                this.setFileDeleteDelayMs(other.getFileDeleteDelayMs());
            }
            if (other.getFlushMessages() != 0L) {
                this.setFlushMessages(other.getFlushMessages());
            }
            if (other.getFlushMs() != 0L) {
                this.setFlushMs(other.getFlushMs());
            }
            if (!other.followerReplicationThrottledReplicas_.isEmpty()) {
                if (this.followerReplicationThrottledReplicas_.isEmpty()) {
                    this.followerReplicationThrottledReplicas_ = other.followerReplicationThrottledReplicas_;
                    this.bitField0_ |= 0x20000;
                } else {
                    this.ensureFollowerReplicationThrottledReplicasIsMutable();
                    this.followerReplicationThrottledReplicas_.addAll((Collection)other.followerReplicationThrottledReplicas_);
                }
                this.onChanged();
            }
            if (!other.leaderReplicationThrottledReplicas_.isEmpty()) {
                if (this.leaderReplicationThrottledReplicas_.isEmpty()) {
                    this.leaderReplicationThrottledReplicas_ = other.leaderReplicationThrottledReplicas_;
                    this.bitField0_ |= 0x40000;
                } else {
                    this.ensureLeaderReplicationThrottledReplicasIsMutable();
                    this.leaderReplicationThrottledReplicas_.addAll((Collection)other.leaderReplicationThrottledReplicas_);
                }
                this.onChanged();
            }
            if (other.getIndexIntervalBytes() != 0) {
                this.setIndexIntervalBytes(other.getIndexIntervalBytes());
            }
            if (other.getMaxCompactionLagMs() != 0L) {
                this.setMaxCompactionLagMs(other.getMaxCompactionLagMs());
            }
            if (other.getMaxMessageBytes() != 0) {
                this.setMaxMessageBytes(other.getMaxMessageBytes());
            }
            if (other.getMessageDownconversionEnable()) {
                this.setMessageDownconversionEnable(other.getMessageDownconversionEnable());
            }
            if (!other.getMessageFormatVersion().isEmpty()) {
                this.messageFormatVersion_ = other.messageFormatVersion_;
                this.bitField0_ |= 0x800000;
                this.onChanged();
            }
            if (other.getMessageTimestampDifferenceMaxMs() != 0L) {
                this.setMessageTimestampDifferenceMaxMs(other.getMessageTimestampDifferenceMaxMs());
            }
            if (!other.getMessageTimestampType().isEmpty()) {
                this.messageTimestampType_ = other.messageTimestampType_;
                this.bitField0_ |= 0x2000000;
                this.onChanged();
            }
            if (other.getMinCleanableDirtyRatio() != 0.0) {
                this.setMinCleanableDirtyRatio(other.getMinCleanableDirtyRatio());
            }
            if (other.getMinCompactionLagMs() != 0L) {
                this.setMinCompactionLagMs(other.getMinCompactionLagMs());
            }
            if (other.getMinInsyncReplicas() != 0) {
                this.setMinInsyncReplicas(other.getMinInsyncReplicas());
            }
            if (other.getPreallocate()) {
                this.setPreallocate(other.getPreallocate());
            }
            if (other.getSegmentBytes() != 0) {
                this.setSegmentBytes(other.getSegmentBytes());
            }
            if (other.getSegmentIndexBytes() != 0) {
                this.setSegmentIndexBytes(other.getSegmentIndexBytes());
            }
            if (other.getSegmentJitterMs() != 0L) {
                this.setSegmentJitterMs(other.getSegmentJitterMs());
            }
            if (other.getSegmentMs() != 0L) {
                this.setSegmentMs(other.getSegmentMs());
            }
            if (other.getUncleanLeaderElectionEnable()) {
                this.setUncleanLeaderElectionEnable(other.getUncleanLeaderElectionEnable());
            }
            if (other.getDeleteRetentionMs() != 0L) {
                this.setDeleteRetentionMs(other.getDeleteRetentionMs());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block44: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block44;
                        }
                        case 10: {
                            this.topicId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block44;
                        }
                        case 18: {
                            this.topicName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block44;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block44;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block44;
                        }
                        case 40: {
                            this.retentionMs_ = input.readInt64();
                            this.bitField0_ |= 0x10;
                            continue block44;
                        }
                        case 48: {
                            this.retentionBytes_ = input.readSInt64();
                            this.bitField0_ |= 0x20;
                            continue block44;
                        }
                        case 56: {
                            this.replicationFactor_ = input.readInt32();
                            this.bitField0_ |= 0x40;
                            continue block44;
                        }
                        case 64: {
                            this.partitionsCount_ = input.readInt32();
                            this.bitField0_ |= 0x80;
                            continue block44;
                        }
                        case 72: {
                            this.cleanupPolicy_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block44;
                        }
                        case 80: {
                            this.keySchemaValidation_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block44;
                        }
                        case 88: {
                            this.valueSchemaValidation_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block44;
                        }
                        case 98: {
                            this.owner_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block44;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getMirrorTopicMetadataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block44;
                        }
                        case 112: {
                            this.compressionType_ = input.readEnum();
                            this.bitField0_ |= 0x2000;
                            continue block44;
                        }
                        case 120: {
                            this.fileDeleteDelayMs_ = input.readInt64();
                            this.bitField0_ |= 0x4000;
                            continue block44;
                        }
                        case 128: {
                            this.flushMessages_ = input.readInt64();
                            this.bitField0_ |= 0x8000;
                            continue block44;
                        }
                        case 136: {
                            this.flushMs_ = input.readInt64();
                            this.bitField0_ |= 0x10000;
                            continue block44;
                        }
                        case 146: {
                            String s = input.readStringRequireUtf8();
                            this.ensureFollowerReplicationThrottledReplicasIsMutable();
                            this.followerReplicationThrottledReplicas_.add((Object)s);
                            continue block44;
                        }
                        case 154: {
                            String s = input.readStringRequireUtf8();
                            this.ensureLeaderReplicationThrottledReplicasIsMutable();
                            this.leaderReplicationThrottledReplicas_.add((Object)s);
                            continue block44;
                        }
                        case 160: {
                            this.indexIntervalBytes_ = input.readInt32();
                            this.bitField0_ |= 0x80000;
                            continue block44;
                        }
                        case 168: {
                            this.maxCompactionLagMs_ = input.readInt64();
                            this.bitField0_ |= 0x100000;
                            continue block44;
                        }
                        case 176: {
                            this.maxMessageBytes_ = input.readInt32();
                            this.bitField0_ |= 0x200000;
                            continue block44;
                        }
                        case 184: {
                            this.messageDownconversionEnable_ = input.readBool();
                            this.bitField0_ |= 0x400000;
                            continue block44;
                        }
                        case 194: {
                            this.messageFormatVersion_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800000;
                            continue block44;
                        }
                        case 200: {
                            this.messageTimestampDifferenceMaxMs_ = input.readInt64();
                            this.bitField0_ |= 0x1000000;
                            continue block44;
                        }
                        case 210: {
                            this.messageTimestampType_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000000;
                            continue block44;
                        }
                        case 217: {
                            this.minCleanableDirtyRatio_ = input.readDouble();
                            this.bitField0_ |= 0x4000000;
                            continue block44;
                        }
                        case 224: {
                            this.minCompactionLagMs_ = input.readInt64();
                            this.bitField0_ |= 0x8000000;
                            continue block44;
                        }
                        case 232: {
                            this.minInsyncReplicas_ = input.readInt32();
                            this.bitField0_ |= 0x10000000;
                            continue block44;
                        }
                        case 240: {
                            this.preallocate_ = input.readBool();
                            this.bitField0_ |= 0x20000000;
                            continue block44;
                        }
                        case 248: {
                            this.segmentBytes_ = input.readInt32();
                            this.bitField0_ |= 0x40000000;
                            continue block44;
                        }
                        case 256: {
                            this.segmentIndexBytes_ = input.readInt32();
                            this.bitField0_ |= Integer.MIN_VALUE;
                            continue block44;
                        }
                        case 264: {
                            this.segmentJitterMs_ = input.readInt64();
                            this.bitField1_ |= 1;
                            continue block44;
                        }
                        case 272: {
                            this.segmentMs_ = input.readInt64();
                            this.bitField1_ |= 2;
                            continue block44;
                        }
                        case 280: {
                            this.uncleanLeaderElectionEnable_ = input.readBool();
                            this.bitField1_ |= 4;
                            continue block44;
                        }
                        case 288: {
                            this.deleteRetentionMs_ = input.readInt64();
                            this.bitField1_ |= 8;
                            continue block44;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getTopicId() {
            Object ref = this.topicId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.topicId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTopicIdBytes() {
            Object ref = this.topicId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.topicId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTopicId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.topicId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTopicId() {
            this.topicId_ = TopicMetadata.getDefaultInstance().getTopicId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setTopicIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.topicId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getTopicName() {
            Object ref = this.topicName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.topicName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTopicNameBytes() {
            Object ref = this.topicName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.topicName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTopicName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.topicName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTopicName() {
            this.topicName_ = TopicMetadata.getDefaultInstance().getTopicName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTopicNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.topicName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        public long getRetentionMs() {
            return this.retentionMs_;
        }

        public Builder setRetentionMs(long value) {
            this.retentionMs_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearRetentionMs() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.retentionMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getRetentionBytes() {
            return this.retentionBytes_;
        }

        public Builder setRetentionBytes(long value) {
            this.retentionBytes_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearRetentionBytes() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.retentionBytes_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getReplicationFactor() {
            return this.replicationFactor_;
        }

        public Builder setReplicationFactor(int value) {
            this.replicationFactor_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearReplicationFactor() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.replicationFactor_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPartitionsCount() {
            return this.partitionsCount_;
        }

        public Builder setPartitionsCount(int value) {
            this.partitionsCount_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearPartitionsCount() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.partitionsCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getCleanupPolicyValue() {
            return this.cleanupPolicy_;
        }

        public Builder setCleanupPolicyValue(int value) {
            this.cleanupPolicy_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public CleanupPolicy getCleanupPolicy() {
            CleanupPolicy result = CleanupPolicy.forNumber(this.cleanupPolicy_);
            return result == null ? CleanupPolicy.UNRECOGNIZED : result;
        }

        public Builder setCleanupPolicy(CleanupPolicy value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.cleanupPolicy_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCleanupPolicy() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.cleanupPolicy_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getKeySchemaValidation() {
            return this.keySchemaValidation_;
        }

        public Builder setKeySchemaValidation(boolean value) {
            this.keySchemaValidation_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearKeySchemaValidation() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.keySchemaValidation_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getValueSchemaValidation() {
            return this.valueSchemaValidation_;
        }

        public Builder setValueSchemaValidation(boolean value) {
            this.valueSchemaValidation_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearValueSchemaValidation() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.valueSchemaValidation_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getOwner() {
            Object ref = this.owner_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.owner_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOwnerBytes() {
            Object ref = this.owner_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.owner_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOwner(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.owner_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearOwner() {
            this.owner_ = TopicMetadata.getDefaultInstance().getOwner();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setOwnerBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.owner_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMirrorTopicMetadata() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public MirrorTopicMetadata getMirrorTopicMetadata() {
            if (this.mirrorTopicMetadataBuilder_ == null) {
                return this.mirrorTopicMetadata_ == null ? MirrorTopicMetadata.getDefaultInstance() : this.mirrorTopicMetadata_;
            }
            return (MirrorTopicMetadata)this.mirrorTopicMetadataBuilder_.getMessage();
        }

        public Builder setMirrorTopicMetadata(MirrorTopicMetadata value) {
            if (this.mirrorTopicMetadataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mirrorTopicMetadata_ = value;
            } else {
                this.mirrorTopicMetadataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setMirrorTopicMetadata(MirrorTopicMetadata.Builder builderForValue) {
            if (this.mirrorTopicMetadataBuilder_ == null) {
                this.mirrorTopicMetadata_ = builderForValue.build();
            } else {
                this.mirrorTopicMetadataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeMirrorTopicMetadata(MirrorTopicMetadata value) {
            if (this.mirrorTopicMetadataBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.mirrorTopicMetadata_ != null && this.mirrorTopicMetadata_ != MirrorTopicMetadata.getDefaultInstance()) {
                    this.getMirrorTopicMetadataBuilder().mergeFrom(value);
                } else {
                    this.mirrorTopicMetadata_ = value;
                }
            } else {
                this.mirrorTopicMetadataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.mirrorTopicMetadata_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMirrorTopicMetadata() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.mirrorTopicMetadata_ = null;
            if (this.mirrorTopicMetadataBuilder_ != null) {
                this.mirrorTopicMetadataBuilder_.dispose();
                this.mirrorTopicMetadataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MirrorTopicMetadata.Builder getMirrorTopicMetadataBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (MirrorTopicMetadata.Builder)this.getMirrorTopicMetadataFieldBuilder().getBuilder();
        }

        @Override
        public MirrorTopicMetadataOrBuilder getMirrorTopicMetadataOrBuilder() {
            if (this.mirrorTopicMetadataBuilder_ != null) {
                return (MirrorTopicMetadataOrBuilder)this.mirrorTopicMetadataBuilder_.getMessageOrBuilder();
            }
            return this.mirrorTopicMetadata_ == null ? MirrorTopicMetadata.getDefaultInstance() : this.mirrorTopicMetadata_;
        }

        private SingleFieldBuilderV3<MirrorTopicMetadata, MirrorTopicMetadata.Builder, MirrorTopicMetadataOrBuilder> getMirrorTopicMetadataFieldBuilder() {
            if (this.mirrorTopicMetadataBuilder_ == null) {
                this.mirrorTopicMetadataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMirrorTopicMetadata(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mirrorTopicMetadata_ = null;
            }
            return this.mirrorTopicMetadataBuilder_;
        }

        @Override
        public int getCompressionTypeValue() {
            return this.compressionType_;
        }

        public Builder setCompressionTypeValue(int value) {
            this.compressionType_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public CompressionType getCompressionType() {
            CompressionType result = CompressionType.forNumber(this.compressionType_);
            return result == null ? CompressionType.UNRECOGNIZED : result;
        }

        public Builder setCompressionType(CompressionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x2000;
            this.compressionType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCompressionType() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.compressionType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getFileDeleteDelayMs() {
            return this.fileDeleteDelayMs_;
        }

        public Builder setFileDeleteDelayMs(long value) {
            this.fileDeleteDelayMs_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearFileDeleteDelayMs() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.fileDeleteDelayMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getFlushMessages() {
            return this.flushMessages_;
        }

        public Builder setFlushMessages(long value) {
            this.flushMessages_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearFlushMessages() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.flushMessages_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getFlushMs() {
            return this.flushMs_;
        }

        public Builder setFlushMs(long value) {
            this.flushMs_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearFlushMs() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.flushMs_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureFollowerReplicationThrottledReplicasIsMutable() {
            if (!this.followerReplicationThrottledReplicas_.isModifiable()) {
                this.followerReplicationThrottledReplicas_ = new LazyStringArrayList((LazyStringList)this.followerReplicationThrottledReplicas_);
            }
            this.bitField0_ |= 0x20000;
        }

        public ProtocolStringList getFollowerReplicationThrottledReplicasList() {
            this.followerReplicationThrottledReplicas_.makeImmutable();
            return this.followerReplicationThrottledReplicas_;
        }

        @Override
        public int getFollowerReplicationThrottledReplicasCount() {
            return this.followerReplicationThrottledReplicas_.size();
        }

        @Override
        public String getFollowerReplicationThrottledReplicas(int index) {
            return this.followerReplicationThrottledReplicas_.get(index);
        }

        @Override
        public ByteString getFollowerReplicationThrottledReplicasBytes(int index) {
            return this.followerReplicationThrottledReplicas_.getByteString(index);
        }

        public Builder setFollowerReplicationThrottledReplicas(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFollowerReplicationThrottledReplicasIsMutable();
            this.followerReplicationThrottledReplicas_.set(index, value);
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder addFollowerReplicationThrottledReplicas(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFollowerReplicationThrottledReplicasIsMutable();
            this.followerReplicationThrottledReplicas_.add((Object)value);
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder addAllFollowerReplicationThrottledReplicas(Iterable<String> values) {
            this.ensureFollowerReplicationThrottledReplicasIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.followerReplicationThrottledReplicas_);
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearFollowerReplicationThrottledReplicas() {
            this.followerReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFDFFFF;
            this.onChanged();
            return this;
        }

        public Builder addFollowerReplicationThrottledReplicasBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.ensureFollowerReplicationThrottledReplicasIsMutable();
            this.followerReplicationThrottledReplicas_.add(value);
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        private void ensureLeaderReplicationThrottledReplicasIsMutable() {
            if (!this.leaderReplicationThrottledReplicas_.isModifiable()) {
                this.leaderReplicationThrottledReplicas_ = new LazyStringArrayList((LazyStringList)this.leaderReplicationThrottledReplicas_);
            }
            this.bitField0_ |= 0x40000;
        }

        public ProtocolStringList getLeaderReplicationThrottledReplicasList() {
            this.leaderReplicationThrottledReplicas_.makeImmutable();
            return this.leaderReplicationThrottledReplicas_;
        }

        @Override
        public int getLeaderReplicationThrottledReplicasCount() {
            return this.leaderReplicationThrottledReplicas_.size();
        }

        @Override
        public String getLeaderReplicationThrottledReplicas(int index) {
            return this.leaderReplicationThrottledReplicas_.get(index);
        }

        @Override
        public ByteString getLeaderReplicationThrottledReplicasBytes(int index) {
            return this.leaderReplicationThrottledReplicas_.getByteString(index);
        }

        public Builder setLeaderReplicationThrottledReplicas(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLeaderReplicationThrottledReplicasIsMutable();
            this.leaderReplicationThrottledReplicas_.set(index, value);
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder addLeaderReplicationThrottledReplicas(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLeaderReplicationThrottledReplicasIsMutable();
            this.leaderReplicationThrottledReplicas_.add((Object)value);
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder addAllLeaderReplicationThrottledReplicas(Iterable<String> values) {
            this.ensureLeaderReplicationThrottledReplicasIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.leaderReplicationThrottledReplicas_);
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearLeaderReplicationThrottledReplicas() {
            this.leaderReplicationThrottledReplicas_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFBFFFF;
            this.onChanged();
            return this;
        }

        public Builder addLeaderReplicationThrottledReplicasBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.ensureLeaderReplicationThrottledReplicasIsMutable();
            this.leaderReplicationThrottledReplicas_.add(value);
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Override
        public int getIndexIntervalBytes() {
            return this.indexIntervalBytes_;
        }

        public Builder setIndexIntervalBytes(int value) {
            this.indexIntervalBytes_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder clearIndexIntervalBytes() {
            this.bitField0_ &= 0xFFF7FFFF;
            this.indexIntervalBytes_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getMaxCompactionLagMs() {
            return this.maxCompactionLagMs_;
        }

        public Builder setMaxCompactionLagMs(long value) {
            this.maxCompactionLagMs_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder clearMaxCompactionLagMs() {
            this.bitField0_ &= 0xFFEFFFFF;
            this.maxCompactionLagMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getMaxMessageBytes() {
            return this.maxMessageBytes_;
        }

        public Builder setMaxMessageBytes(int value) {
            this.maxMessageBytes_ = value;
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder clearMaxMessageBytes() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.maxMessageBytes_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getMessageDownconversionEnable() {
            return this.messageDownconversionEnable_;
        }

        public Builder setMessageDownconversionEnable(boolean value) {
            this.messageDownconversionEnable_ = value;
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder clearMessageDownconversionEnable() {
            this.bitField0_ &= 0xFFBFFFFF;
            this.messageDownconversionEnable_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getMessageFormatVersion() {
            Object ref = this.messageFormatVersion_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.messageFormatVersion_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMessageFormatVersionBytes() {
            Object ref = this.messageFormatVersion_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.messageFormatVersion_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMessageFormatVersion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.messageFormatVersion_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder clearMessageFormatVersion() {
            this.messageFormatVersion_ = TopicMetadata.getDefaultInstance().getMessageFormatVersion();
            this.bitField0_ &= 0xFF7FFFFF;
            this.onChanged();
            return this;
        }

        public Builder setMessageFormatVersionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.messageFormatVersion_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        @Override
        public long getMessageTimestampDifferenceMaxMs() {
            return this.messageTimestampDifferenceMaxMs_;
        }

        public Builder setMessageTimestampDifferenceMaxMs(long value) {
            this.messageTimestampDifferenceMaxMs_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        public Builder clearMessageTimestampDifferenceMaxMs() {
            this.bitField0_ &= 0xFEFFFFFF;
            this.messageTimestampDifferenceMaxMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getMessageTimestampType() {
            Object ref = this.messageTimestampType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.messageTimestampType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMessageTimestampTypeBytes() {
            Object ref = this.messageTimestampType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.messageTimestampType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMessageTimestampType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.messageTimestampType_ = value;
            this.bitField0_ |= 0x2000000;
            this.onChanged();
            return this;
        }

        public Builder clearMessageTimestampType() {
            this.messageTimestampType_ = TopicMetadata.getDefaultInstance().getMessageTimestampType();
            this.bitField0_ &= 0xFDFFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setMessageTimestampTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TopicMetadata.checkByteStringIsUtf8((ByteString)value);
            this.messageTimestampType_ = value;
            this.bitField0_ |= 0x2000000;
            this.onChanged();
            return this;
        }

        @Override
        public double getMinCleanableDirtyRatio() {
            return this.minCleanableDirtyRatio_;
        }

        public Builder setMinCleanableDirtyRatio(double value) {
            this.minCleanableDirtyRatio_ = value;
            this.bitField0_ |= 0x4000000;
            this.onChanged();
            return this;
        }

        public Builder clearMinCleanableDirtyRatio() {
            this.bitField0_ &= 0xFBFFFFFF;
            this.minCleanableDirtyRatio_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public long getMinCompactionLagMs() {
            return this.minCompactionLagMs_;
        }

        public Builder setMinCompactionLagMs(long value) {
            this.minCompactionLagMs_ = value;
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder clearMinCompactionLagMs() {
            this.bitField0_ &= 0xF7FFFFFF;
            this.minCompactionLagMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getMinInsyncReplicas() {
            return this.minInsyncReplicas_;
        }

        public Builder setMinInsyncReplicas(int value) {
            this.minInsyncReplicas_ = value;
            this.bitField0_ |= 0x10000000;
            this.onChanged();
            return this;
        }

        public Builder clearMinInsyncReplicas() {
            this.bitField0_ &= 0xEFFFFFFF;
            this.minInsyncReplicas_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getPreallocate() {
            return this.preallocate_;
        }

        public Builder setPreallocate(boolean value) {
            this.preallocate_ = value;
            this.bitField0_ |= 0x20000000;
            this.onChanged();
            return this;
        }

        public Builder clearPreallocate() {
            this.bitField0_ &= 0xDFFFFFFF;
            this.preallocate_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getSegmentBytes() {
            return this.segmentBytes_;
        }

        public Builder setSegmentBytes(int value) {
            this.segmentBytes_ = value;
            this.bitField0_ |= 0x40000000;
            this.onChanged();
            return this;
        }

        public Builder clearSegmentBytes() {
            this.bitField0_ &= 0xBFFFFFFF;
            this.segmentBytes_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getSegmentIndexBytes() {
            return this.segmentIndexBytes_;
        }

        public Builder setSegmentIndexBytes(int value) {
            this.segmentIndexBytes_ = value;
            this.bitField0_ |= Integer.MIN_VALUE;
            this.onChanged();
            return this;
        }

        public Builder clearSegmentIndexBytes() {
            this.bitField0_ &= Integer.MAX_VALUE;
            this.segmentIndexBytes_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getSegmentJitterMs() {
            return this.segmentJitterMs_;
        }

        public Builder setSegmentJitterMs(long value) {
            this.segmentJitterMs_ = value;
            this.bitField1_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearSegmentJitterMs() {
            this.bitField1_ &= 0xFFFFFFFE;
            this.segmentJitterMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getSegmentMs() {
            return this.segmentMs_;
        }

        public Builder setSegmentMs(long value) {
            this.segmentMs_ = value;
            this.bitField1_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearSegmentMs() {
            this.bitField1_ &= 0xFFFFFFFD;
            this.segmentMs_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getUncleanLeaderElectionEnable() {
            return this.uncleanLeaderElectionEnable_;
        }

        public Builder setUncleanLeaderElectionEnable(boolean value) {
            this.uncleanLeaderElectionEnable_ = value;
            this.bitField1_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearUncleanLeaderElectionEnable() {
            this.bitField1_ &= 0xFFFFFFFB;
            this.uncleanLeaderElectionEnable_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public long getDeleteRetentionMs() {
            return this.deleteRetentionMs_;
        }

        public Builder setDeleteRetentionMs(long value) {
            this.deleteRetentionMs_ = value;
            this.bitField1_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDeleteRetentionMs() {
            this.bitField1_ &= 0xFFFFFFF7;
            this.deleteRetentionMs_ = 0L;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum CompressionType implements ProtocolMessageEnum
    {
        COMPRESSION_UNSPECIFIED(0),
        UNCOMPRESSED(1),
        ZSTD(2),
        LZ4(3),
        SNAPPY(4),
        GZIP(5),
        PRODUCER(6),
        UNRECOGNIZED(-1);

        public static final int COMPRESSION_UNSPECIFIED_VALUE = 0;
        public static final int UNCOMPRESSED_VALUE = 1;
        public static final int ZSTD_VALUE = 2;
        public static final int LZ4_VALUE = 3;
        public static final int SNAPPY_VALUE = 4;
        public static final int GZIP_VALUE = 5;
        public static final int PRODUCER_VALUE = 6;
        private static final Internal.EnumLiteMap<CompressionType> internalValueMap;
        private static final CompressionType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static CompressionType valueOf(int value) {
            return CompressionType.forNumber(value);
        }

        public static CompressionType forNumber(int value) {
            switch (value) {
                case 0: {
                    return COMPRESSION_UNSPECIFIED;
                }
                case 1: {
                    return UNCOMPRESSED;
                }
                case 2: {
                    return ZSTD;
                }
                case 3: {
                    return LZ4;
                }
                case 4: {
                    return SNAPPY;
                }
                case 5: {
                    return GZIP;
                }
                case 6: {
                    return PRODUCER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<CompressionType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)CompressionType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return CompressionType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)TopicMetadata.getDescriptor().getEnumTypes().get(1);
        }

        public static CompressionType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != CompressionType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private CompressionType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<CompressionType>(){

                public CompressionType findValueByNumber(int number) {
                    return CompressionType.forNumber(number);
                }
            };
            VALUES = CompressionType.values();
        }
    }

    public static enum CleanupPolicy implements ProtocolMessageEnum
    {
        UNSPECIFIED(0),
        DELETE(1),
        COMPACT(2),
        COMPACT_DELETE(3),
        UNRECOGNIZED(-1);

        public static final int UNSPECIFIED_VALUE = 0;
        public static final int DELETE_VALUE = 1;
        public static final int COMPACT_VALUE = 2;
        public static final int COMPACT_DELETE_VALUE = 3;
        private static final Internal.EnumLiteMap<CleanupPolicy> internalValueMap;
        private static final CleanupPolicy[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static CleanupPolicy valueOf(int value) {
            return CleanupPolicy.forNumber(value);
        }

        public static CleanupPolicy forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNSPECIFIED;
                }
                case 1: {
                    return DELETE;
                }
                case 2: {
                    return COMPACT;
                }
                case 3: {
                    return COMPACT_DELETE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<CleanupPolicy> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)CleanupPolicy.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return CleanupPolicy.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)TopicMetadata.getDescriptor().getEnumTypes().get(0);
        }

        public static CleanupPolicy valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != CleanupPolicy.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private CleanupPolicy(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<CleanupPolicy>(){

                public CleanupPolicy findValueByNumber(int number) {
                    return CleanupPolicy.forNumber(number);
                }
            };
            VALUES = CleanupPolicy.values();
        }
    }
}

