/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi;

import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.workloadapi.AddressScheme;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;

public class Address {
    public static final String SOCKET_ENV_VARIABLE = "SPIFFE_ENDPOINT_SOCKET";

    private Address() {
    }

    public static String getDefaultAddress() {
        String address = System.getenv(SOCKET_ENV_VARIABLE);
        if (StringUtils.isBlank((CharSequence)address)) {
            String error = String.format("Endpoint Socket Address Environment Variable is not set: %s", SOCKET_ENV_VARIABLE);
            throw new IllegalStateException(error);
        }
        return address;
    }

    public static URI parseAddress(@NonNull String address) throws SocketEndpointAddressException {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        URI parsedAddress = Address.parseUri(address);
        AddressScheme scheme = Address.getScheme(parsedAddress);
        if (scheme == AddressScheme.UNIX_SCHEME) {
            Address.validateUnixAddress(parsedAddress);
        } else {
            Address.validateTcpAddress(parsedAddress);
        }
        return parsedAddress;
    }

    private static URI parseUri(String address) throws SocketEndpointAddressException {
        URI parsedAddress;
        try {
            parsedAddress = new URI(address);
        }
        catch (URISyntaxException e) {
            String error = "Workload endpoint socket is not a valid URI: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint socket is not a valid URI: %s", address), e);
        }
        return parsedAddress;
    }

    private static AddressScheme getScheme(URI parsedAddress) throws SocketEndpointAddressException {
        try {
            String scheme = parsedAddress.getScheme();
            return AddressScheme.parseScheme(scheme);
        }
        catch (IllegalArgumentException e) {
            String error = "Workload endpoint socket URI must have a tcp:// or unix:// scheme: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint socket URI must have a tcp:// or unix:// scheme: %s", parsedAddress.toString()));
        }
    }

    private static void validateUnixAddress(URI parsedAddress) throws SocketEndpointAddressException {
        if (parsedAddress.isOpaque()) {
            String error = "Workload endpoint unix socket URI must not be opaque: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint unix socket URI must not be opaque: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getRawAuthority())) {
            String error = "Workload endpoint unix socket URI must not include authority component: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint unix socket URI must not include authority component: %s", parsedAddress));
        }
        if (Address.hasEmptyPath(parsedAddress.getPath())) {
            String error = "Workload endpoint unix socket path cannot be blank: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint unix socket path cannot be blank: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getRawQuery())) {
            String error = "Workload endpoint unix socket URI must not include query values: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint unix socket URI must not include query values: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getFragment())) {
            String error = "Workload endpoint unix socket URI must not include a fragment: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint unix socket URI must not include a fragment: %s", parsedAddress));
        }
    }

    private static void validateTcpAddress(URI parsedAddress) throws SocketEndpointAddressException {
        if (parsedAddress.isOpaque()) {
            String error = "Workload endpoint tcp socket URI must not be opaque: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must not be opaque: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getUserInfo())) {
            String error = "Workload endpoint tcp socket URI must not include user info: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must not include user info: %s", parsedAddress));
        }
        if (StringUtils.isBlank((CharSequence)parsedAddress.getHost())) {
            String error = "Workload endpoint tcp socket URI must include a host: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must include a host: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getPath())) {
            String error = "Workload endpoint tcp socket URI must not include a path: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must not include a path: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getRawQuery())) {
            String error = "Workload endpoint tcp socket URI must not include query values: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must not include query values: %s", parsedAddress));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedAddress.getFragment())) {
            String error = "Workload endpoint tcp socket URI must not include a fragment: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI must not include a fragment: %s", parsedAddress));
        }
        boolean ipValid = InetAddressValidator.getInstance().isValid(parsedAddress.getHost());
        if (!ipValid) {
            String error = "Workload endpoint tcp socket URI host component must be an IP:port: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI host component must be an IP:port: %s", parsedAddress));
        }
        int port = parsedAddress.getPort();
        if (port == -1) {
            String error = "Workload endpoint tcp socket URI host component must include a port: %s";
            throw new SocketEndpointAddressException(String.format("Workload endpoint tcp socket URI host component must include a port: %s", parsedAddress));
        }
    }

    private static boolean hasEmptyPath(String path) {
        return StringUtils.isBlank((CharSequence)path) || "/".equals(path);
    }
}

