/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class BindingScopes {
    public static final String ROOT_BINDING_SCOPE = "root";
    public static final String CLUSTER_BINDING_SCOPE = "cluster";
    public static final Pattern SCOPE_TYPE_PATTERN = Pattern.compile("[a-zA-Z-]+");
    private LinkedHashMap<String, Set<String>> bindingScopes;
    private String bindingScopesRoot;
    private List<List<String>> uniqueBindingScopesPath;

    @JsonCreator
    public BindingScopes(@JsonProperty(value="bindingScopes") LinkedHashMap<String, Object> bindingScopes) {
        this.bindingScopes = this.parseBindingScopes(bindingScopes);
        this.uniqueBindingScopesPath = this.getUniqueBindingScopesPath();
    }

    public final LinkedHashMap<String, Set<String>> parseBindingScopes(LinkedHashMap<String, Object> bindingScopes) {
        if (bindingScopes.size() > 1) {
            throw new InvalidRoleDefinitionException("bindingScopes should have only 1 root element");
        }
        LinkedHashMap<String, Set<String>> bindingScopesTree = new LinkedHashMap<String, Set<String>>();
        Stack<LinkedHashMap> stack = new Stack<LinkedHashMap>();
        stack.push(bindingScopes);
        while (!stack.isEmpty()) {
            LinkedHashMap bindingScopeNode = (LinkedHashMap)stack.pop();
            Set bindingScopeKeys = bindingScopeNode.keySet();
            for (String bindingScope : bindingScopeKeys) {
                this.validateBindingScope(bindingScope, bindingScopesTree);
                if (this.bindingScopesRoot == null) {
                    this.bindingScopesRoot = bindingScope;
                }
                LinkedHashMap childBindingScope = (LinkedHashMap)bindingScopeNode.get(bindingScope);
                bindingScopesTree.put(bindingScope, childBindingScope.keySet());
                if (childBindingScope == null || childBindingScope.isEmpty()) continue;
                stack.push(childBindingScope);
            }
        }
        return bindingScopesTree;
    }

    public final void validateBindingScope(String bindingScope, LinkedHashMap<String, Set<String>> bindingScopesTree) {
        if (!SCOPE_TYPE_PATTERN.matcher(bindingScope).matches()) {
            throw new InvalidRoleDefinitionException("bindingScopes may only contain letters and '-': '" + bindingScope + "'");
        }
        if (bindingScopesTree.containsKey(bindingScope)) {
            throw new InvalidRoleDefinitionException("bindingScopes may not be repeated: '" + bindingScope + "'");
        }
        if (this.bindingScopesRoot != null && bindingScope.equals(ROOT_BINDING_SCOPE)) {
            throw new InvalidRoleDefinitionException("binding scope 'root' must be root of the tree");
        }
    }

    public String findMostSpecificBindingScope(Set<String> bindingScopeSet) {
        ArrayList<String> bindingScopeDescendingKeys = new ArrayList<String>(this.bindingScopes.keySet());
        Collections.reverse(bindingScopeDescendingKeys);
        for (String bindingScope : bindingScopeDescendingKeys) {
            if (!bindingScopeSet.contains(bindingScope)) continue;
            return bindingScope;
        }
        return null;
    }

    public final List<List<String>> getUniqueBindingScopesPath() {
        LinkedList<List<String>> uniquePaths = new LinkedList<List<String>>();
        LinkedList<String> nodeStack = new LinkedList<String>();
        LinkedList pathStack = new LinkedList();
        nodeStack.add(this.bindingScopesRoot);
        pathStack.add(new LinkedList<String>(Arrays.asList(this.bindingScopesRoot)));
        while (!nodeStack.isEmpty()) {
            String node = (String)nodeStack.pollLast();
            List currentPath = (List)pathStack.pollLast();
            if (this.bindingScopes.get(node).isEmpty()) {
                uniquePaths.add(currentPath);
                continue;
            }
            for (String childScope : this.bindingScopes.get(node)) {
                LinkedList<String> newChildPath = new LinkedList<String>(currentPath);
                newChildPath.add(childScope);
                pathStack.add(newChildPath);
                nodeStack.add(childScope);
            }
        }
        return uniquePaths;
    }

    boolean isKnownScope(String scopeName) {
        return this.bindingScopes.containsKey(scopeName);
    }

    public boolean isPartialBindingScopePathUnique(Set<String> bindingScopes) {
        for (List<String> childBindingScopes : this.uniqueBindingScopesPath) {
            if (!childBindingScopes.containsAll(bindingScopes)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BindingScopes) {
            BindingScopes that = (BindingScopes)o;
            if (this.bindingScopes.size() == that.bindingScopes.size()) {
                return this.bindingScopes.keySet().equals(that.bindingScopes.keySet());
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bindingScopes, this.bindingScopesRoot);
    }

    public int size() {
        return this.bindingScopes.size();
    }

    public String getRoot() {
        return this.bindingScopesRoot;
    }
}

