/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.Operation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceType {
    public static final ResourceType ALL = new ResourceType("All");
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new ConcurrentHashMap<String, ResourceType>();
    private final String name;
    private final List<Operation> operations;

    public ResourceType(String name) {
        this.name = name;
        this.operations = null;
    }

    @JsonCreator
    public ResourceType(@JsonProperty(value="name") String name, @JsonProperty(value="operations") List<Operation> operations) {
        this.name = name;
        this.operations = operations;
        this.enforcePopulatedOperations();
    }

    public static ResourceType resourceType(String resourceType) {
        ResourceType rt = RESOURCE_TYPE_MAP.get(resourceType);
        if (rt == null) {
            rt = RESOURCE_TYPE_MAP.computeIfAbsent(resourceType, ResourceType::new);
        }
        return rt;
    }

    public String name() {
        return this.name;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    private void enforcePopulatedOperations() {
        if (this.operations == null || this.operations.isEmpty()) {
            throw new IllegalStateException("Resource type " + this.name + " does not have operations.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceType)) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

