/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Update kek request")
public class UpdateKekRequest {
    private Optional<Map<String, String>> kmsProps;
    private Optional<String> doc;
    private Optional<Boolean> shared;

    public static UpdateKekRequest fromJson(String json) throws IOException {
        return (UpdateKekRequest)JacksonMapper.INSTANCE.readValue(json, UpdateKekRequest.class);
    }

    @Schema(description="Properties of the kek")
    @JsonProperty(value="kmsProps")
    public Optional<Map<String, String>> getOptionalKmsProps() {
        return this.kmsProps;
    }

    @JsonIgnore
    public Map<String, String> getKmsProps() {
        return this.kmsProps != null ? (Map)this.kmsProps.orElse(null) : null;
    }

    @JsonProperty(value="kmsProps")
    public void setKmsProps(Optional<Map<String, String>> kmsProps) {
        this.kmsProps = kmsProps;
    }

    @JsonIgnore
    public void setKmsProps(Map<String, String> kmsProps) {
        this.kmsProps = kmsProps != null ? Optional.of(kmsProps) : null;
    }

    @Schema(description="Description of the kek")
    @JsonProperty(value="doc")
    public Optional<String> getOptionalDoc() {
        return this.doc;
    }

    @JsonIgnore
    public String getDoc() {
        return this.doc != null ? (String)this.doc.orElse(null) : null;
    }

    @JsonProperty(value="doc")
    public void setDoc(Optional<String> doc) {
        this.doc = doc;
    }

    @JsonIgnore
    public void setDoc(String doc) {
        this.doc = doc != null ? Optional.of(doc) : null;
    }

    @Schema(description="Whether the kek is shared")
    @JsonProperty(value="shared")
    public Optional<Boolean> isOptionalShared() {
        return this.shared;
    }

    @JsonIgnore
    public Boolean isShared() {
        return this.shared != null ? (Boolean)this.shared.orElse(null) : null;
    }

    @JsonProperty(value="shared")
    public void setShared(Optional<Boolean> shared) {
        this.shared = shared;
    }

    @JsonIgnore
    public void setShared(Boolean shared) {
        this.shared = shared != null ? Optional.of(shared) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateKekRequest that = (UpdateKekRequest)o;
        return Objects.equals(this.kmsProps, that.kmsProps) && Objects.equals(this.doc, that.doc) && Objects.equals(this.shared, that.shared);
    }

    public int hashCode() {
        return Objects.hash(this.kmsProps, this.doc, this.shared);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

