/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DekRegistryConfig
extends SchemaRegistryConfig {
    private static final Logger log = LoggerFactory.getLogger(DekRegistryConfig.class);
    public static final String DEK_REGISTRY_TOPIC_CONFIG = "dek.registry.topic";
    public static final String DEK_REGISTRY_MAX_KEYS_CONFIG = "dek.registry.max.keys";
    public static final String DEK_REGISTRY_UPDATE_HANDLERS_CONFIG = "dek.registry.update.handlers";
    protected static final String DEK_REGISTRY_TOPIC_DEFAULT = "_dek_registry_keys";
    protected static final int DEK_REGISTRY_MAX_KEYS_DEFAULT = 20000;
    protected static final String KEK_SEARCH_DEFAULT_LIMIT_CONFIG = "kek.search.default.limit";
    protected static final int KEK_SEARCH_DEFAULT_LIMIT_DEFAULT = Integer.MAX_VALUE;
    protected static final String KEK_SEARCH_MAX_LIMIT_CONFIG = "kek.search.max.limit";
    protected static final int KEK_SEARCH_MAX_LIMIT_DEFAULT = Integer.MAX_VALUE;
    protected static final String DEK_SUBJECT_SEARCH_DEFAULT_LIMIT_CONFIG = "dek.subject.search.default.limit";
    protected static final int DEK_SUBJECT_SEARCH_DEFAULT_LIMIT = Integer.MAX_VALUE;
    protected static final String DEK_SUBJECT_SEARCH_MAX_LIMIT_CONFIG = "dek.subject.search.max.limit";
    protected static final int DEK_SUBJECT_SEARCH_MAX_LIMIT_DEFAULT = Integer.MAX_VALUE;
    protected static final String DEK_VERSION_SEARCH_DEFAULT_LIMIT_CONFIG = "dek.version.search.default.limit";
    protected static final int DEK_VERSION_SEARCH_DEFAULT_LIMIT = Integer.MAX_VALUE;
    protected static final String DEK_VERSION_SEARCH_MAX_LIMIT_CONFIG = "dek.version.search.max.limit";
    protected static final int DEK_VERSION_SEARCH_MAX_LIMIT_DEFAULT = Integer.MAX_VALUE;
    protected static final String DEK_REGISTRY_TOPIC_DOC = "The topic used to persist keys for the dek registry.";
    protected static final String DEK_REGISTRY_MAX_KEYS_DOC = "Maximum number of keys per tenant.";
    protected static final String DEK_REGISTRY_UPDATE_HANDLERS_DOC = "A list of classes to use as CacheUpdateHandler. Implementing the interface <code>CacheUpdateHandler</code> allows you to handle Kafka cache update events.";
    protected static final String KEK_SEARCH_DEFAULT_LIMIT_DOC = "The default limit for kek searches.";
    protected static final String KEK_SEARCH_MAX_LIMIT_DOC = "The max limit for kek searches.";
    protected static final String DEK_SUBJECT_SEARCH_DEFAULT_LIMIT_DOC = "The default limit for dek subject searches.";
    protected static final String DEK_SUBJECT_SEARCH_MAX_LIMIT_DOC = "The max limit for dek subject searches.";
    protected static final String DEK_VERSION_SEARCH_DEFAULT_LIMIT_DOC = "The default limit for dek version searches.";
    protected static final String DEK_VERSION_SEARCH_MAX_LIMIT_DOC = "The max limit for dek version searches.";
    private static final ConfigDef serverConfig = DekRegistryConfig.baseSchemaRegistryConfigDef().define("dek.registry.topic", ConfigDef.Type.STRING, (Object)"_dek_registry_keys", ConfigDef.Importance.HIGH, "The topic used to persist keys for the dek registry.").define("dek.registry.max.keys", ConfigDef.Type.INT, (Object)20000, ConfigDef.Importance.LOW, "Maximum number of keys per tenant.").define("kek.search.default.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The default limit for kek searches.").define("kek.search.max.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The max limit for kek searches.").define("dek.subject.search.default.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The default limit for dek subject searches.").define("dek.subject.search.max.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The max limit for dek subject searches.").define("dek.version.search.default.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The default limit for dek version searches.").define("dek.version.search.max.limit", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The max limit for dek version searches.").define("dek.registry.update.handlers", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as CacheUpdateHandler. Implementing the interface <code>CacheUpdateHandler</code> allows you to handle Kafka cache update events.");

    private static Properties getPropsFromFile(String propsFile) throws RestConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try (FileInputStream propStream = new FileInputStream(propsFile);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new RestConfigException("Couldn't load properties from " + propsFile, (Throwable)e);
        }
        return props;
    }

    public DekRegistryConfig(String propsFile) throws RestConfigException {
        this(DekRegistryConfig.getPropsFromFile(propsFile));
    }

    public DekRegistryConfig(Properties props) throws RestConfigException {
        this(serverConfig, props);
    }

    public DekRegistryConfig(ConfigDef configDef, Properties props) throws RestConfigException {
        super(configDef, props);
    }

    public String topic() {
        return this.getString(DEK_REGISTRY_TOPIC_CONFIG);
    }

    public int maxKeys() {
        return this.getInt(DEK_REGISTRY_MAX_KEYS_CONFIG);
    }
}

