/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.client.rest.entities.KeyType;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyEncryptionKey
extends EncryptionKey {
    private final String name;
    private final String kmsType;
    private final String kmsKeyId;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> kmsProps;
    private final String doc;
    private final boolean shared;

    @JsonCreator
    public KeyEncryptionKey(@JsonProperty(value="name") String name, @JsonProperty(value="kmsType") String kmsType, @JsonProperty(value="kmsKeyId") String kmsKeyId, @JsonProperty(value="kmsProps") SortedMap<String, String> kmsProps, @JsonProperty(value="doc") String doc, @JsonProperty(value="shared") boolean shared, @JsonProperty(value="deleted") boolean deleted) {
        super(KeyType.KEK, deleted);
        this.name = name;
        this.kmsType = kmsType;
        this.kmsKeyId = kmsKeyId;
        this.kmsProps = kmsProps != null ? Collections.unmodifiableSortedMap(kmsProps) : Collections.emptySortedMap();
        this.doc = doc;
        this.shared = shared;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="kmsType")
    public String getKmsType() {
        return this.kmsType;
    }

    @JsonProperty(value="kmsKeyId")
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    @JsonProperty(value="kmsProps")
    public SortedMap<String, String> getKmsProps() {
        return this.kmsProps;
    }

    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @JsonProperty(value="shared")
    public boolean isShared() {
        return this.shared;
    }

    @JsonIgnore
    public boolean isEquivalent(KeyEncryptionKey that) {
        return this.shared == that.shared && Objects.equals(this.name, that.name) && Objects.equals(this.kmsType, that.kmsType) && Objects.equals(this.kmsKeyId, that.kmsKeyId) && Objects.equals(this.kmsProps, that.kmsProps) && Objects.equals(this.doc, that.doc);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyEncryptionKey that = (KeyEncryptionKey)o;
        return this.shared == that.shared && Objects.equals(this.name, that.name) && Objects.equals(this.kmsType, that.kmsType) && Objects.equals(this.kmsKeyId, that.kmsKeyId) && Objects.equals(this.kmsProps, that.kmsProps) && Objects.equals(this.doc, that.doc);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared);
    }

    @Override
    public KeyEncryptionKeyId toKey(String tenant) {
        return new KeyEncryptionKeyId(tenant, this.name);
    }

    public Kek toKekEntity() {
        return new Kek(this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared, this.timestamp, this.deleted ? Boolean.valueOf(true) : null);
    }
}

