/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.web.rest.handlers;

import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.rest.handlers.UpdateRequestHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class EncryptionUpdateRequestHandler
implements UpdateRequestHandler {
    private static final String ENCRYPT_KEK_NAME = "encrypt.kek.name";
    private static final String ENCRYPT_KMS_KEY_ID = "encrypt.kms.key.id";
    private static final String ENCRYPT_KMS_TYPE = "encrypt.kms.type";

    public void handle(String subject, ConfigUpdateRequest request) {
    }

    public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
        this.addKmsDefaults(request);
    }

    public void handle(Schema schema, TagSchemaRequest request) {
        this.addKmsDefaults(request);
    }

    private void addKmsDefaults(RegisterSchemaRequest request) {
        request.setRuleSet(this.addKmsDefaults(request.getRuleSet()));
    }

    private void addKmsDefaults(TagSchemaRequest request) {
        request.setRuleSet(this.addKmsDefaults(request.getRuleSet()));
    }

    private RuleSet addKmsDefaults(RuleSet ruleSet) {
        if (ruleSet == null || ruleSet.getDomainRules() == null) {
            return ruleSet;
        }
        List domainRules = ruleSet.getDomainRules();
        ArrayList<Rule> newDomainRules = new ArrayList<Rule>();
        for (Rule rule : domainRules) {
            SortedMap params = rule.getParams();
            if (params == null || !params.containsKey(ENCRYPT_KMS_KEY_ID)) {
                newDomainRules.add(rule);
                continue;
            }
            if (params.containsKey(ENCRYPT_KEK_NAME) && params.containsKey(ENCRYPT_KMS_TYPE)) {
                newDomainRules.add(rule);
                continue;
            }
            String kmsKeyId = (String)params.get(ENCRYPT_KMS_KEY_ID);
            HashMap<String, String> newParams = new HashMap<String, String>(params);
            if (!params.containsKey(ENCRYPT_KEK_NAME)) {
                newParams.put(ENCRYPT_KEK_NAME, EncryptionUpdateRequestHandler.scrub(kmsKeyId));
            }
            if (!params.containsKey(ENCRYPT_KMS_TYPE) && kmsKeyId.startsWith("arn:")) {
                newParams.put(ENCRYPT_KMS_TYPE, "aws-kms");
            }
            Rule newRule = new Rule(rule.getName(), rule.getDoc(), rule.getKind(), rule.getMode(), rule.getType(), (Set)rule.getTags(), newParams, rule.getExpr(), rule.getOnSuccess(), rule.getOnFailure(), rule.isDisabled());
            newDomainRules.add(newRule);
        }
        return new RuleSet(ruleSet.getMigrationRules(), newDomainRules, ruleSet.getEncodingRules());
    }

    private static String scrub(String kmsKeyId) {
        String keyId = kmsKeyId.startsWith("arn:") ? kmsKeyId.substring(4) : kmsKeyId;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyId.length(); ++i) {
            char c = keyId.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') {
                sb.append(c);
                continue;
            }
            sb.append("-");
        }
        return sb.toString();
    }
}

