/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.aead.AeadKey;
import com.google.crypto.tink.aead.internal.LegacyFullAead;
import com.google.crypto.tink.internal.KeysetHandleInterface;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringClient;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrefixMap;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import com.google.crypto.tink.util.Bytes;
import java.security.GeneralSecurityException;

public class AeadWrapper
implements PrimitiveWrapper<Aead, Aead> {
    private static final AeadWrapper WRAPPER = new AeadWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, Aead> LEGACY_FULL_AEAD_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullAead::create, LegacyProtoKey.class, Aead.class);

    private static Bytes getOutputPrefix(Key key) throws GeneralSecurityException {
        if (key instanceof AeadKey) {
            return ((AeadKey)key).getOutputPrefix();
        }
        if (key instanceof LegacyProtoKey) {
            return ((LegacyProtoKey)key).getOutputPrefix();
        }
        throw new GeneralSecurityException("Cannot get output prefix for key of class " + key.getClass().getName() + " with parameters " + key.getParameters());
    }

    AeadWrapper() {
    }

    @Override
    public Aead wrap(PrimitiveSet<Aead> pset) throws GeneralSecurityException {
        MonitoringClient.Logger decLogger;
        MonitoringClient.Logger encLogger;
        PrefixMap.Builder<AeadWithId> builder = new PrefixMap.Builder<AeadWithId>();
        KeysetHandleInterface keysetHandle = pset.getKeysetHandle();
        for (int i = 0; i < keysetHandle.size(); ++i) {
            KeysetHandleInterface.Entry entry = keysetHandle.getAt(i);
            builder.put(AeadWrapper.getOutputPrefix(entry.getKey()), new AeadWithId(pset.getPrimitiveForEntry(entry), entry.getId()));
        }
        if (!pset.getAnnotations().isEmpty()) {
            MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
            encLogger = client.createLogger(keysetHandle, pset.getAnnotations(), "aead", "encrypt");
            decLogger = client.createLogger(keysetHandle, pset.getAnnotations(), "aead", "decrypt");
        } else {
            encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
        }
        return new WrappedAead(new AeadWithId(pset.getPrimitiveForEntry(keysetHandle.getPrimary()), keysetHandle.getPrimary().getId()), builder.build(), encLogger, decLogger);
    }

    @Override
    public Class<Aead> getPrimitiveClass() {
        return Aead.class;
    }

    @Override
    public Class<Aead> getInputPrimitiveClass() {
        return Aead.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_AEAD_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedAead
    implements Aead {
        private final AeadWithId primary;
        private final PrefixMap<AeadWithId> allAeads;
        private final MonitoringClient.Logger encLogger;
        private final MonitoringClient.Logger decLogger;

        private WrappedAead(AeadWithId primary, PrefixMap<AeadWithId> allAeads, MonitoringClient.Logger encLogger, MonitoringClient.Logger decLogger) {
            this.primary = primary;
            this.allAeads = allAeads;
            this.encLogger = encLogger;
            this.decLogger = decLogger;
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                byte[] result = this.primary.aead.encrypt(plaintext, associatedData);
                this.encLogger.log(this.primary.id, plaintext.length);
                return result;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            for (AeadWithId aeadWithId : this.allAeads.getAllWithMatchingPrefix(ciphertext)) {
                try {
                    byte[] result = aeadWithId.aead.decrypt(ciphertext, associatedData);
                    this.decLogger.log(aeadWithId.id, ciphertext.length);
                    return result;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }

    private static class AeadWithId {
        public final Aead aead;
        public final int id;

        public AeadWithId(Aead aead, int id) {
            this.aead = aead;
            this.id = id;
        }
    }
}

