/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.test.model.matchers.FormatMatchers;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class KeyFormatNode {
    private final Optional<String> format;
    private final Optional<WindowType> windowType;
    private final Optional<Long> windowSize;

    public KeyFormatNode(@JsonProperty(value="format") Optional<String> format, @JsonProperty(value="windowType") Optional<WindowType> windowType, @JsonProperty(value="windowSize") Optional<Long> windowSize) {
        this.format = Objects.requireNonNull(format, "format");
        this.windowType = Objects.requireNonNull(windowType);
        this.windowSize = Objects.requireNonNull(windowSize);
        this.build();
    }

    public Optional<String> getFormat() {
        return this.format;
    }

    public Optional<WindowType> getWindowType() {
        return this.windowType;
    }

    public Optional<Long> getWindowSize() {
        return this.windowSize;
    }

    Matcher<? super KeyFormat> build() {
        Matcher formatMatcher = this.format.map(FormatInfo::of).map(FormatFactory::of).map(Matchers::is).map(FormatMatchers.KeyFormatMatchers::hasFormat).orElse(null);
        Matcher<KeyFormat> windowTypeMatcher = FormatMatchers.KeyFormatMatchers.hasWindowType((Matcher<Optional<WindowType>>)Matchers.is(this.windowType));
        Matcher<KeyFormat> windowSizeMatcher = FormatMatchers.KeyFormatMatchers.hasWindowSize((Matcher<Optional<Duration>>)Matchers.is(this.windowSize.map(Duration::ofMillis)));
        Matcher[] matchers = (Matcher[])Stream.of(formatMatcher, windowTypeMatcher, windowSizeMatcher).filter(Objects::nonNull).toArray(Matcher[]::new);
        return Matchers.allOf((Matcher[])matchers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyFormatNode that = (KeyFormatNode)o;
        return this.format.equals(that.format) && this.windowType.equals(that.windowType) && this.windowSize.equals(that.windowSize);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.windowType, this.windowSize);
    }

    public static KeyFormatNode fromKeyFormat(KeyFormat keyFormat) {
        return new KeyFormatNode(Optional.of(keyFormat.getFormatInfo().getFormat()), keyFormat.getWindowType(), keyFormat.getWindowSize().map(Duration::toMillis));
    }
}

