/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.avro.AvroFormat;
import io.confluent.ksql.serde.protobuf.ProtobufFormat;
import io.confluent.ksql.test.model.TestHeader;
import io.confluent.ksql.test.model.WindowData;
import io.confluent.ksql.test.tools.Record;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.tools.exceptions.MissingFieldException;
import io.confluent.ksql.test.utils.JsonParsingUtil;
import io.confluent.ksql.util.BytesUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public final class RecordNode {
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    private static final SchemaTranslator protobufSchemaTranslator = new ProtobufFormat().getSchemaTranslator((Map)ImmutableMap.of());
    private static final SchemaTranslator avroSchemaTranslator = new AvroFormat().getSchemaTranslator((Map)ImmutableMap.of());
    private final String topicName;
    private final JsonNode key;
    private final JsonNode value;
    private final Optional<Long> timestamp;
    private final Optional<WindowData> window;
    private final Optional<List<TestHeader>> headers;

    @VisibleForTesting
    RecordNode(String topicName, JsonNode key, JsonNode value, Optional<Long> timestamp, Optional<WindowData> window, Optional<List<TestHeader>> headers) {
        this.topicName = topicName == null ? "" : topicName;
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
        this.window = Objects.requireNonNull(window, "window");
        this.headers = Objects.requireNonNull(headers, "headers");
        if (this.topicName.isEmpty()) {
            throw new MissingFieldException("topic");
        }
    }

    public String topicName() {
        return this.topicName;
    }

    public Record build() {
        return this.build(Optional.empty(), Optional.empty(), SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]), SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
    }

    public Record build(Optional<ParsedSchema> keySchema, Optional<ParsedSchema> valueSchema, SerdeFeatures keyFeatures, SerdeFeatures valueFeatures) {
        Object recordKey = this.buildJson(this.key);
        Object recordValue = this.buildJson(this.value);
        return new Record(this.topicName, keySchema.map(s -> this.coerceRecord(recordKey, (ParsedSchema)s, true, keyFeatures)).orElse(recordKey), this.key, valueSchema.map(s -> this.coerceRecord(recordValue, (ParsedSchema)s, false, valueFeatures)).orElse(recordValue), this.value, this.timestamp, this.window.orElse(null), this.headers);
    }

    public static RecordNode from(Record record) {
        return new RecordNode(record.getTopicName(), record.getJsonKey().orElse((JsonNode)NullNode.getInstance()), record.getJsonValue().orElse((JsonNode)NullNode.getInstance()), record.timestamp(), Optional.ofNullable(record.getWindow()), record.headers());
    }

    public Optional<WindowData> getWindow() {
        return this.window;
    }

    private Object buildJson(JsonNode contents) {
        if (contents instanceof NullNode) {
            return null;
        }
        if (contents instanceof TextNode) {
            return contents.asText();
        }
        try {
            return objectMapper.readValue(objectMapper.writeValueAsString((Object)contents), Object.class);
        }
        catch (IOException e) {
            throw new InvalidFieldException("value", "failed to parse", e);
        }
    }

    private Object coerceRecord(Object record, ParsedSchema schema, boolean isKey, SerdeFeatures features) {
        List columns;
        if (!(record instanceof Map)) {
            return record;
        }
        Map recordMap = (Map)record;
        switch (schema.schemaType()) {
            case "PROTOBUF": {
                columns = protobufSchemaTranslator.toColumns(schema, features, isKey);
                break;
            }
            case "AVRO": {
                columns = avroSchemaTranslator.toColumns(schema, features, isKey);
                break;
            }
            default: {
                return record;
            }
        }
        columns.forEach(c -> this.coerceColumn(recordMap, (SimpleColumn)c));
        return recordMap;
    }

    private void coerceColumn(Map<String, Object> record, SimpleColumn column) {
        String lowerCaseName = column.name().text().toLowerCase();
        String upperCaseName = column.name().text().toUpperCase();
        String name = record.containsKey(lowerCaseName) ? lowerCaseName : upperCaseName;
        Object value = record.get(name);
        if (value == null) {
            return;
        }
        switch (column.type().baseType()) {
            case BYTES: {
                if (!(value instanceof String)) break;
                record.put(name, BytesUtils.decode((String)((String)value), (BytesUtils.Encoding)BytesUtils.Encoding.BASE64));
                break;
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<RecordNode> {
        public void serialize(RecordNode record, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("topic", record.topicName);
            jsonGenerator.writeObjectField("key", (Object)record.key);
            jsonGenerator.writeObjectField("value", (Object)record.value);
            if (record.timestamp.isPresent()) {
                jsonGenerator.writeNumberField("timestamp", record.timestamp.get().longValue());
            }
            if (record.window.isPresent()) {
                jsonGenerator.writeObjectField("window", record.window);
            }
            if (record.headers.isPresent()) {
                jsonGenerator.writeObjectField("headers", record.headers.get());
            }
            jsonGenerator.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<RecordNode> {
        public RecordNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String topic = JsonParsingUtil.getRequired("topic", node, jp, String.class);
            Optional<JsonNode> key = JsonParsingUtil.getOptional("key", node, jp, JsonNode.class);
            JsonNode value = JsonParsingUtil.getRequired("value", node, jp, JsonNode.class);
            Optional<Long> timestamp = JsonParsingUtil.getOptional("timestamp", node, jp, Long.class);
            Optional<WindowData> window = JsonParsingUtil.getOptional("window", node, jp, WindowData.class);
            Optional<List<TestHeader>> headers = JsonParsingUtil.getOptional("headers", node, jp, new TypeReference<List<TestHeader>>(){});
            return new RecordNode(topic, key.orElse((JsonNode)NullNode.getInstance()), value, timestamp, window, headers);
        }
    }
}

