/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.ValueFormat;
import java.util.Objects;
import java.util.Optional;

public class SchemaNode {
    private final String logicalSchema;
    private final Optional<KeyFormat> keyFormat;
    private final Optional<ValueFormat> valueFormat;

    @JsonCreator
    public static SchemaNode create(@JsonProperty(value="schema", required=true) String logicalSchema, @JsonProperty(value="keyFormat") Optional<KeyFormat> keyFormat, @JsonProperty(value="valueFormat") Optional<ValueFormat> valueFormat) {
        return new SchemaNode(logicalSchema, keyFormat, valueFormat);
    }

    public SchemaNode(String logicalSchema, Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
        this.logicalSchema = Objects.requireNonNull(logicalSchema, "logicalSchema");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
    }

    public String getSchema() {
        return this.logicalSchema;
    }

    public Optional<KeyFormat> getKeyFormat() {
        return this.keyFormat;
    }

    public Optional<ValueFormat> getValueFormat() {
        return this.valueFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaNode that = (SchemaNode)o;
        return this.logicalSchema.equals(that.logicalSchema) && this.keyFormat.equals(that.keyFormat) && this.valueFormat.equals(that.valueFormat);
    }

    public int hashCode() {
        return Objects.hash(this.logicalSchema, this.keyFormat, this.valueFormat);
    }

    public String toString() {
        return "SchemaNode{logicalSchema='" + this.logicalSchema + "', keyFormat=" + String.valueOf(this.keyFormat) + ", valueFormat=" + String.valueOf(this.valueFormat) + "}";
    }

    public static SchemaNode fromSchemaInfo(QuerySchemas.SchemaInfo schemaInfo) {
        return new SchemaNode(schemaInfo.schema().toString(), schemaInfo.keyFormat(), schemaInfo.valueFormat());
    }
}

