/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.test.utils.SerdeUtil;
import io.confluent.ksql.tools.test.model.SchemaReference;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class SchemaReferencesNode {
    private static final ObjectMapper OBJECT_MAPPER = TestJsonMapper.INSTANCE.get();
    private final String name;
    private final String format;
    private final JsonNode schema;

    public SchemaReferencesNode(@JsonProperty(value="name") String name, @JsonProperty(value="format") String format, @JsonProperty(value="schema") JsonNode schema) {
        this.name = name;
        this.format = Objects.requireNonNull(format, "format");
        this.schema = Objects.requireNonNull(schema, "schema");
        SerdeUtil.buildSchema(schema, format);
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode getSchema() {
        return this.schema;
    }

    public SchemaReference build() {
        return new SchemaReference(this.name, SerdeUtil.buildSchema(this.schema, this.format).get());
    }

    public static SchemaReferencesNode from(SchemaReference schemaReferences) {
        return new SchemaReferencesNode(schemaReferences.getName(), schemaReferences.getSchema().schemaType(), SchemaReferencesNode.buildSchemaNode(schemaReferences.getSchema()));
    }

    private static JsonNode buildSchemaNode(ParsedSchema schema) {
        String canonical = schema.canonicalString();
        try {
            if (schema.schemaType().equals("PROTOBUF")) {
                return new TextNode(canonical);
            }
            return OBJECT_MAPPER.readTree(canonical);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

