/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.test.serde.SerdeSupplier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class ValueSpecJsonSerdeSupplier
implements SerdeSupplier<Object> {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    private static final ObjectMapper FLOAT_MAPPER = new ObjectMapper();
    private final ObjectMapper mapper;

    public ValueSpecJsonSerdeSupplier(Map<String, Object> properties) {
        this.mapper = (Boolean)properties.getOrDefault("use.exact.numeric.comparison", true) != false ? MAPPER : FLOAT_MAPPER;
    }

    @Override
    public Serializer<Object> getSerializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new ValueSpecJsonSerializer();
    }

    @Override
    public Deserializer<Object> getDeserializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new ValueSpecJsonDeserializer();
    }

    private final class ValueSpecJsonSerializer
    implements Serializer<Object> {
        private ValueSpecJsonSerializer() {
        }

        public void close() {
        }

        public void configure(Map<String, ?> properties, boolean b) {
        }

        public byte[] serialize(String topicName, Object spec) {
            if (spec == null) {
                return null;
            }
            try {
                JsonNode toSerialize = Converter.toJsonNode(spec);
                byte[] bytes = ValueSpecJsonSerdeSupplier.this.mapper.writeValueAsBytes((Object)toSerialize);
                return bytes;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class ValueSpecJsonDeserializer
    implements Deserializer<Object> {
        private ValueSpecJsonDeserializer() {
        }

        public void close() {
        }

        public void configure(Map<String, ?> properties, boolean b) {
        }

        public Object deserialize(String topicName, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                return ValueSpecJsonSerdeSupplier.this.mapper.readValue(data, Object.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class Converter<T> {
        private static final JsonNodeFactory JSON_NODE_FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)true);
        private static final List<Converter<?>> CONVERTORS = ImmutableList.of(Converter.converter(Boolean.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).booleanNode(arg_0)), Converter.converter(Integer.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(Long.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(Float.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(Double.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(BigDecimal.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(BigInteger.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).numberNode(arg_0)), Converter.converter(String.class, arg_0 -> ((JsonNodeFactory)JSON_NODE_FACTORY).textNode(arg_0)), Converter.converter(Collection.class, Converter::handleCollection), Converter.converter(Map.class, Converter::handleMap));
        private final Class<T> type;
        private final Function<T, JsonNode> mapper;

        static JsonNode toJsonNode(Object obj) {
            if (obj == null) {
                return JSON_NODE_FACTORY.nullNode();
            }
            List candidates = CONVERTORS.stream().filter(c -> c.handles(obj)).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                throw new UnsupportedOperationException("Test framework does not current handle " + String.valueOf(obj));
            }
            if (candidates.size() > 1) {
                throw new RuntimeException("Ambiguous handling of " + String.valueOf(obj));
            }
            return ((Converter)candidates.get(0)).convert(obj);
        }

        private boolean handles(Object obj) {
            return this.type.isAssignableFrom(obj.getClass());
        }

        private static <T> Converter<T> converter(Class<T> type, Function<T, JsonNode> mapper) {
            return new Converter<T>(type, mapper);
        }

        private Converter(Class<T> type, Function<T, JsonNode> mapper) {
            this.type = Objects.requireNonNull(type, "type");
            this.mapper = Objects.requireNonNull(mapper, "mapper");
        }

        private JsonNode convert(Object o) {
            T cast = this.type.cast(o);
            return this.mapper.apply(cast);
        }

        private static JsonNode handleCollection(Collection<?> collection) {
            ArrayNode list = JSON_NODE_FACTORY.arrayNode();
            for (Object element : collection) {
                list.add(Converter.toJsonNode(element));
            }
            return list;
        }

        private static JsonNode handleMap(Map<?, ?> map) {
            ObjectNode node = JSON_NODE_FACTORY.objectNode();
            if (map.isEmpty()) {
                return node;
            }
            map.forEach((k, v) -> {
                if (!(k instanceof String)) {
                    throw new UnsupportedOperationException("Test framework does not yet support maps with non-string keys");
                }
                node.set((String)k, Converter.toJsonNode(v));
            });
            return node;
        }
    }
}

