/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde.protobuf;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRConverter;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRProperties;
import io.confluent.ksql.test.serde.SerdeSupplier;
import io.confluent.ksql.test.serde.SpecToConnectConverter;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;

public class ValueSpecProtobufNoSRSerdeSupplier
implements SerdeSupplier<Object> {
    private final Schema keySchema;
    private final Schema valueSchema;
    private final ProtobufNoSRConverter keyConverter;
    private final ProtobufNoSRConverter valueConverter;

    public ValueSpecProtobufNoSRSerdeSupplier(LogicalSchema schema, ProtobufNoSRProperties properties) {
        this.keySchema = ConnectSchemas.columnsToConnectSchema((List)schema.key());
        this.valueSchema = ConnectSchemas.columnsToConnectSchema((List)schema.value());
        this.valueConverter = new ProtobufNoSRConverter(this.valueSchema);
        this.keyConverter = new ProtobufNoSRConverter(this.keySchema);
        ImmutableMap converterConfig = ImmutableMap.of((Object)"optional.for.nullables", (Object)properties.isNullableAsOptional(), (Object)"wrapper.for.nullables", (Object)properties.isNullableAsWrapper());
        this.keyConverter.configure((Map)converterConfig, true);
        this.valueConverter.configure((Map)converterConfig, false);
    }

    @Override
    public Serializer<Object> getSerializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        if (isKey) {
            return new ValueSpecProtobufNoSRSerializer(this.keyConverter, this.keySchema);
        }
        return new ValueSpecProtobufNoSRSerializer(this.valueConverter, this.valueSchema);
    }

    @Override
    public Deserializer<Object> getDeserializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        if (isKey) {
            return new ValueSpecProtobufNoSRDeserializer(this.keyConverter);
        }
        return new ValueSpecProtobufNoSRDeserializer(this.valueConverter);
    }

    private static final class ValueSpecProtobufNoSRSerializer
    implements Serializer<Object> {
        private final Schema schema;
        private final ProtobufNoSRConverter converter;

        ValueSpecProtobufNoSRSerializer(ProtobufNoSRConverter converter, Schema schema) {
            this.converter = converter;
            this.schema = schema;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, Object o) {
            byte[] bytes = this.converter.fromConnectData(topic, this.schema, SpecToConnectConverter.specToConnect(o, this.schema));
            return bytes;
        }
    }

    private static final class ValueSpecProtobufNoSRDeserializer
    implements Deserializer<Object> {
        private final ProtobufNoSRConverter converter;

        ValueSpecProtobufNoSRDeserializer(ProtobufNoSRConverter converter) {
            this.converter = converter;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public Object deserialize(String s, byte[] bytes) {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(s, bytes);
            return SpecToConnectConverter.connectToSpec(schemaAndValue.value(), schemaAndValue.schema(), false);
        }
    }
}

