/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde.protobuf;

import com.google.common.collect.ImmutableMap;
import io.confluent.connect.protobuf.ProtobufConverter;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.ksql.serde.protobuf.ProtobufProperties;
import io.confluent.ksql.serde.protobuf.ProtobufSchemaTranslator;
import io.confluent.ksql.test.serde.ConnectSerdeSupplier;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

public class ValueSpecProtobufSerdeSupplier
extends ConnectSerdeSupplier<ProtobufSchema> {
    private final ProtobufSchemaTranslator schemaTranslator;
    private final ImmutableMap<String, Boolean> converterConfig;

    public ValueSpecProtobufSerdeSupplier(ProtobufProperties protobufProperties) {
        super(ProtobufConverter::new);
        this.schemaTranslator = new ProtobufSchemaTranslator(protobufProperties);
        this.converterConfig = ImmutableMap.of((Object)"optional.for.nullables", (Object)protobufProperties.isNullableAsOptional(), (Object)"wrapper.for.nullables", (Object)protobufProperties.isNullableAsWrapper());
    }

    @Override
    protected Schema fromParsedSchema(ProtobufSchema schema) {
        return this.schemaTranslator.toConnectSchema((ParsedSchema)schema);
    }

    @Override
    protected void configureConverter(Converter c, boolean isKey) {
        c.configure((Map)ImmutableMap.builder().putAll(this.converterConfig).put((Object)"schema.registry.url", (Object)"foo").build(), isKey);
    }
}

