/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.test.model.TestHeader;
import io.confluent.ksql.test.model.WindowData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public class Record {
    private final String topicName;
    private final Object key;
    private final Object value;
    private final Optional<Long> timestamp;
    private final WindowData window;
    private final Optional<JsonNode> jsonValue;
    private final Optional<JsonNode> jsonKey;
    private final Optional<List<TestHeader>> headers;

    public Record(String topicName, Object key, JsonNode jsonKey, Object value, JsonNode jsonValue, Optional<Long> timestamp, WindowData window, Optional<List<TestHeader>> headers) {
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.key = key;
        this.jsonKey = Optional.ofNullable(jsonKey);
        this.value = value;
        this.jsonValue = Optional.ofNullable(jsonValue);
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
        this.window = window;
        this.headers = Objects.requireNonNull(headers);
        if (!topicName.trim().equals(topicName)) {
            throw new IllegalArgumentException("Record topic names must not start or end with whitespace: '" + topicName + "'");
        }
        if (topicName.isEmpty()) {
            throw new IllegalArgumentException("Record topic name can not be empty");
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Object rawKey() {
        return this.key;
    }

    public Object key() {
        if (this.window == null) {
            return this.key;
        }
        SessionWindow w = this.window.type == WindowData.Type.SESSION ? new SessionWindow(this.window.start, this.window.end) : new TimeWindow(this.window.start, this.window.end);
        return new Windowed(this.key, (Window)w);
    }

    public Object value() {
        return this.value;
    }

    public Optional<Long> timestamp() {
        return this.timestamp;
    }

    public WindowData getWindow() {
        return this.window;
    }

    public Optional<JsonNode> getJsonKey() {
        return this.jsonKey;
    }

    public Optional<JsonNode> getJsonValue() {
        return this.jsonValue;
    }

    public Optional<List<TestHeader>> headers() {
        return this.headers;
    }

    public Optional<List<Header>> headersAsHeaders() {
        return this.headers.map(ArrayList::new);
    }

    public Record withKeyValue(Object key, Object value) {
        return new Record(this.topicName, key, this.jsonKey.orElse(null), value, this.jsonValue.orElse(null), this.timestamp, this.window, this.headers);
    }

    public ProducerRecord<Object, Object> asProducerRecord() {
        return new ProducerRecord(this.topicName, Integer.valueOf(0), this.timestamp.orElse(0L), this.key(), this.value, (Iterable)this.headers.orElse((List<TestHeader>)ImmutableList.of()));
    }
}

