/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.InternalFunctionRegistry;
import io.confluent.ksql.test.model.ExpectedExceptionNode;
import io.confluent.ksql.test.model.PostConditionsNode;
import io.confluent.ksql.test.model.RecordNode;
import io.confluent.ksql.test.model.TestCaseNode;
import io.confluent.ksql.test.model.TopicNode;
import io.confluent.ksql.test.tools.Record;
import io.confluent.ksql.test.tools.TestCase;
import io.confluent.ksql.test.tools.TestCaseBuilderUtil;
import io.confluent.ksql.test.tools.VersionBounds;
import io.confluent.ksql.test.tools.conditions.PostConditions;
import io.confluent.ksql.tools.test.model.TestLocation;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.KsqlConfig;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;

public final class TestCaseBuilder {
    private TestCaseBuilder() {
    }

    public static List<TestCase> buildTests(TestCaseNode test, Path originalFileName, Function<String, TestLocation> testLocator) {
        if (!test.isEnabled()) {
            return ImmutableList.of();
        }
        try {
            Map.Entry overwrite;
            List configs;
            List formats;
            LinkedList<TestCase> testCases = new LinkedList<TestCase>();
            List list = formats = test.formats().isEmpty() ? Collections.singletonList(Optional.empty()) : test.formats().stream().map(Optional::of).collect(Collectors.toList());
            if (test.config().isEmpty()) {
                configs = Collections.singletonList(Optional.empty());
                overwrite = null;
            } else {
                configs = test.config().stream().map(Optional::of).collect(Collectors.toList());
                overwrite = (Map.Entry)Iterables.getOnlyElement((Iterable)test.properties().entrySet().stream().filter(e -> {
                    Object v = e.getValue();
                    return v instanceof String && "{CONFIG}".equalsIgnoreCase((String)v);
                }).collect(Collectors.toList()));
            }
            for (Optional<String> optional : formats) {
                for (Optional config : configs) {
                    Optional<Object> cfg;
                    TestLocation location = testLocator.apply(test.name());
                    HashMap<String, Object> updatedProperties = new HashMap<String, Object>(test.properties());
                    if (config.isPresent()) {
                        updatedProperties.put((String)overwrite.getKey(), config.get());
                        cfg = Optional.of((String)overwrite.getKey() + "=" + (String)config.get());
                    } else {
                        cfg = Optional.empty();
                    }
                    testCases.add(TestCaseBuilder.createTest(new TestCaseNode(test, updatedProperties), originalFileName, location, optional, cfg));
                }
            }
            return testCases;
        }
        catch (Exception e2) {
            throw new AssertionError("Invalid test '" + test.name() + "': " + e2.getMessage(), e2);
        }
    }

    private static TestCase createTest(TestCaseNode test, Path originalFileName, TestLocation location, Optional<String> explicitFormat, Optional<String> config) {
        String testName = TestCaseBuilderUtil.buildTestName(originalFileName, test.name(), explicitFormat, config);
        try {
            VersionBounds versionBounds = test.versionBounds().build();
            List<String> statements = TestCaseBuilderUtil.buildStatements(test.statements(), explicitFormat);
            Optional<Matcher<Throwable>> ee = test.expectedException().map(ExpectedExceptionNode::build);
            Map<String, Topic> topics = TestCaseBuilderUtil.getAllTopics(statements, test.topics().stream().map(TopicNode::build).collect(Collectors.toList()), test.outputs().stream().map(RecordNode::build).collect(Collectors.toList()), test.inputs().stream().map(RecordNode::build).collect(Collectors.toList()), (FunctionRegistry)new InternalFunctionRegistry(), new KsqlConfig(test.properties())).stream().collect(Collectors.toMap(t -> t.getName().toLowerCase(), t -> t));
            List<Record> inputRecords = test.inputs().stream().map(r -> {
                String topicName = r.topicName().toLowerCase();
                if (topics.containsKey(topicName)) {
                    return r.build(((Topic)topics.get(topicName)).getKeySchema(), ((Topic)topics.get(topicName)).getValueSchema(), ((Topic)topics.get(topicName)).getKeyFeatures(), ((Topic)topics.get(topicName)).getValueFeatures());
                }
                return r.build();
            }).collect(Collectors.toList());
            List<Record> outputRecords = test.outputs().stream().map(RecordNode::build).collect(Collectors.toList());
            PostConditions post = test.postConditions().map(PostConditionsNode::build).orElse(PostConditions.NONE);
            return new TestCase(location, originalFileName, testName, versionBounds, test.properties(), topics.values(), inputRecords, outputRecords, statements, ee, post);
        }
        catch (Exception e) {
            throw new AssertionError(testName + ": Invalid test. " + e.getMessage(), e);
        }
    }
}

