/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;

public final class TopologyTestDriverContainer {
    private final TopologyTestDriver topologyTestDriver;
    private final Map<String, TestInputTopic<byte[], byte[]>> sourceTopics;
    private final Optional<String> sinkTopicName;
    private final Map<String, TestOutputTopic<byte[], byte[]>> sinkTopics = new HashMap<String, TestOutputTopic<byte[], byte[]>>();

    public static TopologyTestDriverContainer of(TopologyTestDriver topologyTestDriver, List<Topic> sourceTopics, Optional<Topic> sinkTopic) {
        return new TopologyTestDriverContainer(topologyTestDriver, sourceTopics, sinkTopic);
    }

    private TopologyTestDriverContainer(TopologyTestDriver topologyTestDriver, List<Topic> sourceTopics, Optional<Topic> sinkTopic) {
        this.topologyTestDriver = Objects.requireNonNull(topologyTestDriver, "topologyTestDriver");
        Objects.requireNonNull(sourceTopics, "sourceTopics");
        this.sourceTopics = sourceTopics.stream().map(topic -> Pair.of((Object)topic.getName(), (Object)topologyTestDriver.createInputTopic(topic.getName(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.sinkTopicName = Objects.requireNonNull(sinkTopic, "sinkTopic").map(Topic::getName);
        this.sinkTopicName.ifPresent(topicName -> this.sinkTopics.put((String)topicName, (TestOutputTopic<byte[], byte[]>)topologyTestDriver.createOutputTopic(topicName, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer())));
    }

    TopologyTestDriver getTopologyTestDriver() {
        return this.topologyTestDriver;
    }

    public TestInputTopic<byte[], byte[]> getSourceTopic(String topicName) {
        return this.sourceTopics.get(topicName);
    }

    public TestOutputTopic<byte[], byte[]> getSinkTopic(String topicName) {
        return this.sinkTopics.computeIfAbsent(topicName, t -> this.topologyTestDriver.createOutputTopic(t, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
    }

    public Optional<String> getSinkTopicName() {
        return this.sinkTopicName;
    }

    public Set<String> getSourceTopicNames() {
        return this.sourceTopics.keySet();
    }

    public void close() {
        this.topologyTestDriver.close();
    }
}

