/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools.stubs;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class StubKafkaService {
    private final Map<String, Topic> topicMap = new HashMap<String, Topic>();
    private final Map<String, List<ProducerRecord<byte[], byte[]>>> producedRecords = new HashMap<String, List<ProducerRecord<byte[], byte[]>>>();

    public static StubKafkaService create() {
        return new StubKafkaService();
    }

    private StubKafkaService() {
    }

    public void ensureTopic(Topic topic) {
        this.topicMap.put(topic.getName(), topic);
        this.producedRecords.putIfAbsent(topic.getName(), new ArrayList());
    }

    public void writeRecord(ProducerRecord<byte[], byte[]> record) {
        this.requireTopicExists(record.topic());
        this.producedRecords.get(record.topic()).add(record);
    }

    public List<ProducerRecord<byte[], byte[]>> readRecords(String topicName) {
        this.requireTopicExists(topicName);
        return ImmutableList.copyOf((Collection)this.producedRecords.get(topicName));
    }

    public void requireTopicExists(String topicName) {
        if (!this.topicMap.containsKey(topicName)) {
            throw new KsqlException("Topic does not exist: " + topicName);
        }
    }

    public Topic getTopic(String topicName) {
        return this.topicMap.get(topicName);
    }

    public Collection<Topic> getAllTopics() {
        return this.topicMap.values();
    }
}

