/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.ksql.test.tools.exceptions.MissingFieldException;
import java.io.IOException;
import java.util.Optional;

public final class JsonParsingUtil {
    private JsonParsingUtil() {
    }

    public static <T> T getRequired(String name, JsonNode node, JsonParser jp, Class<T> type) throws IOException {
        if (!node.has(name)) {
            throw new MissingFieldException(name);
        }
        return JsonParsingUtil.getNode(name, node, jp, type);
    }

    public static <T> Optional<T> getOptional(String name, JsonNode node, JsonParser jp, Class<T> type) throws IOException {
        if (!node.has(name)) {
            return Optional.empty();
        }
        return Optional.ofNullable(JsonParsingUtil.getNode(name, node, jp, type));
    }

    public static <T> Optional<T> getOptional(String name, JsonNode node, JsonParser jp, TypeReference<T> type) throws IOException {
        if (!node.has(name)) {
            return Optional.empty();
        }
        return Optional.ofNullable(JsonParsingUtil.getNode(name, node, jp, type));
    }

    public static <T> T getOrElse(String name, JsonNode node, JsonParser jp, Class<T> type, T defaultValue) throws IOException {
        return JsonParsingUtil.getOptionalOrElse(name, node, jp, type, defaultValue).orElse(defaultValue);
    }

    public static <T> Optional<T> getOptionalOrElse(String name, JsonNode node, JsonParser jp, Class<T> type, T defaultValue) throws IOException {
        if (!node.has(name)) {
            return Optional.empty();
        }
        T t = JsonParsingUtil.getOptional(name, node, jp, type).orElse(defaultValue);
        return Optional.of(t);
    }

    private static <T> T getNode(String name, JsonNode node, JsonParser jp, TypeReference<T> type) throws IOException {
        return (T)node.get(name).traverse(jp.getCodec()).readValueAs(type);
    }

    private static <T> T getNode(String name, JsonNode node, JsonParser jp, Class<T> type) throws IOException {
        return (T)node.get(name).traverse(jp.getCodec()).readValueAs(type);
    }
}

