/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSubTypes(value={})
public class CommandId {
    private final Type type;
    private final String entity;
    private final Action action;

    public CommandId(Type type, String entity, Action action) {
        this.type = type;
        this.entity = entity;
        this.action = action;
    }

    public CommandId(String type, String entity, String action) {
        this(Type.valueOf(type.toUpperCase()), entity, Action.valueOf(action.toUpperCase()));
    }

    @JsonCreator
    public static CommandId fromString(String fromString) {
        String[] splitOnSlash = fromString.split("/", 3);
        if (splitOnSlash.length != 3) {
            throw new IllegalArgumentException("Expected a string of the form <type>/<entity>/<action>");
        }
        return new CommandId(splitOnSlash[0], splitOnSlash[1], splitOnSlash[2]);
    }

    public Type getType() {
        return this.type;
    }

    public String getEntity() {
        return this.entity;
    }

    public Action getAction() {
        return this.action;
    }

    @JsonValue
    public String toString() {
        return String.format("%s/%s/%s", this.type.toString().toLowerCase(), this.entity, this.action.toString().toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandId commandId = (CommandId)o;
        return this.type == commandId.type && Objects.equals(this.entity, commandId.entity) && this.action == commandId.action;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.entity, this.action});
    }

    public static enum Type {
        TOPIC,
        STREAM,
        TABLE,
        CLUSTER,
        PAUSE,
        RESUME,
        TERMINATE,
        TYPE;

    }

    public static enum Action {
        CREATE,
        DROP,
        EXECUTE,
        TERMINATE,
        ALTER;

    }
}

