/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;

public enum ConnectorType {
    SOURCE,
    SINK,
    UNKNOWN;


    public static ConnectorType from(Class<? extends Connector> clazz) {
        if (SinkConnector.class.isAssignableFrom(clazz)) {
            return SINK;
        }
        return SourceConnector.class.isAssignableFrom(clazz) ? SOURCE : UNKNOWN;
    }

    @JsonValue
    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    @JsonCreator
    public static ConnectorType forValue(String value) {
        return ConnectorType.valueOf(value.toUpperCase(Locale.ROOT));
    }
}

